/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.serializers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.BitUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaMethodStubSerializer
implements StubSerializer<PsiMethodStub> {
    @NotNull
    private final IJavaElementType myType;

    public JavaMethodStubSerializer(@NotNull IJavaElementType elementType) {
        if (elementType == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(0);
        }
        this.myType = elementType;
    }

    @Override
    public void serialize(@NotNull PsiMethodStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(1);
        }
        if (dataStream == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(2);
        }
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getReturnTypeText());
        dataStream.writeByte(((PsiMethodStubImpl)stub).getFlags());
        if (stub.isAnnotationMethod()) {
            dataStream.writeName(stub.getDefaultValueText());
        }
    }

    @Override
    @NotNull
    public PsiMethodStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(3);
        }
        String name = dataStream.readNameString();
        TypeInfo type = TypeInfo.readTYPE(dataStream);
        byte flags = dataStream.readByte();
        String defaultMethodValue = PsiMethodStubImpl.isAnnotationMethod(flags) ? dataStream.readNameString() : null;
        return new PsiMethodStubImpl(parentStub, name, type, flags, defaultMethodValue);
    }

    @Override
    public void indexStub(@NotNull PsiMethodStub stub, @NotNull IndexSink sink) {
        String name;
        if (stub == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(5);
        }
        if ((name = stub.getName()) != null) {
            sink.occurrence(JavaStubIndexKeys.METHODS, name);
            if (RecordUtil.isStaticNonPrivateMember(stub)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, name);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, stub.getReturnTypeText().getShortTypeText());
            }
        }
        Set<String> methodTypeParams = JavaMethodStubSerializer.getVisibleTypeParameters(stub);
        for (StubElement<?> stubElement : stub.getChildrenStubs()) {
            if (!(stubElement instanceof PsiParameterListStub)) continue;
            for (StubElement<?> paramStub : stubElement.getChildrenStubs()) {
                TypeInfo type;
                String typeName;
                if (!(paramStub instanceof PsiParameterStub) || TypeConversionUtil.isPrimitive(typeName = PsiNameHelper.getShortClassName((type = ((PsiParameterStub)paramStub).getType()).text())) || TypeConversionUtil.isPrimitiveWrapper(typeName) || methodTypeParams.contains(typeName)) continue;
                sink.occurrence(JavaStubIndexKeys.METHOD_TYPES, typeName);
            }
        }
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string = "java." + String.valueOf(this.myType);
        if (string == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static Set<String> getVisibleTypeParameters(@NotNull StubElement<?> stub) {
        if (stub == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(7);
        }
        HashSet<String> result = null;
        while (stub != null) {
            Set<String> names = JavaMethodStubSerializer.getOwnTypeParameterNames(stub);
            if (!names.isEmpty()) {
                if (result == null) {
                    result = new HashSet<String>();
                }
                result.addAll(names);
            }
            if (JavaMethodStubSerializer.isStatic(stub)) break;
            stub = stub.getParentStub();
        }
        Set<String> set = result == null ? Collections.emptySet() : result;
        if (set == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static boolean isStatic(@NotNull StubElement<?> stub) {
        StubElement<PsiElement> modList;
        if (stub == null) {
            JavaMethodStubSerializer.$$$reportNull$$$0(9);
        }
        if (stub instanceof PsiMemberStub && (modList = stub.findChildStubByElementType(JavaStubElementTypes.MODIFIER_LIST)) != null) {
            return BitUtil.isSet(((PsiModifierListStub)modList).getModifiersMask(), ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.getInt("static"));
        }
        return false;
    }

    private static Set<String> getOwnTypeParameterNames(StubElement<?> stubElement) {
        StubElement<PsiElement> typeParamList = stubElement.findChildStubByElementType(JavaStubElementTypes.TYPE_PARAMETER_LIST);
        if (typeParamList == null) {
            return Collections.emptySet();
        }
        HashSet<String> methodTypeParams = null;
        List<StubElement<?>> children2 = typeParamList.getChildrenStubs();
        for (StubElement<?> child : children2) {
            if (!(child instanceof PsiTypeParameterStub)) continue;
            if (methodTypeParams == null) {
                methodTypeParams = new HashSet<String>();
            }
            methodTypeParams.add(((PsiTypeParameterStub)child).getName());
        }
        return methodTypeParams == null ? Collections.emptySet() : methodTypeParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/serializers/JavaMethodStubSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/serializers/JavaMethodStubSerializer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleTypeParameters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

