/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaClassInheritorsSearcher;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.RelaxedDirectInheritorChecker;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<? super PsiClass> processor) {
        if (parameters == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(1);
        }
        if (!parameters.shouldSearchInLanguage((Language)JavaLanguage.INSTANCE)) {
            return true;
        }
        PsiClass baseClass = JavaDirectInheritorsSearcher.getClassToSearch(parameters);
        assert (parameters.isCheckInheritance());
        SearchScope scope = parameters.getScope();
        Project project = PsiUtilCore.getProjectInReadAction(baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            SearchScope useScope = ReadAction.compute(baseClass::getUseScope);
            SearchScope actualScope = useScope.intersectWith(scope);
            return AllClassesSearch.search((SearchScope)actualScope, (Project)project).allowParallelProcessing().forEach(psiClass -> {
                ProgressManager.checkCanceled();
                if (JavaDirectInheritorsSearcher.shortCircuitCandidate(psiClass)) {
                    return true;
                }
                return processor.process((PsiClass)psiClass);
            });
        }
        PsiClass[] cache2 = JavaDirectInheritorsSearcher.getOrCalculateDirectSubClasses(project, baseClass, parameters);
        if (cache2.length == 0) {
            return true;
        }
        VirtualFile baseClassJarFile = null;
        int groupStart = 0;
        boolean sameJarClassFound = false;
        String currentFQN = null;
        boolean[] isOutOfScope = new boolean[cache2.length];
        for (int i = 0; i < cache2.length; ++i) {
            ProgressManager.checkCanceled();
            PsiClass subClass = cache2[i];
            if (subClass instanceof PsiAnonymousClass && !parameters.includeAnonymous()) {
                return JavaDirectInheritorsSearcher.flushCurrentGroup(cache2, isOutOfScope, sameJarClassFound, groupStart, i, processor);
            }
            if (!JavaDirectInheritorsSearcher.isInScope(scope, subClass)) {
                isOutOfScope[i] = true;
                continue;
            }
            String fqn = ReadAction.compute(subClass::getQualifiedName);
            if (currentFQN != null && Objects.equals(fqn, currentFQN)) {
                boolean fromSameJar;
                VirtualFile currentJarFile = JavaDirectInheritorsSearcher.getJarFile(subClass);
                if (baseClassJarFile == null) {
                    baseClassJarFile = JavaDirectInheritorsSearcher.getJarFile(baseClass);
                }
                if (!(fromSameJar = Comparing.equal(currentJarFile, baseClassJarFile))) continue;
                if (!processor.process(subClass)) {
                    return false;
                }
                sameJarClassFound = true;
                continue;
            }
            currentFQN = fqn;
            if (!JavaDirectInheritorsSearcher.flushCurrentGroup(cache2, isOutOfScope, sameJarClassFound, groupStart, i, processor)) {
                return false;
            }
            groupStart = i;
            sameJarClassFound = false;
        }
        return JavaDirectInheritorsSearcher.flushCurrentGroup(cache2, isOutOfScope, sameJarClassFound, groupStart, cache2.length, processor);
    }

    private static boolean flushCurrentGroup(PsiClass @NotNull [] cache2, boolean @NotNull [] isOutOfScope, boolean sameJarClassFound, int groupStart, int afterGroup, @NotNull Processor<? super PsiClass> processor) {
        if (processor == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(2);
        }
        if (cache2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(3);
        }
        if (isOutOfScope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(4);
        }
        if (!sameJarClassFound) {
            for (int g = groupStart; g < afterGroup; ++g) {
                ProgressManager.checkCanceled();
                if (isOutOfScope[g] || processor.process(cache2[g])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean shortCircuitCandidate(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(5);
        }
        return ReadAction.compute(() -> {
            if (psiClass.isInterface()) {
                return false;
            }
            PsiClass superClass = psiClass.getSuperClass();
            if (superClass == null || !superClass.isValid()) {
                return true;
            }
            boolean isJavaLangObject = "java.lang.Object".equals(superClass.getQualifiedName());
            return !isJavaLangObject;
        });
    }

    private static PsiClass getClassToSearch(@NotNull DirectClassInheritorsSearch.SearchParameters parameters) {
        if (parameters == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(6);
        }
        return ReadAction.compute(() -> (PsiClass)PsiUtil.preferCompiledElement(parameters.getClassToProcess()));
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiClass subClass) {
        if (scope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(7);
        }
        if (subClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(8);
        }
        return ReadAction.compute(() -> PsiSearchScopeUtil.isInScope(scope, (PsiElement)subClass));
    }

    private static PsiClass @NotNull [] getOrCalculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull DirectClassInheritorsSearch.SearchParameters parameters) {
        List sealedInheritors;
        if (project == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(9);
        }
        if (baseClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(10);
        }
        if (parameters == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(11);
        }
        if ((sealedInheritors = ReadAction.compute(() -> DumbService.getInstance(project).computeWithAlternativeResolveEnabled(() -> JavaDirectInheritorsSearcher.processSealed(baseClass)))) != null && parameters.restrictSealedHierarchy()) {
            PsiClass[] psiClassArray = sealedInheritors.toArray(PsiClass.EMPTY_ARRAY);
            if (psiClassArray == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(12);
            }
            return psiClassArray;
        }
        ConcurrentMap<PsiClass, PsiClass[]> map2 = HighlightingCaches.getInstance((Project)project).DIRECT_SUB_CLASSES;
        PsiClass[] cache2 = (PsiClass[])map2.get(baseClass);
        if (cache2 == null) {
            String baseClassName = ReadAction.compute(baseClass::getName);
            if (StringUtil.isEmpty(baseClassName)) {
                if (PsiClass.EMPTY_ARRAY == null) {
                    JavaDirectInheritorsSearcher.$$$reportNull$$$0(13);
                }
                return PsiClass.EMPTY_ARRAY;
            }
            cache2 = JavaDirectInheritorsSearcher.calculateDirectSubClasses(project, baseClass, baseClassName, parameters);
            if (ReadAction.compute(baseClass::isPhysical).booleanValue()) {
                cache2 = ConcurrencyUtil.cacheOrGet(map2, baseClass, cache2);
            }
        }
        if (sealedInheritors != null) {
            PsiClass[] psiClassArray = (PsiClass[])Stream.concat(sealedInheritors.stream(), Stream.of(cache2)).distinct().toArray(PsiClass[]::new);
            if (psiClassArray == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(14);
            }
            return psiClassArray;
        }
        if (cache2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(15);
        }
        return cache2;
    }

    private static <T> void processConcurrentlyIfTooMany(@NotNull Collection<? extends T> collection, @NotNull Processor<? super T> processor) {
        int size;
        if (collection == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(17);
        }
        if ((size = collection.size()) == 0) {
            return;
        }
        if (size > 100) {
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<T>(collection), ProgressIndicatorProvider.getGlobalProgressIndicator(), processor);
        } else {
            ContainerUtil.process(collection, processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static PsiClass @NotNull [] calculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull String baseClassName, @NotNull DirectClassInheritorsSearch.SearchParameters parameters) {
        if (project == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(18);
        }
        if (baseClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(19);
        }
        if (baseClassName == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(20);
        }
        if (parameters == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(21);
        }
        DumbService dumbService = DumbService.getInstance(project);
        CompilerDirectHierarchyInfo info = JavaDirectInheritorsSearcher.performSearchUsingCompilerIndices(parameters, project);
        SearchScope useScope = ReadAction.compute(() -> {
            SearchScope resultScope = PsiSearchHelper.getInstance((Project)project).getUseScope((PsiElement)baseClass);
            if (info == null) {
                return resultScope;
            }
            return resultScope.intersectWith(info.getDirtyScope());
        });
        GlobalSearchScope globalUseScope = ReadAction.compute(() -> new JavaSourceFilterScope(GlobalSearchScopeUtil.toGlobalSearchScope(useScope, project)));
        Collection candidates = dumbService.runReadActionInSmartMode(() -> JavaSuperClassNameOccurenceIndex.getInstance().getOccurrences(baseClassName, project, globalUseScope));
        RelaxedDirectInheritorChecker checker = dumbService.runReadActionInSmartMode(() -> new RelaxedDirectInheritorChecker(baseClass));
        HashMap classesWithFqn = new HashMap();
        ArrayList<PsiEnumConstantInitializer> anonymous = new ArrayList<PsiEnumConstantInitializer>();
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(candidates, referenceList -> {
            ProgressManager.checkCanceled();
            dumbService.runReadActionInSmartMode(() -> {
                PsiClass candidate;
                PsiElement parent = referenceList.getParent();
                if (parent instanceof PsiClass && checker.checkInheritance(candidate = (PsiClass)parent)) {
                    String fqn = candidate.getQualifiedName();
                    Map map2 = classesWithFqn;
                    synchronized (map2) {
                        if (candidate instanceof PsiAnonymousClass) {
                            anonymous.add((PsiEnumConstantInitializer)((PsiAnonymousClass)candidate));
                            return;
                        }
                        Object value = classesWithFqn.get(fqn);
                        if (value == null) {
                            classesWithFqn.put(fqn, candidate);
                        } else if (value instanceof PsiClass) {
                            ArrayList<PsiClass> list = new ArrayList<PsiClass>();
                            list.add((PsiClass)value);
                            list.add(candidate);
                            classesWithFqn.put(fqn, list);
                        } else {
                            List list = (List)value;
                            list.add(candidate);
                        }
                    }
                }
            });
            return true;
        });
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        HashMap hashMap = classesWithFqn;
        // MONITORENTER : hashMap
        for (Object value : classesWithFqn.values()) {
            if (value instanceof PsiClass) {
                result.add((PsiClass)value);
                continue;
            }
            List list = (List)value;
            result.addAll(list);
        }
        // MONITOREXIT : hashMap
        Collection anonymousCandidates = dumbService.runReadActionInSmartMode(() -> JavaAnonymousClassBaseRefOccurenceIndex.getInstance().getOccurences(baseClassName, project, globalUseScope));
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(anonymousCandidates, candidate -> {
            if (dumbService.runReadActionInSmartMode(() -> checker.checkInheritance((PsiClass)candidate)).booleanValue()) {
                List list = result;
                synchronized (list) {
                    anonymous.add((PsiEnumConstantInitializer)candidate);
                }
            }
            return true;
        });
        boolean isEnum = ReadAction.compute(baseClass::isEnum);
        if (isEnum) {
            PsiField[] fields;
            for (PsiField field : fields = ReadAction.compute(baseClass::getFields)) {
                ProgressManager.checkCanceled();
                if (!(field instanceof PsiEnumConstant)) continue;
                PsiEnumConstantInitializer initializingClass = ReadAction.compute(((PsiEnumConstant)field)::getInitializingClass);
                if (initializingClass == null) continue;
                ArrayList<PsiClass> arrayList = result;
                // MONITORENTER : arrayList
                anonymous.add(initializingClass);
                // MONITOREXIT : arrayList
            }
        }
        if (info != null) {
            info.getHierarchyChildren().forEach(aClass -> {
                if (aClass instanceof PsiAnonymousClass) {
                    anonymous.add((PsiEnumConstantInitializer)((PsiAnonymousClass)aClass));
                } else if (aClass instanceof PsiClass) {
                    result.add((PsiClass)aClass);
                }
            });
        }
        ArrayList<PsiClass> arrayList = result;
        // MONITORENTER : arrayList
        if (result.isEmpty() && anonymous.isEmpty()) {
            // MONITOREXIT : arrayList
            if (PsiClass.EMPTY_ARRAY != null) return PsiClass.EMPTY_ARRAY;
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(22);
            return PsiClass.EMPTY_ARRAY;
        }
        result.addAll(anonymous);
        PsiClass[] psiClassArray = result.toArray(PsiClass.EMPTY_ARRAY);
        // MONITOREXIT : arrayList
        if (psiClassArray != null) return psiClassArray;
        JavaDirectInheritorsSearcher.$$$reportNull$$$0(23);
        return psiClassArray;
    }

    @Nullable
    private static List<PsiClass> processSealed(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(24);
        }
        if (!baseClass.hasModifierProperty("sealed")) {
            return null;
        }
        PsiReferenceList permitsList = baseClass.getPermitsList();
        if (permitsList == null) {
            PsiFile file = baseClass.getContainingFile();
            ArrayList<PsiClass> result = new ArrayList<PsiClass>();
            if (file instanceof PsiClassOwner) {
                PsiClassOwner owner = (PsiClassOwner)file;
                ArrayDeque queue = new ArrayDeque();
                Collections.addAll(queue, owner.getClasses());
                while (!queue.isEmpty()) {
                    PsiClass aClass = (PsiClass)queue.pop();
                    if (aClass.isInheritor(baseClass, false)) {
                        result.add(aClass);
                    }
                    Collections.addAll(queue, aClass.getInnerClasses());
                    for (PsiField field : aClass.getFields()) {
                        if (!(field instanceof PsiEnumConstant)) continue;
                        PsiEnumConstant constant = (PsiEnumConstant)field;
                        ContainerUtil.addIfNotNull(queue, constant.getInitializingClass());
                    }
                }
            }
            return result;
        }
        return Arrays.stream(permitsList.getReferencedTypes()).map(PsiClassType::resolve).filter(Predicates.nonNull()).toList();
    }

    private static VirtualFile getJarFile(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(25);
        }
        return ReadAction.compute(() -> PsiUtil.getJarFile(aClass));
    }

    @Nullable
    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull DirectClassInheritorsSearch.SearchParameters parameters, @NotNull Project project) {
        SearchScope scope;
        if (parameters == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(26);
        }
        if (project == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(27);
        }
        if (!((scope = parameters.getScope()) instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstanceIfEnabled(project);
        if (compilerReferenceService == null) {
            return null;
        }
        return compilerReferenceService.getDirectInheritors(JavaDirectInheritorsSearcher.getClassToSearch(parameters), (GlobalSearchScope)scope, JavaFileType.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 15, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isOutOfScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 9: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCalculateDirectSubClasses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDirectSubClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "flushCurrentGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shortCircuitCandidate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getClassToSearch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrCalculateDirectSubClasses";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processConcurrentlyIfTooMany";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calculateDirectSubClasses";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processSealed";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getJarFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "performSearchUsingCompilerIndices";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 15, 22, 23 -> new IllegalStateException(string);
        };
    }
}

