/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.stubs.StubInconsistencyReporter;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance(JavaFunctionalExpressionSearcher.class);
    public static final int SMART_SEARCH_THRESHOLD = 5;

    @Override
    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters p, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        if (p == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(1);
        }
        if (SearchScope.isEmptyScope(ReadAction.compute(() -> p.getEffectiveSearchScope()))) {
            return;
        }
        Session session = ReadAction.compute(() -> new Session(p, consumer));
        session.processResults();
        if (!session.filesLookedInside.isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug(session.toString());
        }
    }

    @NotNull
    private static List<SamDescriptor> calcDescriptors(@NotNull Session session) {
        if (session == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(2);
        }
        PsiClass aClass = session.elementToSearch;
        Project project = PsiUtilCore.getProjectInReadAction(aClass);
        Callable<List> runnable = () -> {
            if (!aClass.isValid() || !aClass.isInterface()) {
                return List.of();
            }
            if (InjectedLanguageManager.getInstance(project).isInjectedFragment(aClass.getContainingFile()) || !JavaFunctionalExpressionSearcher.hasModuleWithFunctionalExpressions(project)) {
                return List.of();
            }
            PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project);
            HashSet visited = new HashSet();
            JavaFunctionalExpressionSearcher.processSubInterfaces(aClass, visited);
            ArrayList<SamDescriptor> descriptors = new ArrayList<SamDescriptor>();
            for (PsiClass samClass : visited) {
                PsiMethod saMethod;
                PsiType samType;
                if (!LambdaUtil.isFunctionalClass(samClass) || (samType = (saMethod = Objects.requireNonNull(LambdaUtil.getFunctionalInterfaceMethod(samClass))).getReturnType()) == null || session.method != null && !saMethod.equals(session.method) && !MethodSignatureUtil.isSuperMethod(saMethod, session.method)) continue;
                SearchScope scope = psiSearchHelper.getUseScope((PsiElement)samClass).intersectWith(session.scope);
                descriptors.add(new SamDescriptor(samClass, saMethod, samType, GlobalSearchScopeUtil.toGlobalSearchScope(scope, project)));
            }
            return descriptors;
        };
        List list = ReadAction.nonBlocking(runnable).inSmartMode(project).executeSynchronously();
        if (list == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static Set<VirtualFile> getLikelyFiles(@NotNull List<? extends SamDescriptor> descriptors, @NotNull Collection<? extends VirtualFile> candidateFiles, @NotNull Project project) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(4);
        }
        if (candidateFiles == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(6);
        }
        GlobalSearchScope candidateFilesScope = ReadAction.compute(() -> GlobalSearchScope.filesScope(project, candidateFiles));
        Set<VirtualFile> set = JBIterable.from(descriptors).flatMap(descriptor -> descriptor.getMostLikelyFiles(candidateFilesScope)).toSet();
        if (set == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    private static MultiMap<VirtualFile, FunExprOccurrence> getAllOccurrences(@NotNull List<? extends SamDescriptor> descriptors) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(8);
        }
        MultiMap<VirtualFile, FunExprOccurrence> result = MultiMap.createLinkedSet();
        descriptors.get((int)0).dumbService.runReadActionInSmartMode(() -> {
            for (SamDescriptor descriptor : descriptors) {
                JavaSourceFilterScope scope = new JavaSourceFilterScope(descriptor.effectiveUseScope, true);
                for (FunctionalExpressionKey key : descriptor.keys) {
                    FileBasedIndex.getInstance().processValues(JavaFunctionalExpressionIndex.INDEX_ID, (Object)key, null, (file, infos) -> {
                        result.putValues(file, ContainerUtil.map(infos, entry -> entry.occurrence));
                        return true;
                    }, (GlobalSearchScope)scope);
                }
            }
        });
        LOG.debug("Found " + result.values().size() + " fun-expressions in " + result.keySet().size() + " files");
        MultiMap<VirtualFile, FunExprOccurrence> multiMap = result;
        if (multiMap == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    private static void processOffsets(@NotNull List<? extends SamDescriptor> descriptors, @NotNull Session session) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(10);
        }
        if (session == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(11);
        }
        if (descriptors.isEmpty()) {
            return;
        }
        List<PsiClass> samClasses = ContainerUtil.map(descriptors, d -> d.samClass);
        MultiMap<VirtualFile, FunExprOccurrence> allCandidates = JavaFunctionalExpressionSearcher.getAllOccurrences(descriptors);
        if (allCandidates.isEmpty()) {
            return;
        }
        Set<VirtualFile> allFiles = allCandidates.keySet();
        session.filesConsidered.addAndGet(allFiles.size());
        Set<VirtualFile> filesFirst = JavaFunctionalExpressionSearcher.getLikelyFiles(descriptors, allFiles, session.project);
        Processor<VirtualFile> vFileProcessor = vFile -> {
            if (vFile.isDirectory()) {
                return true;
            }
            Collection occurrences = allCandidates.get((VirtualFile)vFile);
            session.contextsConsidered.addAndGet(occurrences.size());
            Map<FunExprOccurrence, Confidence> toLoad = JavaFunctionalExpressionSearcher.filterInapplicable(samClasses, vFile, occurrences, session.project);
            if (!toLoad.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("To load " + vFile.getPath() + " with values: " + String.valueOf(toLoad));
                }
                session.filesLookedInside.add((VirtualFile)vFile);
                return JavaFunctionalExpressionSearcher.processFile(descriptors, vFile, toLoad, session);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<VirtualFile>(filesFirst), ProgressIndicatorProvider.getGlobalProgressIndicator(), vFileProcessor)) {
            return;
        }
        allFiles.removeAll(filesFirst);
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<VirtualFile>(allFiles), ProgressIndicatorProvider.getGlobalProgressIndicator(), vFileProcessor);
    }

    @NotNull
    private static Map<FunExprOccurrence, Confidence> filterInapplicable(@NotNull List<? extends PsiClass> samClasses, @NotNull VirtualFile vFile, @NotNull Collection<? extends FunExprOccurrence> occurrences, @NotNull Project project) {
        if (samClasses == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(12);
        }
        if (vFile == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(13);
        }
        if (occurrences == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(14);
        }
        if (project == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(15);
        }
        Map map2 = ReadAction.nonBlocking(() -> {
            HashMap<FunExprOccurrence, Confidence> map2 = new HashMap<FunExprOccurrence, Confidence>();
            for (FunExprOccurrence occurrence : occurrences) {
                ThreeState result = occurrence.checkHasTypeLight(samClasses, vFile, project);
                if (result == ThreeState.NO) continue;
                map2.put(occurrence, result == ThreeState.YES ? Confidence.sure : Confidence.needsCheck);
            }
            return map2;
        }).inSmartMode(project).executeSynchronously();
        if (map2 == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(16);
        }
        return map2;
    }

    private static boolean processFile(@NotNull List<? extends SamDescriptor> descriptors, @NotNull VirtualFile vFile, @NotNull Map<FunExprOccurrence, Confidence> occurrences, @NotNull Session session) {
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(17);
        }
        if (vFile == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(18);
        }
        if (occurrences == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(19);
        }
        if (session == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(20);
        }
        return descriptors.get((int)0).dumbService.runReadActionInSmartMode(() -> {
            PsiManager manager = ((SamDescriptor)descriptors.get((int)0)).samClass.getManager();
            PsiFile file = manager.findFile(vFile);
            if (!(file instanceof PsiJavaFile)) {
                LOG.error("Non-java file " + String.valueOf(file) + "; " + String.valueOf(vFile));
                return true;
            }
            HashMap<TextRange, PsiFile> fragmentCache = new HashMap<TextRange, PsiFile>();
            @NotNull List<JavaFunctionalExpressionIndex.IndexEntry> data = ContainerUtil.flatten(FileBasedIndex.getInstance().getFileData(JavaFunctionalExpressionIndex.INDEX_ID, vFile, manager.getProject()).values());
            for (JavaFunctionalExpressionIndex.IndexEntry entry : data) {
                PsiFunctionalExpression toCheck;
                PsiFunctionalExpression expression;
                Confidence confidence = (Confidence)((Object)((Object)occurrences.get(entry.occurrence)));
                if (confidence == null) continue;
                (confidence == Confidence.sure ? session.sureExprsAfterLightCheck : session.exprsToHeavyCheck).incrementAndGet();
                int offset = entry.exprStart;
                boolean useAST = ((PsiFileEx)file).isContentsLoaded();
                PsiFunctionalExpression psiFunctionalExpression = expression = useAST ? JavaFunctionalExpressionSearcher.findPsiByAST(file, offset) : JavaFunctionalExpressionSearcher.findPsiByStubs(file, entry.exprIndex);
                if (expression == null) {
                    LOG.error("Fun expression not found in " + String.valueOf(file) + " at " + offset);
                    continue;
                }
                if (confidence == Confidence.needsCheck && !JavaFunctionalExpressionSearcher.hasType(descriptors, toCheck = useAST ? expression : JavaFunctionalExpressionSearcher.getNonPhysicalCopy(fragmentCache, entry, expression)) || session.consumer.process(expression)) continue;
                return false;
            }
            return true;
        });
    }

    @Nullable
    private static PsiFunctionalExpression findPsiByAST(PsiFile file, int offset) {
        PsiFunctionalExpression expression = PsiTreeUtil.findElementOfClassAtOffset(file, offset, PsiFunctionalExpression.class, false);
        if (expression == null || expression.getTextRange().getStartOffset() != offset) {
            return null;
        }
        return expression;
    }

    private static PsiFunctionalExpression findPsiByStubs(PsiFile file, int index) {
        StubbedSpine spine = ((PsiFileWithStubSupport)file).getStubbedSpine();
        int funExprIndex = 0;
        for (int i = 0; i < spine.getStubCount(); ++i) {
            IElementType type = spine.getStubType(i);
            if (type != JavaStubElementTypes.LAMBDA_EXPRESSION && type != JavaStubElementTypes.METHOD_REF_EXPRESSION) continue;
            if (funExprIndex == index) {
                return (PsiFunctionalExpression)spine.getStubPsi(i);
            }
            ++funExprIndex;
        }
        return null;
    }

    @NotNull
    private static PsiFunctionalExpression getNonPhysicalCopy(Map<TextRange, PsiFile> fragmentCache, JavaFunctionalExpressionIndex.IndexEntry entry, PsiFunctionalExpression expression) {
        PsiFunctionalExpression psiFunctionalExpression;
        PsiFile file = expression.getContainingFile();
        FileViewProvider viewProvider = file.getViewProvider();
        try {
            PsiMember member = Objects.requireNonNull(PsiTreeUtil.getStubOrPsiParentOfType(expression, PsiMember.class));
            PsiFunctionalExpression psi = null;
            IncorrectOperationException ex = null;
            try {
                PsiFile fragment = fragmentCache.computeIfAbsent(TextRange.create(entry.contextStart, entry.contextEnd), range -> JavaFunctionalExpressionSearcher.createMemberCopyFromText(member, range));
                psi = JavaFunctionalExpressionSearcher.findPsiByAST(fragment, entry.exprStart - entry.contextStart);
            }
            catch (IncorrectOperationException e) {
                ex = e;
            }
            if (psi == null) {
                StubTextInconsistencyException.checkStubTextConsistency(file, StubInconsistencyReporter.SourceOfCheck.NoPsiMatchingASTinJava);
                throw new RuntimeExceptionWithAttachments("No functional expression at " + String.valueOf(entry) + ", file will be reindexed", (Throwable)ex, new Attachment(viewProvider.getVirtualFile().getPath(), viewProvider.getContents().toString()));
            }
            psiFunctionalExpression = psi;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            FileBasedIndex.getInstance().requestReindex(viewProvider.getVirtualFile());
            LOG.error(e);
            PsiFunctionalExpression psiFunctionalExpression2 = expression;
            if (psiFunctionalExpression2 == null) {
                JavaFunctionalExpressionSearcher.$$$reportNull$$$0(22);
            }
            return psiFunctionalExpression2;
        }
        if (psiFunctionalExpression == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(21);
        }
        return psiFunctionalExpression;
    }

    private static PsiFile createMemberCopyFromText(@NotNull PsiMember member, @NotNull TextRange memberRange) {
        if (member == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(23);
        }
        if (memberRange == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(24);
        }
        PsiFile file = member.getContainingFile();
        CharSequence contents = file.getViewProvider().getContents();
        if (memberRange.getEndOffset() > contents.length()) {
            StubTextInconsistencyException.checkStubTextConsistency(file, StubInconsistencyReporter.SourceOfCheck.OffsetOutsideFileInJava);
            throw new RuntimeExceptionWithAttachments("Range from the index " + String.valueOf(memberRange) + " exceeds the actual file length " + contents.length() + ", file will be reindexed", new Attachment(file.getVirtualFile().getPath(), contents.toString()));
        }
        String contextText = memberRange.subSequence(contents).toString();
        Project project = file.getProject();
        return member instanceof PsiEnumConstant ? PsiElementFactory.getInstance(project).createEnumConstantFromText(contextText, member).getContainingFile() : JavaCodeFragmentFactory.getInstance(project).createMemberCodeFragment(contextText, member, false);
    }

    private static boolean hasType(@NotNull List<? extends SamDescriptor> descriptors, @NotNull PsiFunctionalExpression expression) {
        ThreeState approximate;
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(25);
        }
        if (expression == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(26);
        }
        if ((approximate = JavaFunctionalExpressionSearcher.approximateHasType(expression, ContainerUtil.map(descriptors, d -> d.samClass))) != ThreeState.UNSURE) {
            return approximate == ThreeState.YES;
        }
        PsiClass actualClass = LambdaUtil.resolveFunctionalInterfaceClass(expression);
        return ContainerUtil.exists(descriptors, d -> InheritanceUtil.isInheritorOrSelf(actualClass, d.samClass, true));
    }

    private static ThreeState approximateHasType(@NotNull PsiFunctionalExpression expression, @NotNull List<? extends PsiClass> samClasses) {
        PsiElement parent;
        if (expression == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(27);
        }
        if (samClasses == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(28);
        }
        if ((parent = expression.getParent()) instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression) {
            PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
            int argIndex = Arrays.asList(args).indexOf(expression);
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent.getParent()).getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            if (qualifier != null && methodName != null && argIndex >= 0) {
                List<PsiMethod> methods;
                Set<PsiClass> approximateTypes = ApproximateResolver.getPossibleTypes(qualifier, 10);
                List<PsiMethod> list = methods = approximateTypes == null ? null : ApproximateResolver.getPossibleMethods(approximateTypes, methodName, args.length);
                return methods == null ? ThreeState.UNSURE : (methods.isEmpty() ? ThreeState.NO : ThreeState.merge(JBIterable.from(methods).map(m -> FunExprOccurrence.hasCompatibleParameter(m, argIndex, samClasses))));
            }
        }
        return ThreeState.UNSURE;
    }

    private static boolean hasModuleWithFunctionalExpressions(@NotNull Project project) {
        if (project == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(29);
        }
        boolean projectLevelIsHigh = JavaFeature.LAMBDA_EXPRESSIONS.isSufficient(PsiUtil.getLanguageLevel(project));
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = ModuleRootManager.getInstance(module).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || !((level = extension.getLanguageLevel()) == null ? projectLevelIsHigh : JavaFeature.LAMBDA_EXPRESSIONS.isSufficient(level))) continue;
            return true;
        }
        return false;
    }

    private static void processSubInterfaces(@NotNull PsiClass base, @NotNull Set<? super PsiClass> visited) {
        if (base == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(30);
        }
        if (visited == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(31);
        }
        if (!visited.add(base)) {
            return;
        }
        DirectClassInheritorsSearch.search((PsiClass)base).forEach(candidate -> {
            if (candidate.isInterface()) {
                JavaFunctionalExpressionSearcher.processSubInterfaces(candidate, visited);
            }
            return true;
        });
    }

    private static boolean performSearchUsingCompilerIndices(@NotNull List<? extends SamDescriptor> descriptors, @NotNull GlobalSearchScope searchScope, @NotNull Project project, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        CompilerReferenceService compilerReferenceService;
        if (descriptors == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(32);
        }
        if (searchScope == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(33);
        }
        if (project == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(34);
        }
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(35);
        }
        if ((compilerReferenceService = CompilerReferenceService.getInstanceIfEnabled(project)) == null) {
            return true;
        }
        for (SamDescriptor samDescriptor : descriptors) {
            CompilerDirectHierarchyInfo info = compilerReferenceService.getFunExpressions(samDescriptor.samClass, searchScope, JavaFileType.INSTANCE);
            if (info == null || JavaFunctionalExpressionSearcher.processFunctionalExpressions(info, samDescriptor, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processFunctionalExpressions(@NotNull CompilerDirectHierarchyInfo funExprInfo, @NotNull SamDescriptor descriptor, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        if (funExprInfo == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(36);
        }
        if (descriptor == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(37);
        }
        if (consumer == null) {
            JavaFunctionalExpressionSearcher.$$$reportNull$$$0(38);
        }
        if (!ContainerUtil.process(funExprInfo.getHierarchyChildren().iterator(), fe -> consumer.process((PsiFunctionalExpression)fe))) {
            return false;
        }
        GlobalSearchScope dirtyScope = funExprInfo.getDirtyScope();
        descriptor.effectiveUseScope = descriptor.effectiveUseScope.intersectWith(dirtyScope);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 9, 16, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 17: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFiles";
                break;
            }
            case 6: 
            case 15: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samClasses";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberRange";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExprInfo";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLikelyFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOccurrences";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterInapplicable";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonPhysicalCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcDescriptors";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 16: 
            case 21: 
            case 22: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLikelyFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllOccurrences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processOffsets";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterInapplicable";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createMemberCopyFromText";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "approximateHasType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleWithFunctionalExpressions";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processSubInterfaces";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "performSearchUsingCompilerIndices";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionalExpressions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 9, 16, 21, 22 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static class Session {
        private final Processor<? super PsiFunctionalExpression> consumer;
        private final Project project;
        private final SearchScope scope;
        private final PsiClass elementToSearch;
        private final AtomicInteger filesConsidered;
        private final AtomicInteger contextsConsidered;
        private final AtomicInteger sureExprsAfterLightCheck;
        private final AtomicInteger exprsToHeavyCheck;
        private final Set<VirtualFile> filesLookedInside;
        @Nullable
        private final PsiMethod method;

        public Session(@NotNull FunctionalExpressionSearch.SearchParameters parameters, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
            if (parameters == null) {
                Session.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                Session.$$$reportNull$$$0(1);
            }
            this.filesConsidered = new AtomicInteger();
            this.contextsConsidered = new AtomicInteger();
            this.sureExprsAfterLightCheck = new AtomicInteger();
            this.exprsToHeavyCheck = new AtomicInteger();
            this.filesLookedInside = ConcurrentCollectionFactory.createConcurrentSet();
            this.consumer = consumer;
            this.elementToSearch = parameters.getElementToSearch();
            this.method = parameters.getMethod();
            this.project = parameters.getProject();
            this.scope = parameters.getEffectiveSearchScope();
        }

        @TestOnly
        @NotNull
        public Set<VirtualFile> getFilesLookedInside() {
            Set<VirtualFile> set = this.filesLookedInside;
            if (set == null) {
                Session.$$$reportNull$$$0(2);
            }
            return set;
        }

        public void processResults() {
            List<SamDescriptor> descriptors = JavaFunctionalExpressionSearcher.calcDescriptors(this);
            if (this.scope instanceof GlobalSearchScope && !JavaFunctionalExpressionSearcher.performSearchUsingCompilerIndices(descriptors, (GlobalSearchScope)this.scope, this.project, this.consumer)) {
                return;
            }
            PsiManager.getInstance(this.project).runInBatchFilesMode(() -> {
                JavaFunctionalExpressionSearcher.processOffsets(descriptors, this);
                return null;
            });
        }

        public String toString() {
            return "filesConsidered=" + String.valueOf(this.filesConsidered) + ", contextsConsidered=" + String.valueOf(this.contextsConsidered) + ", sureExprsAfterLightCheck=" + String.valueOf(this.sureExprsAfterLightCheck) + ", exprsToHeavyCheck=" + String.valueOf(this.exprsToHeavyCheck) + ", filesLookedInside=" + this.filesLookedInside.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher$Session";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher$Session";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesLookedInside";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class SamDescriptor {
        final PsiClass samClass;
        final int samParamCount;
        final boolean booleanCompatible;
        final boolean isVoid;
        final DumbService dumbService;
        final List<FunctionalExpressionKey> keys;
        GlobalSearchScope effectiveUseScope;

        SamDescriptor(@NotNull PsiClass samClass, @NotNull PsiMethod samMethod, @NotNull PsiType samType, @NotNull GlobalSearchScope useScope) {
            if (samClass == null) {
                SamDescriptor.$$$reportNull$$$0(0);
            }
            if (samMethod == null) {
                SamDescriptor.$$$reportNull$$$0(1);
            }
            if (samType == null) {
                SamDescriptor.$$$reportNull$$$0(2);
            }
            if (useScope == null) {
                SamDescriptor.$$$reportNull$$$0(3);
            }
            this.samClass = samClass;
            this.effectiveUseScope = useScope;
            this.samParamCount = samMethod.getParameterList().getParametersCount();
            this.booleanCompatible = FunctionalExpressionKey.isBooleanCompatible(samType);
            this.isVoid = PsiTypes.voidType().equals(samType);
            this.dumbService = DumbService.getInstance(samClass.getProject());
            this.keys = this.generateKeys();
        }

        @NotNull
        private List<FunctionalExpressionKey> generateKeys() {
            String name;
            String string = name = this.samClass.isValid() ? this.samClass.getName() : null;
            if (name == null) {
                List<FunctionalExpressionKey> list = Collections.emptyList();
                if (list == null) {
                    SamDescriptor.$$$reportNull$$$0(4);
                }
                return list;
            }
            ArrayList<FunctionalExpressionKey> result = new ArrayList<FunctionalExpressionKey>();
            for (String lambdaType : new String[]{Objects.requireNonNull(name), ""}) {
                for (int lambdaParamCount : new int[]{-1, this.samParamCount}) {
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.UNKNOWN, lambdaType));
                    if (this.isVoid) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.VOID, lambdaType));
                        continue;
                    }
                    if (this.booleanCompatible) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.BOOLEAN, lambdaType));
                    }
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.NON_VOID, lambdaType));
                }
            }
            ArrayList<FunctionalExpressionKey> arrayList = result;
            if (arrayList == null) {
                SamDescriptor.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        @NotNull
        private Set<VirtualFile> getMostLikelyFiles(@NotNull GlobalSearchScope searchScope) {
            if (searchScope == null) {
                SamDescriptor.$$$reportNull$$$0(6);
            }
            LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
            this.dumbService.runReadActionInSmartMode(() -> {
                if (!this.samClass.isValid()) {
                    return;
                }
                String className = this.samClass.getName();
                Project project = this.samClass.getProject();
                if (className == null) {
                    return;
                }
                LinkedHashSet<String> likelyNames = ContainerUtil.newLinkedHashSet(className);
                StubIndex.getInstance().processElements(JavaMethodParameterTypesIndex.getInstance().getKey(), (Object)className, project, this.effectiveUseScope, PsiMethod.class, method -> {
                    ProgressManager.checkCanceled();
                    likelyNames.add(method.getName());
                    return true;
                });
                PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.getInstance((Project)project);
                Processor processor = Processors.cancelableCollectProcessor(files);
                for (String word : likelyNames) {
                    helper.processCandidateFilesForText(searchScope, (short)1, true, true, word, processor);
                }
            });
            LinkedHashSet<VirtualFile> linkedHashSet = files;
            if (linkedHashSet == null) {
                SamDescriptor.$$$reportNull$$$0(7);
            }
            return linkedHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "samClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "samMethod";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "samType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useScope";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher$SamDescriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher$SamDescriptor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateKeys";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMostLikelyFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getMostLikelyFiles";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static enum Confidence {
        sure,
        needsCheck;

    }
}

