/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.syntax.element.JavaSyntaxTokenType;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.TokenList;
import com.intellij.platform.syntax.lexer.TokenListUtil;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaNullMethodArgumentIndex
extends ScalarIndexExtension<MethodCallData> {
    public static final ID<MethodCallData, Void> INDEX_ID = ID.create("java.null.method.argument");
    private static final StringSearcher ourSearcher = new StringSearcher("null", true, true);

    @NotNull
    public ID<MethodCallData, Void> getName() {
        ID<MethodCallData, Void> iD = INDEX_ID;
        if (iD == null) {
            JavaNullMethodArgumentIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<MethodCallData, Void, FileContent> getIndexer() {
        DataIndexer<MethodCallData, Void, FileContent> dataIndexer = inputData -> {
            if (ourSearcher.scan(inputData.getContentAsText()) < 0) {
                return Map.of();
            }
            HashMap<MethodCallData, Object> result = new HashMap<MethodCallData, Object>();
            TokenList tokens = JavaParserUtil.obtainTokens(inputData.getPsiFile());
            for (int i = 0; i < tokens.getTokenCount(); ++i) {
                MethodCallData data;
                if (!TokenListUtil.hasType(tokens, i, JavaSyntaxTokenType.NULL_KEYWORD) || (data = JavaNullMethodArgumentIndex.findCallData(tokens, i)) == null) continue;
                result.put(data, null);
            }
            return result;
        };
        if (dataIndexer == null) {
            JavaNullMethodArgumentIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @Nullable
    private static MethodCallData findCallData(TokenList tokens, int nullIndex) {
        if (!TokenListUtil.hasType(tokens, TokenListUtil.forwardWhile(tokens, nullIndex + 1, JavaParserUtil.WS_COMMENTS), JavaSyntaxTokenType.RPARENTH, JavaSyntaxTokenType.COMMA)) {
            return null;
        }
        int i = TokenListUtil.backWhile(tokens, nullIndex - 1, JavaParserUtil.WS_COMMENTS);
        if (!TokenListUtil.hasType(tokens, i, JavaSyntaxTokenType.LPARENTH, JavaSyntaxTokenType.COMMA)) {
            return null;
        }
        int commaCount = 0;
        while (!TokenListUtil.hasType(tokens, i, null, JavaSyntaxTokenType.SEMICOLON, JavaSyntaxTokenType.EQ, JavaSyntaxTokenType.RBRACE)) {
            SyntaxElementType type = tokens.getTokenType(i);
            if (type == JavaSyntaxTokenType.COMMA) {
                ++commaCount;
            } else if (type == JavaSyntaxTokenType.LPARENTH) {
                String name = JavaNullMethodArgumentIndex.findMethodName(tokens, i);
                return name == null ? null : new MethodCallData(name, commaCount);
            }
            i = TokenListUtil.backWithBraceMatching(tokens, i, JavaSyntaxTokenType.LPARENTH, JavaSyntaxTokenType.RPARENTH);
        }
        return null;
    }

    @Nullable
    private static String findMethodName(TokenList tokens, int lparenth) {
        int i = TokenListUtil.backWhile(tokens, lparenth - 1, JavaParserUtil.WS_COMMENTS);
        if (TokenListUtil.hasType(tokens, i, JavaSyntaxTokenType.GT)) {
            i = TokenListUtil.backWhile(tokens, TokenListUtil.backWithBraceMatching(tokens, i, JavaSyntaxTokenType.LT, JavaSyntaxTokenType.GT), JavaParserUtil.WS_COMMENTS);
        }
        return tokens.getTokenType(i) == JavaSyntaxTokenType.IDENTIFIER ? tokens.getTokenText(i).toString() : null;
    }

    @NotNull
    public KeyDescriptor<MethodCallData> getKeyDescriptor() {
        return new KeyDescriptor<MethodCallData>(){

            @Override
            public int getHashCode(MethodCallData value) {
                return value.hashCode();
            }

            @Override
            public boolean isEqual(MethodCallData val1, MethodCallData val2) {
                return val1.equals(val2);
            }

            @Override
            public void save(@NotNull DataOutput out, MethodCallData value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                EnumeratorStringDescriptor.INSTANCE.save(out, value.getMethodName());
                DataInputOutputUtil.writeINT(out, value.getNullParameterIndex());
            }

            @Override
            public MethodCallData read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new MethodCallData(EnumeratorStringDescriptor.INSTANCE.read(in), DataInputOutputUtil.readINT(in));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return JavaFileElementType.isInSourceContent(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$2", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class MethodCallData {
        @NotNull
        private final String myMethodName;
        private final int myNullParameterIndex;

        public MethodCallData(@NotNull String name, int index) {
            if (name == null) {
                MethodCallData.$$$reportNull$$$0(0);
            }
            this.myMethodName = name;
            this.myNullParameterIndex = index;
        }

        @NotNull
        public String getMethodName() {
            String string = this.myMethodName;
            if (string == null) {
                MethodCallData.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getNullParameterIndex() {
            return this.myNullParameterIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodCallData data = (MethodCallData)o;
            if (this.myNullParameterIndex != data.myNullParameterIndex) {
                return false;
            }
            return this.myMethodName.equals(data.myMethodName);
        }

        public int hashCode() {
            int result = this.myMethodName.hashCode();
            result = 31 * result + this.myNullParameterIndex;
            return result;
        }

        public String toString() {
            return "MethodCallData{myMethodName='" + this.myMethodName + "', myNullParameterIndex=" + this.myNullParameterIndex + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$MethodCallData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$MethodCallData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

