/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ClassTypePointerFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.impl.smartPointers.TypePointerBase;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiClassReferenceTypePointerFactory
implements ClassTypePointerFactory {
    private static final Logger LOG = Logger.getInstance(PsiClassReferenceTypePointerFactory.class);

    @Override
    @Nullable
    public SmartTypePointer createClassTypePointer(@NotNull PsiClassType classType, @NotNull Project project) {
        if (classType == null) {
            PsiClassReferenceTypePointerFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PsiClassReferenceTypePointerFactory.$$$reportNull$$$0(1);
        }
        if (classType instanceof PsiClassReferenceType) {
            return new ClassReferenceTypePointer((PsiClassReferenceType)classType, project);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "classType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/smartPointers/PsiClassReferenceTypePointerFactory";
        objectArray[2] = "createClassTypePointer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClassReferenceTypePointer
    extends TypePointerBase<PsiClassReferenceType> {
        private final SmartPsiElementPointer<PsiJavaCodeReferenceElement> mySmartPsiElementPointer;
        private final String myReferenceText;
        private final Project myProject;

        ClassReferenceTypePointer(@NotNull PsiClassReferenceType type, Project project) {
            if (type == null) {
                ClassReferenceTypePointer.$$$reportNull$$$0(0);
            }
            super(type);
            this.myProject = project;
            PsiJavaCodeReferenceElement reference = type.getReference();
            this.mySmartPsiElementPointer = SmartPointerManager.getInstance(this.myProject).createSmartPsiElementPointer(reference);
            this.myReferenceText = reference.getText();
        }

        @Override
        protected PsiClassReferenceType calcType() {
            PsiClassReferenceType myType = null;
            PsiJavaCodeReferenceElement referenceElement = this.mySmartPsiElementPointer.getElement();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.myProject);
            if (referenceElement != null) {
                myType = (PsiClassReferenceType)factory.createType(referenceElement);
            } else {
                try {
                    myType = (PsiClassReferenceType)factory.createTypeFromText(this.myReferenceText, null);
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
            return myType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/PsiClassReferenceTypePointerFactory$ClassReferenceTypePointer", "<init>"));
        }
    }
}

