/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceCompletion;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileReferenceCompletionImpl
extends FileReferenceCompletion {
    private static final HashingStrategy<PsiElement> VARIANTS_HASHING_STRATEGY = new HashingStrategy<PsiElement>(){

        @Override
        public int hashCode(@Nullable PsiElement object) {
            PsiNamedElement namedElement;
            String name;
            if (object instanceof PsiNamedElement && (name = (namedElement = (PsiNamedElement)object).getName()) != null) {
                return name.hashCode();
            }
            return Objects.hashCode(object);
        }

        @Override
        public boolean equals(@Nullable PsiElement o1, @Nullable PsiElement o2) {
            if (o1 instanceof PsiNamedElement) {
                PsiNamedElement namedElement1 = (PsiNamedElement)o1;
                if (o2 instanceof PsiNamedElement) {
                    PsiNamedElement namedElement2 = (PsiNamedElement)o2;
                    return Objects.equals(namedElement1.getName(), namedElement2.getName());
                }
            }
            return Objects.equals(o1, o2);
        }
    };

    FileReferenceCompletionImpl() {
    }

    @Override
    public Object @NotNull [] getFileReferenceCompletionVariants(FileReference reference) {
        int i;
        String s = reference.getText();
        if (s != null && s.equals("/")) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                FileReferenceCompletionImpl.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        final Condition<PsiFileSystemItem> filter2 = reference.getFileReferenceSet().getReferenceCompletionFilter();
        final CommonProcessors.CollectProcessor<PsiElement> collector2 = new CommonProcessors.CollectProcessor<PsiElement>(CollectionFactory.createCustomHashingStrategySet(VARIANTS_HASHING_STRATEGY));
        PsiElementProcessor<PsiFileSystemItem> processor = new PsiElementProcessor<PsiFileSystemItem>(){

            @Override
            public boolean execute(@NotNull PsiFileSystemItem fileSystemItem) {
                if (fileSystemItem == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new FilteringProcessor<PsiFileSystemItem>(filter2, collector2).process(FileReference.getOriginalFile(fileSystemItem));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystemItem", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceCompletionImpl$2", "execute"));
            }
        };
        ArrayList<Object> additionalItems = new ArrayList<Object>();
        for (PsiFileSystemItem context : reference.getContexts()) {
            for (PsiElement child : context.getChildren()) {
                if (!(child instanceof PsiFileSystemItem)) continue;
                PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)child;
                processor.execute(fileSystemItem);
            }
            if (!(context instanceof FileReferenceResolver)) continue;
            FileReferenceResolver resolver = (FileReferenceResolver)((Object)context);
            additionalItems.addAll(resolver.getVariants(reference));
        }
        FileType[] types = reference.getFileReferenceSet().getSuitableFileTypes();
        PsiElement[] candidates = PsiUtilCore.toPsiElementArray(collector2.getResults());
        Object[] variants = new Object[candidates.length + additionalItems.size()];
        for (i = 0; i < candidates.length; ++i) {
            PsiElement candidate = candidates[i];
            Object item = reference.createLookupItem(candidate);
            if (item == null) {
                item = FileInfoManager.getFileLookupItem(candidate);
            }
            if (candidate instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)candidate;
                if (item instanceof LookupElement) {
                    LookupElement lookupElement = (LookupElement)item;
                    if (types.length > 0 && ArrayUtil.contains(psiFile.getFileType(), types)) {
                        item = PrioritizedLookupElement.withPriority(lookupElement, Double.MAX_VALUE);
                    }
                }
            }
            variants[i] = item;
        }
        for (i = 0; i < additionalItems.size(); ++i) {
            variants[i + candidates.length] = additionalItems.get(i);
        }
        if (!reference.getFileReferenceSet().isUrlEncoded()) {
            if (variants == null) {
                FileReferenceCompletionImpl.$$$reportNull$$$0(1);
            }
            return variants;
        }
        ArrayList<Object> encodedVariants = new ArrayList<Object>(variants.length + additionalItems.size());
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            PsiNamedElement psiElement;
            String name;
            String encoded;
            PsiElement element = candidates[i2];
            if (!(element instanceof PsiNamedElement) || (encoded = reference.encode(name = (psiElement = (PsiNamedElement)element).getName(), psiElement)) == null) continue;
            if (!encoded.equals(name)) {
                Icon icon = psiElement.getIcon(3);
                LookupElementBuilder item = FileInfoManager.getFileLookupItem(candidates[i2], encoded, icon);
                encodedVariants.add(item.withTailText(" (" + name + ")"));
                continue;
            }
            encodedVariants.add(variants[i2]);
        }
        encodedVariants.addAll(additionalItems);
        Object[] objectArray = ArrayUtil.toObjectArray(encodedVariants);
        if (objectArray == null) {
            FileReferenceCompletionImpl.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceCompletionImpl", "getFileReferenceCompletionVariants"));
    }
}

