/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class ClassMapCachingNulls<T> {
    private final Map<Class<?>, T[]> myBackingMap;
    private final T[] myEmptyArray;
    private final List<? extends T> myOrderingArray;
    private final Map<Class<?>, T[]> myMap;

    ClassMapCachingNulls(@NotNull Map<Class<?>, T[]> backingMap, T[] emptyArray, @NotNull List<? extends T> orderingArray) {
        if (backingMap == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(0);
        }
        if (orderingArray == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(1);
        }
        this.myMap = new ConcurrentHashMap();
        this.myBackingMap = backingMap;
        this.myEmptyArray = emptyArray;
        this.myOrderingArray = orderingArray;
    }

    T @Nullable [] get(@NotNull Class<?> aClass) {
        T[] value;
        if (aClass == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(2);
        }
        if ((value = this.myMap.get(aClass)) != null) {
            if (value == this.myEmptyArray) {
                return null;
            }
            assert (value.length != 0);
            return value;
        }
        return this.cache(aClass, this.getFromBackingMap(aClass));
    }

    private T[] cache(@NotNull Class<?> aClass, @Nullable @Unmodifiable List<T> result) {
        T[] value;
        if (aClass == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(3);
        }
        if (result == null) {
            this.myMap.put(aClass, this.myEmptyArray);
            value = null;
        } else {
            assert (!result.isEmpty());
            value = result.toArray(this.myEmptyArray);
            this.myMap.put(aClass, value);
        }
        return value;
    }

    private @Unmodifiable @Nullable List<T> getFromBackingMap(@NotNull Class<?> aClass) {
        Class<?> superClass;
        if (aClass == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(4);
        }
        T[] value = this.myBackingMap.get(aClass);
        Set result = null;
        if (value != null) {
            assert (value.length != 0);
            result = new HashSet(value.length);
            Collections.addAll(result, value);
        }
        if ((superClass = aClass.getSuperclass()) != null) {
            result = this.addFromUpper(result, superClass);
        }
        for (Class<?> superInterface : aClass.getInterfaces()) {
            result = this.addFromUpper(result, superInterface);
        }
        return result == null ? null : ContainerUtil.findAll(this.myOrderingArray, result::contains);
    }

    @Nullable
    private Set<T> addFromUpper(@Nullable Set<T> value, @NotNull Class<?> superclass) {
        T[] fromUpper;
        if (superclass == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(5);
        }
        if ((fromUpper = this.get(superclass)) != null) {
            assert (fromUpper.length != 0);
            if (value == null) {
                value = new HashSet<T>(fromUpper.length);
            }
            Collections.addAll(value, fromUpper);
            assert (!value.isEmpty());
        }
        return value;
    }

    @NotNull
    Map<Class<?>, T[]> getBackingMap() {
        Map<Class<?>, T[]> map2 = this.myBackingMap;
        if (map2 == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(6);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backingMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderingArray";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superclass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/ClassMapCachingNulls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/ClassMapCachingNulls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFromBackingMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFromUpper";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

