/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.util;

import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiScopesUtil {
    private static final Logger LOG = Logger.getInstance(PsiScopesUtil.class);

    private PsiScopesUtil() {
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(0);
        }
        if (entrance == null) {
            PsiScopesUtil.$$$reportNull$$$0(1);
        }
        return PsiScopesUtil.treeWalkUp(processor, entrance, maxScope, ResolveState.initial());
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state2) {
        String name;
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(2);
        }
        if (entrance == null) {
            PsiScopesUtil.$$$reportNull$$$0(3);
        }
        if (state2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(4);
        }
        if (!entrance.isValid()) {
            LOG.error(new PsiInvalidElementAccessException(entrance));
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        NameHint hint = processor.getHint(NameHint.KEY);
        String string = name = hint == null ? null : hint.getName(state2);
        while (scope != null) {
            ProgressIndicatorProvider.checkCanceled();
            if (scope instanceof PsiClass) {
                processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, scope);
            }
            if (!scope.processDeclarations(processor, state2, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            processor.handleEvent(JavaScopeProcessorEvent.EXIT_LEVEL, scope);
            processor.handleEvent(JavaScopeProcessorEvent.CHANGE_LEVEL, null);
            scope = scope instanceof PsiClassImpl ? ((PsiClassImpl)scope).getContext(name) : scope.getContext();
        }
        return true;
    }

    public static boolean walkChildrenScopes(@NotNull PsiElement thisElement, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, PsiElement place) {
        if (thisElement == null) {
            PsiScopesUtil.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(6);
        }
        if (state2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(7);
        }
        PsiElement child = null;
        if (lastParent != null && lastParent.getParent() == thisElement && (child = lastParent.getPrevSibling()) == null) {
            return true;
        }
        if (child == null) {
            child = thisElement.getLastChild();
        }
        while (child != null) {
            if (!child.processDeclarations(processor, state2, null, place)) {
                return false;
            }
            child = child.getPrevSibling();
        }
        return true;
    }

    public static void processTypeDeclarations(PsiType type, PsiElement place, PsiScopeProcessor processor) {
        if (type instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(place);
            PsiClass arrayClass = JavaPsiFacade.getElementFactory(place.getProject()).getArrayClass(languageLevel);
            PsiTypeParameter[] arrayTypeParameters = arrayClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (arrayTypeParameters.length > 0) {
                substitutor = substitutor.put(arrayTypeParameters[0], ((PsiArrayType)type).getComponentType());
            }
            arrayClass.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor), arrayClass, place);
        } else if (type instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)type).getConjuncts()) {
                PsiScopesUtil.processTypeDeclarations(psiType, place, processor);
            }
        } else if (type instanceof PsiDisjunctionType) {
            PsiType lub = ((PsiDisjunctionType)type).getLeastUpperBound();
            PsiScopesUtil.processTypeDeclarations(lub, place, processor);
        } else if (type instanceof PsiCapturedWildcardType) {
            PsiType classType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type, place);
            if (classType != null) {
                PsiScopesUtil.processTypeDeclarations(classType, place, processor);
            }
        } else {
            PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType(type);
            PsiClass clazz = (PsiClass)result.getElement();
            if (clazz != null) {
                clazz.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result.getSubstitutor()), clazz, place);
            }
        }
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(8);
        }
        if (ref == null) {
            PsiScopesUtil.$$$reportNull$$$0(9);
        }
        return PsiScopesUtil.resolveAndWalk(processor, ref, maxScope, false);
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope, boolean incompleteCode) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(10);
        }
        if (ref == null) {
            PsiScopesUtil.$$$reportNull$$$0(11);
        }
        PsiElement qualifier = ref.getQualifier();
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (classNameElement == null) {
            return true;
        }
        if (qualifier != null) {
            PsiElement target = null;
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (qualifier instanceof PsiExpression || qualifier instanceof PsiJavaCodeReferenceElement || qualifier instanceof PsiTypeElement) {
                PsiType type = null;
                if (qualifier instanceof PsiExpression) {
                    type = ((PsiExpression)qualifier).getType();
                    assert (type == null || type.isValid()) : type.getClass() + "; " + qualifier;
                    PsiScopesUtil.processTypeDeclarations(type, ref, processor);
                } else if (qualifier instanceof PsiTypeElement) {
                    type = ((PsiTypeElement)qualifier).getType();
                    PsiScopesUtil.processTypeDeclarations(type, ref, processor);
                }
                if (type == null && qualifier instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)qualifier;
                    JavaResolveResult result = referenceElement.advancedResolve(incompleteCode);
                    target = result.getElement();
                    substitutor = result.getSubstitutor();
                    if (target instanceof PsiVariable) {
                        type = substitutor.substitute(((PsiVariable)target).getType());
                        if (type instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor = substitutor.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                    } else if (target instanceof PsiMethod) {
                        type = substitutor.substitute(((PsiMethod)target).getReturnType());
                        if (type instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor = substitutor.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                        PsiType[] types = referenceElement.getTypeParameters();
                        if (target instanceof PsiClass) {
                            substitutor = substitutor.putAll((PsiClass)target, types);
                        }
                    } else if (target instanceof PsiClass) {
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                    }
                }
            }
            if (target != null) {
                return target.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor), target, ref);
            }
        } else {
            return PsiScopesUtil.treeWalkUp(processor, ref, maxScope);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setupAndRunProcessor(@NotNull MethodsProcessor processor, @NotNull PsiCallExpression call, boolean dummyImplicitConstructor) throws MethodProcessorSetupFailedException {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(12);
        }
        if (call == null) {
            PsiScopesUtil.$$$reportNull$$$0(13);
        }
        if (call instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)call;
            PsiReferenceExpression ref = methodCall.getMethodExpression();
            processor.setArgumentList(methodCall.getArgumentList());
            processor.obtainTypeArguments(methodCall);
            if (!ref.isQualified() || ref.getReferenceNameElement() instanceof PsiKeyword) {
                PsiElement referenceNameElement = ref.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                if (referenceNameElement instanceof PsiKeyword) {
                    PsiKeyword keyword = (PsiKeyword)referenceNameElement;
                    if (keyword.getTokenType() == JavaTokenType.THIS_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for this expression");
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(aClass);
                        aClass.processDeclarations(processor, ResolveState.initial(), null, call);
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, aClass);
                        return;
                    } else if (keyword.getTokenType() == JavaTokenType.SUPER_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for super expression");
                        }
                        JvmReferenceType type = aClass.getSuperClassType();
                        if (type == null) {
                            return;
                        }
                        PsiClass psiClass = ObjectUtils.tryCast(type.resolve(), PsiClass.class);
                        PsiClass superClass = psiClass;
                        if (superClass == null) return;
                        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                        PsiClass runSuper = superClass;
                        ArrayList<PsiSubstitutor> contextSubstitutors = new ArrayList<PsiSubstitutor>();
                        do {
                            if (runSuper != null) {
                                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(runSuper, aClass, PsiSubstitutor.EMPTY);
                                contextSubstitutors.add(superSubstitutor);
                            }
                            if (aClass.hasModifierProperty("static")) break;
                            if ((aClass = JavaResolveUtil.getContextClass(aClass)) == null) continue;
                            runSuper = aClass.getSuperClass();
                        } while (aClass != null);
                        for (int i = contextSubstitutors.size() - 1; i >= 0; --i) {
                            PsiSubstitutor contextSubstitutor = (PsiSubstitutor)contextSubstitutors.get(i);
                            substitutor = substitutor.putAll(contextSubstitutor);
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(null);
                        PsiMethod[] constructors = superClass.getConstructors();
                        ResolveState state2 = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor);
                        for (PsiMethod constructor : constructors) {
                            if (processor.execute(constructor, state2)) continue;
                            return;
                        }
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, superClass);
                        return;
                    } else {
                        LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                    }
                    return;
                } else if (referenceNameElement instanceof PsiIdentifier) {
                    processor.setIsConstructor(false);
                    processor.setName(referenceNameElement.getText());
                    processor.setAccessClass(null);
                    PsiScopesUtil.resolveAndWalk(processor, ref, null);
                    return;
                } else {
                    LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                }
                return;
            } else {
                PsiElement referenceName = methodCall.getMethodExpression().getReferenceNameElement();
                PsiManager manager = call.getManager();
                PsiElement qualifier = ref.getQualifier();
                if (referenceName == null) {
                    throw new MethodProcessorSetupFailedException("Can't resolve method name for this expression");
                }
                if (referenceName instanceof PsiIdentifier && qualifier instanceof PsiExpression) {
                    PsiEnumConstantInitializer initializingClass;
                    PsiElement resolve;
                    PsiType type = ((PsiExpression)qualifier).getType();
                    if (type != null && qualifier instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiEnumConstant && (initializingClass = ((PsiEnumConstant)resolve).getInitializingClass()) != null && PsiScopesUtil.getOverridingMethod(initializingClass, methodCall.getMethodExpression().getReferenceName()) != null) {
                        PsiScopesUtil.processQualifierResult(new ClassCandidateInfo(initializingClass, PsiSubstitutor.EMPTY), processor, methodCall);
                        return;
                    }
                    if (type == null) {
                        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) throw new MethodProcessorSetupFailedException("Cant determine qualifier type!");
                        JavaResolveResult result = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(false);
                        if (!(result.getElement() instanceof PsiClass)) return;
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                        PsiScopesUtil.processQualifierResult(result, processor, methodCall);
                        return;
                    } else if (type instanceof PsiDisjunctionType) {
                        PsiScopesUtil.processQualifierType(((PsiDisjunctionType)type).getLeastUpperBound(), processor, manager, methodCall);
                        return;
                    } else if (type instanceof PsiCapturedWildcardType) {
                        PsiType psiType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type, methodCall);
                        if (psiType == null) return;
                        PsiScopesUtil.processQualifierType(psiType, processor, manager, methodCall);
                        return;
                    } else {
                        PsiScopesUtil.processQualifierType(type, processor, manager, methodCall);
                    }
                    return;
                } else {
                    LOG.error("ref: " + ref + " (" + ref.getClass() + "), ref.getReferenceNameElement()=" + ref.getReferenceNameElement() + "; methodCall.getMethodExpression().getReferenceNameElement()=" + methodCall.getMethodExpression().getReferenceNameElement() + "; qualifier=" + qualifier);
                }
            }
            return;
        } else {
            LOG.assertTrue(call instanceof PsiNewExpression);
            PsiNewExpression newExpr = (PsiNewExpression)call;
            PsiJavaCodeReferenceElement classRef = newExpr.getClassOrAnonymousClassReference();
            if (classRef == null) {
                throw new MethodProcessorSetupFailedException("Cant get reference to class in new expression");
            }
            JavaResolveResult result = classRef.advancedResolve(false);
            PsiClass aClass = (PsiClass)result.getElement();
            if (aClass == null) {
                throw new MethodProcessorSetupFailedException("Cant resolve class in new expression");
            }
            processor.setIsConstructor(true);
            processor.setAccessClass(aClass);
            processor.setArgumentList(newExpr.getArgumentList());
            processor.obtainTypeArguments(newExpr);
            aClass.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result.getSubstitutor()), null, call);
            if (!dummyImplicitConstructor) return;
            PsiScopesUtil.processDummyConstructor(processor, aClass);
        }
    }

    private static PsiType convertToTypeParameter(PsiCapturedWildcardType type, PsiElement methodCall) {
        GlobalSearchScope placeResolveScope = methodCall.getResolveScope();
        PsiType upperBound = PsiClassImplUtil.correctType(type.getUpperBound(), placeResolveScope);
        while (upperBound instanceof PsiCapturedWildcardType) {
            upperBound = PsiClassImplUtil.correctType(((PsiCapturedWildcardType)upperBound).getUpperBound(), placeResolveScope);
        }
        if (upperBound instanceof PsiArrayType) {
            return upperBound;
        }
        if (upperBound != null) {
            return InferenceSession.createTypeParameterTypeWithUpperBound(upperBound, methodCall);
        }
        return null;
    }

    public static PsiMethod getOverridingMethod(PsiAnonymousClass anonymousClass, String name) {
        PsiClass baseClass;
        PsiMethod[] refMethods = anonymousClass.findMethodsByName(name, false);
        if (refMethods.length > 0 && (baseClass = PsiUtil.resolveClassInType(anonymousClass.getBaseClassType())) != null && !PsiScopesUtil.hasCovariantOverridingOrNotPublic(baseClass, refMethods)) {
            for (PsiMethod method : refMethods) {
                if (method.findSuperMethods(baseClass).length <= 0) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean hasCovariantOverridingOrNotPublic(PsiClass baseClass, PsiMethod[] refMethods) {
        for (PsiMethod method : refMethods) {
            PsiType methodReturnType = method.getReturnType();
            for (PsiMethod superMethod : method.findSuperMethods(baseClass)) {
                if (!Comparing.equal(methodReturnType, superMethod.getReturnType())) {
                    return true;
                }
                if (superMethod.hasModifierProperty("public")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean processQualifierType(@NotNull PsiType type, MethodsProcessor processor, PsiManager manager, PsiMethodCallExpression call) throws MethodProcessorSetupFailedException {
        if (type == null) {
            PsiScopesUtil.$$$reportNull$$$0(14);
        }
        PsiUtil.ensureValidType(type);
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)type).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call);
        }
        if (type instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(call);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(manager.getProject());
            PsiClassType.ClassResolveResult qualifierResult = factory.getArrayClassType(((PsiArrayType)type).getComponentType(), languageLevel).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call);
        }
        if (type instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type).getConjuncts()) {
                if (PsiScopesUtil.processQualifierType(conjunct, processor, manager, call)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processQualifierResult(@NotNull JavaResolveResult qualifierResult, @NotNull MethodsProcessor processor, @NotNull PsiMethodCallExpression methodCall) throws MethodProcessorSetupFailedException {
        PsiElement resolve;
        if (qualifierResult == null) {
            PsiScopesUtil.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(16);
        }
        if (methodCall == null) {
            PsiScopesUtil.$$$reportNull$$$0(17);
        }
        if ((resolve = qualifierResult.getElement()) == null) {
            throw new MethodProcessorSetupFailedException("Cant determine qualifier class!");
        }
        if (resolve instanceof PsiTypeParameter) {
            processor.setAccessClass((PsiClass)resolve);
        } else if (resolve instanceof PsiClass) {
            PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
            if (!(qualifier instanceof PsiSuperExpression)) {
                processor.setAccessClass((PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement());
            } else if (((PsiSuperExpression)qualifier).getQualifier() != null && PsiUtil.isLanguageLevel8OrHigher(qualifier) && "java.lang.Cloneable".equals(((PsiClass)resolve).getQualifiedName()) && ((PsiClass)resolve).isInterface()) {
                processor.setAccessClass((PsiClass)resolve);
            }
        }
        processor.setIsConstructor(false);
        processor.setName(methodCall.getMethodExpression().getReferenceName());
        ResolveState state2 = ResolveState.initial().put(PsiSubstitutor.KEY, qualifierResult.getSubstitutor());
        return resolve.processDeclarations(processor, state2, methodCall, methodCall);
    }

    private static void processDummyConstructor(MethodsProcessor processor, PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        try {
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length != 0) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(aClass.getProject());
            PsiMethod dummyConstructor = factory.createConstructor();
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier != null) {
                Objects.requireNonNull(dummyConstructor.getNameIdentifier()).replace(nameIdentifier);
            }
            processor.forceAddResult(dummyConstructor);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisElement";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierResult";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/scope/util/PsiScopesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "treeWalkUp";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "walkChildrenScopes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveAndWalk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "setupAndRunProcessor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processQualifierType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "processQualifierResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

