/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.LanguageStubDefinition;
import com.intellij.psi.stubs.LanguageStubDefinitionAdapter;
import com.intellij.psi.stubs.LanguageStubDescriptor;
import com.intellij.psi.stubs.LanguageStubDescriptorAdapter;
import com.intellij.psi.stubs.LightLanguageStubDefinitionAdapter;
import com.intellij.psi.stubs.LightStubElementFactory;
import com.intellij.psi.stubs.LightStubElementFactoryAdapter;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElementFactory;
import com.intellij.psi.stubs.StubElementFactoryAdapter;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\n\u001a\u000e\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/psi/stubs/CoreStubElementRegistryServiceImpl;", "Lcom/intellij/psi/stubs/StubElementRegistryService;", "<init>", "()V", "getStubFactory", "Lcom/intellij/psi/stubs/StubElementFactory;", "type", "Lcom/intellij/psi/tree/IElementType;", "getLightStubFactory", "Lcom/intellij/psi/stubs/LightStubElementFactory;", "getStubSerializer", "Lcom/intellij/psi/stubs/ObjectStubSerializer;", "Lcom/intellij/psi/stubs/Stub;", "getStubDescriptor", "Lcom/intellij/psi/stubs/LanguageStubDescriptor;", "language", "Lcom/intellij/lang/Language;", "intellij.platform.core.impl"})
@ApiStatus.Internal
public class CoreStubElementRegistryServiceImpl
implements StubElementRegistryService {
    @Override
    @Nullable
    public StubElementFactory<?, ?> getStubFactory(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof IStubElementType) {
            return new StubElementFactoryAdapter((IStubElementType)type);
        }
        return null;
    }

    @Override
    @Nullable
    public LightStubElementFactory<?, ?> getLightStubFactory(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof ILightStubElementType) {
            return new LightStubElementFactoryAdapter((ILightStubElementType)type);
        }
        return null;
    }

    @Override
    @Nullable
    public ObjectStubSerializer<?, Stub> getStubSerializer(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof ObjectStubSerializer) {
            return (ObjectStubSerializer)((Object)type);
        }
        return null;
    }

    @Override
    @Nullable
    public LanguageStubDescriptor getStubDescriptor(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            return null;
        }
        ParserDefinition parserDefinition2 = parserDefinition;
        IFileElementType iFileElementType = parserDefinition2.getFileNodeType();
        IStubFileElementType iStubFileElementType = iFileElementType instanceof IStubFileElementType ? (IStubFileElementType)iFileElementType : null;
        if (iStubFileElementType == null) {
            return null;
        }
        IStubFileElementType fileNodeType = iStubFileElementType;
        LanguageStubDefinition stubDefinition = fileNodeType instanceof ILightStubFileElementType ? (LanguageStubDefinition)new LightLanguageStubDefinitionAdapter((ILightStubFileElementType)fileNodeType) : (LanguageStubDefinition)new LanguageStubDefinitionAdapter(fileNodeType);
        return new LanguageStubDescriptorAdapter(language, fileNodeType, stubDefinition);
    }
}

