/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.LanguageStubDescriptor;
import com.intellij.psi.stubs.LightStubElementFactory;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance(LightStubBuilder.class);
    @ApiStatus.Internal
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    @Override
    public StubElement<?> buildStubTree(@NotNull PsiFile file) {
        LighterAST tree;
        if (file == null) {
            LightStubBuilder.$$$reportNull$$$0(0);
        }
        if ((tree = FORCED_AST.get()) == null) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + file + ", " + fileType);
                return null;
            }
            if (!(file instanceof PsiFileImpl)) {
                LOG.error("Unexpected PsiFile instance: " + file + ", " + file.getClass());
                return null;
            }
            LanguageStubDescriptor stubDescriptor = ((PsiFileImpl)file).getStubDescriptor();
            if (stubDescriptor == null) {
                LOG.error("File is not of IStubFileElementType: " + file);
                return null;
            }
            FileASTNode node = file.getNode();
            IElementType nodeElementType = node.getElementType();
            tree = nodeElementType != stubDescriptor.getFileElementType() ? new TreeBackedLighterAST(node) : node.getLighterAST();
        } else {
            FORCED_AST.remove();
        }
        StubElement<?> rootStub = this.createStubForFile(file, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement<?> createStubForFile(@NotNull PsiFile file, @NotNull LighterAST tree) {
        if (file == null) {
            LightStubBuilder.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(2);
        }
        return new PsiFileStubImpl<PsiFile>(file);
    }

    protected void buildStubTree(@NotNull LighterAST tree, @NotNull LighterASTNode root, @NotNull StubElement<?> rootStub) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(3);
        }
        if (root == null) {
            LightStubBuilder.$$$reportNull$$$0(4);
        }
        if (rootStub == null) {
            LightStubBuilder.$$$reportNull$$$0(5);
        }
        Stack<LighterASTNode> parents2 = new Stack<LighterASTNode>();
        IntArrayList childNumbers = new IntArrayList();
        BooleanStack parentsStubbed = new BooleanStack();
        Stack<List> kinderGarden = new Stack<List>();
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        LighterASTNode parent = null;
        LighterASTNode element = root;
        List children2 = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        boolean immediateParentStubbed = true;
        block0: while (element != null) {
            List kids;
            boolean hasStub;
            ProgressManager.checkCanceled();
            StubElement<?> stub = LightStubBuilder.createStub(tree, element, parentStub);
            boolean bl = hasStub = stub != parentStub || parent == null;
            if (hasStub && !immediateParentStubbed) {
                ((ObjectStubBase)((Object)stub)).markDangling();
            }
            if (!(parent != null && this.skipNode(tree, parent, element) || (kids = tree.getChildren(element)).isEmpty())) {
                if (parent != null) {
                    parents2.push(parent);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children2);
                    parentStubs.push(parentStub);
                    parentsStubbed.push(immediateParentStubbed);
                }
                parent = element;
                immediateParentStubbed = hasStub;
                children2 = kids;
                childNumber = 0;
                element = children2.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent, element)) continue;
            }
            while (children2 != null && ++childNumber < children2.size()) {
                element = (LighterASTNode)children2.get(childNumber);
                if (this.skipNode(tree, parent, element)) continue;
                continue block0;
            }
            element = null;
            while (!parents2.isEmpty()) {
                parent = (LighterASTNode)parents2.pop();
                childNumber = childNumbers.popInt();
                children2 = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                immediateParentStubbed = parentsStubbed.pop();
                while (++childNumber < children2.size()) {
                    element = (LighterASTNode)children2.get(childNumber);
                    if (this.skipNode(tree, parent, element)) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    @NotNull
    private static StubElement<?> createStub(@NotNull LighterAST tree, @NotNull LighterASTNode element, @NotNull StubElement<?> parentStub) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(6);
        }
        if (element == null) {
            LightStubBuilder.$$$reportNull$$$0(7);
        }
        if (parentStub == null) {
            LightStubBuilder.$$$reportNull$$$0(8);
        }
        IElementType elementType = element.getTokenType();
        LightStubElementFactory<?, ?> factory = StubElementRegistryService.getInstance().getLightStubFactory(elementType);
        if (factory != null && factory.shouldCreateStub(tree, element, parentStub)) {
            Object obj = factory.createStub(tree, element, parentStub);
            if (obj == null) {
                LightStubBuilder.$$$reportNull$$$0(9);
            }
            return obj;
        }
        StubElement<?> stubElement = parentStub;
        if (stubElement == null) {
            LightStubBuilder.$$$reportNull$$$0(10);
        }
        return stubElement;
    }

    private boolean skipNode(LighterAST tree, LighterASTNode parent, LighterASTNode node) {
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent, node);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            LightStubBuilder.$$$reportNull$$$0(11);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(12);
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(13);
        }
        if (parent == null) {
            LightStubBuilder.$$$reportNull$$$0(14);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(15);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/LightStubBuilder";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/LightStubBuilder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

