/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.LanguageStubDescriptor;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubInconsistencyReporter;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContentImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubTextInconsistencyException
extends RuntimeException
implements ExceptionWithAttachments {
    private final String myStubsFromText;
    private final String myStubsFromPsi;
    private final String myFileName;
    private final String myFileText;

    private StubTextInconsistencyException(String message, PsiFile file, List<PsiFileStub<?>> fromText, List<PsiFileStub<?>> fromPsi) {
        super(message);
        this.myStubsFromText = StringUtil.join(fromText, DebugUtil::stubTreeToString, "\n");
        this.myStubsFromPsi = StringUtil.join(fromPsi, DebugUtil::stubTreeToString, "\n");
        this.myFileName = file.getName();
        this.myFileText = file.getText();
    }

    @NotNull
    public String getStubsFromText() {
        String string = this.myStubsFromText;
        if (string == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getStubsFromPsi() {
        String string = this.myStubsFromPsi;
        if (string == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public Attachment @NotNull [] getAttachments() {
        Attachment[] attachmentArray = new Attachment[]{new Attachment(this.myFileName, this.myFileText), new Attachment("stubsRestoredFromText.txt", this.myStubsFromText), new Attachment("stubsFromExistingPsi.txt", this.myStubsFromPsi)};
        if (attachmentArray == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(2);
        }
        return attachmentArray;
    }

    public static void checkStubTextConsistency(@NotNull PsiFile file) {
        if (file == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(3);
        }
        StubTextInconsistencyException.checkStubTextConsistency(file, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void checkStubTextConsistency(@NotNull PsiFile file, @NotNull StubInconsistencyReporter.SourceOfCheck reason, @Nullable StubInconsistencyReporter.EnforcedInconsistencyType enforcedInconsistencyType) {
        if (file == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(4);
        }
        if (reason == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(5);
        }
        StubTextInconsistencyException.checkStubTextConsistency(file, reason);
    }

    public static void checkStubTextConsistency(@NotNull PsiFile file, @Nullable StubInconsistencyReporter.SourceOfCheck reason) throws StubTextInconsistencyException {
        if (file == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(6);
        }
        PsiUtilCore.ensureValid(file);
        FileViewProvider viewProvider = file.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider || viewProvider.getVirtualFile() instanceof LightVirtualFile) {
            return;
        }
        PsiFile bindingRoot = viewProvider.getStubBindingRoot();
        if (!(bindingRoot instanceof PsiFileImpl)) {
            return;
        }
        LanguageStubDescriptor stubDescriptor = ((PsiFileImpl)bindingRoot).getStubDescriptor();
        if (stubDescriptor == null || !stubDescriptor.getStubDefinition().shouldBuildStubFor(viewProvider.getVirtualFile())) {
            return;
        }
        List<PsiFileStub<?>> fromText = StubTextInconsistencyException.restoreStubsFromText(viewProvider);
        List<PsiFileStub<?>> fromPsi = ContainerUtil.map(StubTreeBuilder.getStubbedRootDescriptors(viewProvider), p -> ((PsiFileImpl)p.getSecond()).calcStubTree().getRoot());
        if (fromPsi.size() != fromText.size()) {
            StubTextInconsistencyException.reportInconsistency(file, reason, StubInconsistencyReporter.InconsistencyType.DifferentNumberOfPsiTrees);
            throw new StubTextInconsistencyException("Inconsistent stub roots: PSI says it's " + ContainerUtil.map(fromPsi, s -> s.getElementType()) + " but re-parsing the text gives " + ContainerUtil.map(fromText, s -> s.getElementType()), file, fromText, fromPsi);
        }
        for (int i = 0; i < fromPsi.size(); ++i) {
            PsiFileStub psiStub = fromPsi.get(i);
            if (DebugUtil.stubTreeToString(psiStub).equals(DebugUtil.stubTreeToString(fromText.get(i)))) continue;
            StubTextInconsistencyException.reportInconsistency(file, reason, StubInconsistencyReporter.InconsistencyType.MismatchingPsiTree);
            throw new StubTextInconsistencyException("Stub is inconsistent with text in " + file.getLanguage(), file, fromText, fromPsi);
        }
    }

    private static void reportInconsistency(@NotNull PsiFile file, @Nullable StubInconsistencyReporter.SourceOfCheck reason, @NotNull StubInconsistencyReporter.InconsistencyType inconsistencyType) {
        if (file == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(7);
        }
        if (inconsistencyType == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(8);
        }
        StubInconsistencyReporter.getInstance().reportStubInconsistencyBetweenPsiAndText(file.getProject(), reason, inconsistencyType);
    }

    @NotNull
    private static List<PsiFileStub<?>> restoreStubsFromText(FileViewProvider viewProvider) {
        Project project = viewProvider.getManager().getProject();
        FileContentImpl fc = (FileContentImpl)FileContentImpl.createByText(viewProvider.getVirtualFile(), viewProvider.getContents(), project);
        fc.setProject(project);
        PsiFileStubImpl copyTree = (PsiFileStubImpl)StubTreeBuilder.buildStubTree(fc);
        List<PsiFileStub<?>> list = copyTree == null ? Collections.emptyList() : Arrays.asList(copyTree.getStubRoots());
        if (list == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubTextInconsistencyException";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inconsistencyType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsFromText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsFromPsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubTextInconsistencyException";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreStubsFromText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkStubTextConsistency";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportInconsistency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

