/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.refactoring.rename.FragmentaryPsiReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenameUtilBase {
    private static final Logger LOG = Logger.getInstance(RenameUtilBase.class);

    private RenameUtilBase() {
    }

    public static void doRenameGenericNamedElement(@NotNull PsiElement namedElement, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener2) {
        PsiMetaOwner owner;
        UsageInfo[] metaData;
        if (namedElement == null) {
            RenameUtilBase.$$$reportNull$$$0(0);
        }
        PsiWritableMetaData writableMetaData = null;
        if (namedElement instanceof PsiMetaOwner && (metaData = (owner = (PsiMetaOwner)((Object)namedElement)).getMetaData()) instanceof PsiWritableMetaData) {
            PsiWritableMetaData writableMeta;
            writableMetaData = writableMeta = (PsiWritableMetaData)metaData;
        }
        if (writableMetaData == null && !(namedElement instanceof PsiNamedElement)) {
            LOG.error("Unknown element type:" + String.valueOf(namedElement));
        }
        boolean hasBindables = false;
        for (UsageInfo usage : usages) {
            if (!(usage.getReference() instanceof BindablePsiReference)) {
                RenameUtilBase.rename(usage, newName);
                continue;
            }
            hasBindables = true;
        }
        if (writableMetaData != null) {
            writableMetaData.setName(newName);
        } else {
            PsiElement namedElementAfterRename = ((PsiNamedElement)namedElement).setName(newName);
            if (namedElementAfterRename != null) {
                namedElement = namedElementAfterRename;
            }
        }
        if (hasBindables) {
            for (UsageInfo usage : usages) {
                PsiReference ref = usage.getReference();
                if (ref == null) continue;
                RenameUtilBase.renameReference(namedElement, newName, ref);
            }
        }
        if (listener2 != null) {
            listener2.elementRenamed(namedElement);
        }
    }

    public static void renameReference(@NotNull PsiElement namedElement, String newName, @NotNull PsiReference ref) {
        if (namedElement == null) {
            RenameUtilBase.$$$reportNull$$$0(1);
        }
        if (ref == null) {
            RenameUtilBase.$$$reportNull$$$0(2);
        }
        if (ref instanceof BindablePsiReference) {
            FragmentaryPsiReference f;
            boolean fallback = true;
            if (!(ref instanceof FragmentaryPsiReference) || !(f = (FragmentaryPsiReference)ref).isFragmentOnlyRename()) {
                try {
                    ref.bindToElement(namedElement);
                    fallback = false;
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
            if (fallback) {
                ref.handleElementRename(newName);
            }
        }
    }

    public static void rename(UsageInfo info, String newName) {
        if (info.getElement() == null) {
            return;
        }
        PsiReference ref = info.getReference();
        if (ref == null) {
            return;
        }
        ref.handleElementRename(newName);
    }

    @ApiStatus.Internal
    public static UsageInfo createMoveRenameUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        PsiPolyVariantReference poly;
        if (element == null) {
            RenameUtilBase.$$$reportNull$$$0(3);
        }
        if (ref == null) {
            RenameUtilBase.$$$reportNull$$$0(4);
        }
        if (referenceElement == null) {
            RenameUtilBase.$$$reportNull$$$0(5);
        }
        return new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, ref.resolve() == null && (!(ref instanceof PsiPolyVariantReference) || (poly = (PsiPolyVariantReference)ref).multiResolve(true).length <= 0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/RenameUtilBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doRenameGenericNamedElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "renameReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createMoveRenameUsageInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

