/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OrderedSet<T>
extends ArrayList<T>
implements Set<T>,
RandomAccess {
    private final ObjectOpenCustomHashSet<T> hashSet;

    public OrderedSet() {
        this.hashSet = new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCanonicalStrategy());
    }

    public OrderedSet(@NotNull Collection<? extends T> set) {
        if (set == null) {
            OrderedSet.$$$reportNull$$$0(0);
        }
        super(set);
        this.hashSet = new ObjectOpenCustomHashSet<T>(set, FastUtilHashingStrategies.getCanonicalStrategy());
    }

    public OrderedSet(@NotNull HashingStrategy<? super T> hashingStrategy2) {
        if (hashingStrategy2 == null) {
            OrderedSet.$$$reportNull$$$0(1);
        }
        this.hashSet = new ObjectOpenCustomHashSet<T>(FastUtilHashingStrategies.adaptAsNotNull(hashingStrategy2));
    }

    public OrderedSet(int capacity) {
        super(capacity);
        this.hashSet = new ObjectOpenCustomHashSet(capacity, FastUtilHashingStrategies.getCanonicalStrategy());
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            OrderedSet.$$$reportNull$$$0(2);
        }
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            OrderedSet.$$$reportNull$$$0(3);
        }
        boolean removed = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            Object o = this.get(i);
            if (c.contains(o)) continue;
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.hashSet.contains(o);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        if (c == null) {
            OrderedSet.$$$reportNull$$$0(4);
        }
        boolean result = false;
        for (T t : c) {
            result |= this.add(t);
        }
        return result;
    }

    @Override
    public boolean add(T o) {
        if (this.hashSet.add(o)) {
            super.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.hashSet.remove(o)) {
            super.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.hashSet.clear();
        super.clear();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        if (c == null) {
            OrderedSet.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, @NotNull T element) {
        if (element == null) {
            OrderedSet.$$$reportNull$$$0(6);
        }
        T removed = this.remove(index);
        this.add(index, element);
        return removed;
    }

    @Override
    public void add(int index, @NotNull T element) {
        if (element == null) {
            OrderedSet.$$$reportNull$$$0(7);
        }
        if (this.hashSet.add(element)) {
            super.add(index, element);
        }
    }

    @Override
    public T remove(int index) {
        Object t = super.remove(index);
        this.hashSet.remove(t);
        return (T)t;
    }

    @Override
    public int indexOf(Object o) {
        T existing = this.hashSet.get(o);
        return existing == null ? -1 : super.indexOf(existing);
    }

    @Override
    public int lastIndexOf(Object o) {
        T existing = this.hashSet.get(o);
        return existing == null ? -1 : super.lastIndexOf(existing);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/OrderedSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAll";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "retainAll";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addAll";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

