/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 V2\u00020\u0001:\u0001VB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u0004\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\rJ\u0018\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0002J\u0018\u0010-\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\b\u0010.\u001a\u00020/H\u0002J \u00100\u001a\u00020/2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u00101\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0018\u00102\u001a\u00020/2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u00101\u001a\u00020!H\u0002J\u0010\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020\u0003H\u0002J\u0019\u00105\u001a\u00020/2\u0006\u00104\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\tH\u0086\u0002J \u00105\u001a\u00020/2\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\tJ\u0018\u00105\u001a\u00020/2\u0006\u00108\u001a\u0002092\b\b\u0002\u0010\u0015\u001a\u00020\tJ\u000e\u0010:\u001a\u00020/2\u0006\u00104\u001a\u00020\u0003J\u0016\u0010:\u001a\u00020/2\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003J\u000e\u0010:\u001a\u00020/2\u0006\u00108\u001a\u000209J\u0006\u0010:\u001a\u00020/J\u000e\u0010;\u001a\u00020/2\u0006\u00104\u001a\u00020\u0003J\u0016\u0010;\u001a\u00020/2\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003J\u000e\u0010;\u001a\u00020/2\u0006\u00108\u001a\u000209J\u0018\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\tH\u0002J\u0010\u0010?\u001a\u00020\u00032\b\b\u0002\u0010=\u001a\u00020\u0003J\u0010\u0010@\u001a\u00020\u00032\b\b\u0002\u0010=\u001a\u00020\u0003J\u0016\u0010A\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\tJ\u000e\u0010B\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003J\u000e\u0010C\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003J\u0011\u0010D\u001a\u00020\t2\u0006\u00104\u001a\u00020\u0003H\u0086\u0002J0\u0010E\u001a\u00020/2\u0006\u0010F\u001a\u00020\u00002\u001d\u0010G\u001a\u0019\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0H\u00a2\u0006\u0002\bIH\u0082\bJ\u000e\u0010J\u001a\u00020/2\u0006\u0010F\u001a\u00020\u0000J\u000e\u0010K\u001a\u00020/2\u0006\u0010F\u001a\u00020\u0000J\u000e\u0010L\u001a\u00020/2\u0006\u0010F\u001a\u00020\u0000J\u000e\u0010M\u001a\u00020/2\u0006\u0010F\u001a\u00020\u0000J\u000e\u0010N\u001a\u00020\t2\u0006\u0010F\u001a\u00020\u0000J\b\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020\u0003H\u0016J\u0013\u0010R\u001a\u00020\t2\b\u0010S\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010T\u001a\u00020\fJ\u0006\u0010U\u001a\u00020\u0003R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0018\u0010\u0017\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001d*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u00020!*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0018\u0010$\u001a\u00020!*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0018\u0010&\u001a\u00020!*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010#\u00a8\u0006W"}, d2={"Lcom/intellij/util/diff/BitSet;", "", "size", "", "<init>", "(I)V", "length", "initializer", "Lkotlin/Function1;", "", "(ILkotlin/jvm/functions/Function1;)V", "bits", "", "(I[J)V", "lastIndex", "getLastIndex", "()I", "lastTrueIndex", "getLastTrueIndex", "isEmpty", "()Z", "value", "getSize", "elementIndex", "getElementIndex", "(I)I", "bitOffset", "getBitOffset", "asBitCoordinates", "Lkotlin/Pair;", "getAsBitCoordinates", "(I)Lkotlin/Pair;", "asMask", "", "getAsMask", "(I)J", "asMaskBefore", "getAsMaskBefore", "asMaskAfter", "getAsMaskAfter", "getMaskBetween", "fromOffset", "toOffset", "bitToElementSize", "bitSize", "bitIndex", "clearUnusedTail", "", "setBitsWithMask", "mask", "flipBitsWithMask", "ensureCapacity", "index", "set", "from", "to", "range", "Lkotlin/ranges/IntRange;", "clear", "flip", "nextBit", "startIndex", "lookFor", "nextSetBit", "nextClearBit", "previousBit", "previousSetBit", "previousClearBit", "get", "doOperation", "another", "operation", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "and", "or", "xor", "andNot", "intersects", "toString", "", "hashCode", "equals", "other", "toLongArray", "cardinality", "Companion", "intellij.platform.util.diff"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitSet.kt\ncom/intellij/util/diff/BitSet\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,439:1\n345#1,11:442\n345#1,11:453\n345#1,11:464\n12490#2,2:440\n1761#3,3:475\n1#4:478\n*S KotlinDebug\n*F\n+ 1 BitSet.kt\ncom/intellij/util/diff/BitSet\n*L\n358#1:442,11\n361#1:453,11\n364#1:464,11\n28#1:440,2\n382#1:475,3\n*E\n"})
public final class BitSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] bits;
    private int size;
    private static final int ELEMENT_SIZE = 64;
    private static final int MAX_BIT_OFFSET = 63;
    private static final long ALL_TRUE = -1L;
    private static final long ALL_FALSE = 0L;

    public BitSet(int size) {
        this.bits = new long[this.bitToElementSize(size)];
        this.size = size;
    }

    public /* synthetic */ BitSet(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        this(n);
    }

    private final int getLastIndex() {
        return this.size - 1;
    }

    public final int getLastTrueIndex() {
        return this.previousSetBit(this.size);
    }

    public final boolean isEmpty() {
        boolean bl;
        block1: {
            long[] $this$all$iv = this.bits;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                long element$iv;
                long it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it == 0L) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public final int getSize() {
        return this.size;
    }

    public BitSet(int length, @NotNull Function1<? super Integer, Boolean> initializer) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        this(length);
        for (int i = 0; i < length; ++i) {
            this.set(i, (boolean)((Boolean)initializer.invoke((Object)i)));
        }
    }

    public BitSet(int length, @NotNull long[] bits) {
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        this(length);
        long[] lArray = Arrays.copyOf(bits, this.bitToElementSize(length));
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        this.bits = lArray;
    }

    private final int getElementIndex(int $this$elementIndex) {
        return $this$elementIndex / 64;
    }

    private final int getBitOffset(int $this$bitOffset) {
        return $this$bitOffset % 64;
    }

    private final Pair<Integer, Integer> getAsBitCoordinates(int $this$asBitCoordinates) {
        return new Pair((Object)this.getElementIndex($this$asBitCoordinates), (Object)this.getBitOffset($this$asBitCoordinates));
    }

    private final long getAsMask(int $this$asMask) {
        return 1L << $this$asMask;
    }

    private final long getAsMaskBefore(int $this$asMaskBefore) {
        return this.getMaskBetween(0, $this$asMaskBefore);
    }

    private final long getAsMaskAfter(int $this$asMaskAfter) {
        return this.getMaskBetween($this$asMaskAfter, 63);
    }

    private final long getMaskBetween(int fromOffset, int toOffset) {
        long res = 0L;
        long maskToAdd = this.getAsMask(fromOffset);
        int i = fromOffset;
        if (i <= toOffset) {
            while (true) {
                res = res << 1 | maskToAdd;
                if (i == toOffset) break;
                ++i;
            }
        }
        return res;
    }

    private final int bitToElementSize(int bitSize) {
        return (bitSize + 64 - 1) / 64;
    }

    private final int bitIndex(int elementIndex, int bitOffset) {
        return elementIndex * 64 + bitOffset;
    }

    private final void clearUnusedTail() {
        Pair<Integer, Integer> pair = this.getAsBitCoordinates(this.getLastIndex());
        int lastElementIndex = ((Number)pair.component1()).intValue();
        int lastBitOffset = ((Number)pair.component2()).intValue();
        this.bits[ArraysKt.getLastIndex((long[])this.bits)] = this.bits[ArraysKt.getLastIndex((long[])this.bits)] & this.getAsMaskBefore(lastBitOffset);
        int n = this.bits.length;
        for (int i = lastElementIndex + 1; i < n; ++i) {
            this.bits[i] = 0L;
        }
    }

    private final void setBitsWithMask(int elementIndex, long mask, boolean value) {
        long element = this.bits[elementIndex];
        this.bits[elementIndex] = value ? element | mask : element & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private final void flipBitsWithMask(int elementIndex, long mask) {
        long element = this.bits[elementIndex];
        this.bits[elementIndex] = element ^ mask;
    }

    private final void ensureCapacity(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.size) {
            this.size = index + 1;
            if (this.getElementIndex(index) >= this.bits.length) {
                long[] lArray = Arrays.copyOf(this.bits, this.bitToElementSize(index + 1));
                Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
                this.bits = lArray;
            }
            this.clearUnusedTail();
        }
    }

    public final void set(int index, boolean value) {
        this.ensureCapacity(index);
        Pair<Integer, Integer> pair = this.getAsBitCoordinates(index);
        int elementIndex = ((Number)pair.component1()).intValue();
        int offset = ((Number)pair.component2()).intValue();
        this.setBitsWithMask(elementIndex, this.getAsMask(offset), value);
    }

    public final void set(int from, int to, boolean value) {
        this.set(RangesKt.until((int)from, (int)to), value);
    }

    public static /* synthetic */ void set$default(BitSet bitSet, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        bitSet.set(n, n2, bl);
    }

    public final void set(@NotNull IntRange range, boolean value) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (range.getStart() < 0 || range.getEndInclusive() < -1) {
            throw new IndexOutOfBoundsException();
        }
        if (range.getStart() > range.getEndInclusive()) {
            return;
        }
        this.ensureCapacity(range.getEndInclusive());
        Pair<Integer, Integer> pair = this.getAsBitCoordinates(range.getStart());
        int fromIndex = ((Number)pair.component1()).intValue();
        int fromOffset = ((Number)pair.component2()).intValue();
        Pair<Integer, Integer> pair2 = this.getAsBitCoordinates(range.getEndInclusive());
        int toIndex = ((Number)pair2.component1()).intValue();
        int toOffset = ((Number)pair2.component2()).intValue();
        if (toIndex == fromIndex) {
            long mask = this.getMaskBetween(fromOffset, toOffset);
            this.setBitsWithMask(fromIndex, mask, value);
        } else {
            this.setBitsWithMask(fromIndex, this.getAsMaskAfter(fromOffset), value);
            for (int index = fromIndex + 1; index < toIndex; ++index) {
                this.bits[index] = value ? -1L : 0L;
            }
            this.setBitsWithMask(toIndex, this.getAsMaskBefore(toOffset), value);
        }
    }

    public static /* synthetic */ void set$default(BitSet bitSet, IntRange intRange, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        bitSet.set(intRange, bl);
    }

    public final void clear(int index) {
        this.set(index, false);
    }

    public final void clear(int from, int to) {
        this.set(from, to, false);
    }

    public final void clear(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.set(range, false);
    }

    public final void clear() {
        int n = this.bits.length;
        for (int i = 0; i < n; ++i) {
            this.bits[i] = 0L;
        }
    }

    public final void flip(int index) {
        this.ensureCapacity(index);
        Pair<Integer, Integer> pair = this.getAsBitCoordinates(index);
        int elementIndex = ((Number)pair.component1()).intValue();
        int offset = ((Number)pair.component2()).intValue();
        this.flipBitsWithMask(elementIndex, this.getAsMask(offset));
    }

    public final void flip(int from, int to) {
        this.flip(RangesKt.until((int)from, (int)to));
    }

    public final void flip(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (range.getStart() < 0 || range.getEndInclusive() < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (range.getStart() > range.getEndInclusive()) {
            return;
        }
        this.ensureCapacity(range.getEndInclusive());
        Pair<Integer, Integer> pair = this.getAsBitCoordinates(range.getStart());
        int fromIndex = ((Number)pair.component1()).intValue();
        int fromOffset = ((Number)pair.component2()).intValue();
        Pair<Integer, Integer> pair2 = this.getAsBitCoordinates(range.getEndInclusive());
        int toIndex = ((Number)pair2.component1()).intValue();
        int toOffset = ((Number)pair2.component2()).intValue();
        if (toIndex == fromIndex) {
            long mask = this.getMaskBetween(fromOffset, toOffset);
            this.flipBitsWithMask(fromIndex, mask);
        } else {
            this.flipBitsWithMask(toIndex, this.getAsMaskAfter(toOffset));
            for (int index = fromIndex + 1; index < toIndex; ++index) {
                this.bits[index] = this.bits[index] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.flipBitsWithMask(toIndex, this.getAsMaskBefore(toOffset));
        }
    }

    private final int nextBit(int startIndex, boolean lookFor) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (startIndex >= this.size) {
            return lookFor ? -1 : startIndex;
        }
        Pair<Integer, Integer> pair = this.getAsBitCoordinates(startIndex);
        int startElementIndex = ((Number)pair.component1()).intValue();
        int startOffset = ((Number)pair.component2()).intValue();
        long element = this.bits[startElementIndex];
        for (int offset = startOffset; offset < 64; ++offset) {
            boolean bit;
            boolean bl = bit = (element & 1L << offset) != 0L;
            if (bit != lookFor) continue;
            return this.bitIndex(startElementIndex, offset);
        }
        int index = startElementIndex + 1;
        int n = ArraysKt.getLastIndex((long[])this.bits);
        if (index <= n) {
            while (true) {
                element = this.bits[index];
                for (int offset = 0; offset < 64; ++offset) {
                    boolean bit;
                    boolean bl = bit = (element & 1L << offset) != 0L;
                    if (bit != lookFor) continue;
                    return this.bitIndex(index, offset);
                }
                if (index == n) break;
                ++index;
            }
        }
        return lookFor ? -1 : this.size;
    }

    public final int nextSetBit(int startIndex) {
        return this.nextBit(startIndex, true);
    }

    public static /* synthetic */ int nextSetBit$default(BitSet bitSet, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return bitSet.nextSetBit(n);
    }

    public final int nextClearBit(int startIndex) {
        return this.nextBit(startIndex, false);
    }

    public static /* synthetic */ int nextClearBit$default(BitSet bitSet, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return bitSet.nextClearBit(n);
    }

    public final int previousBit(int startIndex, boolean lookFor) {
        int correctStartIndex = startIndex;
        if (startIndex >= this.size) {
            if (!lookFor) {
                return startIndex;
            }
            correctStartIndex = this.size - 1;
        }
        if (correctStartIndex < -1) {
            throw new IndexOutOfBoundsException();
        }
        if (correctStartIndex == -1) {
            return -1;
        }
        Pair<Integer, Integer> pair = this.getAsBitCoordinates(correctStartIndex);
        int startElementIndex = ((Number)pair.component1()).intValue();
        int startOffset = ((Number)pair.component2()).intValue();
        long element = this.bits[startElementIndex];
        for (int offset = startOffset; -1 < offset; --offset) {
            boolean bit;
            boolean bl = bit = (element & 1L << offset) != 0L;
            if (bit != lookFor) continue;
            return this.bitIndex(startElementIndex, offset);
        }
        for (int index = startElementIndex - 1; -1 < index; --index) {
            element = this.bits[index];
            for (int offset = 63; -1 < offset; --offset) {
                boolean bit;
                boolean bl = bit = (element & 1L << offset) != 0L;
                if (bit != lookFor) continue;
                return this.bitIndex(index, offset);
            }
        }
        return -1;
    }

    public final int previousSetBit(int startIndex) {
        return this.previousBit(startIndex, true);
    }

    public final int previousClearBit(int startIndex) {
        return this.previousBit(startIndex, false);
    }

    public final boolean get(int index) {
        int offset;
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.size) {
            return false;
        }
        Pair<Integer, Integer> pair = this.getAsBitCoordinates(index);
        int elementIndex = ((Number)pair.component1()).intValue();
        return (this.bits[elementIndex] & this.getAsMask(offset = ((Number)pair.component2()).intValue())) != 0L;
    }

    private final void doOperation(BitSet another, Function2<? super Long, ? super Long, Long> operation) {
        int index;
        boolean $i$f$doOperation = false;
        this.ensureCapacity(another.getLastIndex());
        for (index = 0; index < another.bits.length; ++index) {
            this.bits[index] = ((Number)operation.invoke((Object)this.bits[index], (Object)another.bits[index])).longValue();
        }
        while (index < this.bits.length) {
            this.bits[index] = ((Number)operation.invoke((Object)this.bits[index], (Object)0L)).longValue();
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void and(@NotNull BitSet another) {
        long p1;
        long p0;
        long l;
        boolean bl;
        long[] lArray;
        int n;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        BitSet bitSet = this;
        BitSet another$iv = another;
        boolean $i$f$doOperation = false;
        super.ensureCapacity(another$iv.getLastIndex());
        int index$iv = 0;
        while (index$iv < another$iv.bits.length) {
            long l2 = another$iv.bits[index$iv];
            long l3 = this_$iv.bits[index$iv];
            n = index$iv++;
            lArray = this_$iv.bits;
            bl = false;
            lArray[n] = l = p0 & p1;
        }
        while (index$iv < this_$iv.bits.length) {
            p1 = 0L;
            p0 = this_$iv.bits[index$iv];
            n = index$iv++;
            lArray = this_$iv.bits;
            bl = false;
            lArray[n] = l = p0 & p1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void or(@NotNull BitSet another) {
        long p1;
        long p0;
        long l;
        boolean bl;
        long[] lArray;
        int n;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        BitSet bitSet = this;
        BitSet another$iv = another;
        boolean $i$f$doOperation = false;
        super.ensureCapacity(another$iv.getLastIndex());
        int index$iv = 0;
        while (index$iv < another$iv.bits.length) {
            long l2 = another$iv.bits[index$iv];
            long l3 = this_$iv.bits[index$iv];
            n = index$iv++;
            lArray = this_$iv.bits;
            bl = false;
            lArray[n] = l = p0 | p1;
        }
        while (index$iv < this_$iv.bits.length) {
            p1 = 0L;
            p0 = this_$iv.bits[index$iv];
            n = index$iv++;
            lArray = this_$iv.bits;
            bl = false;
            lArray[n] = l = p0 | p1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void xor(@NotNull BitSet another) {
        long p1;
        long p0;
        long l;
        boolean bl;
        long[] lArray;
        int n;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        BitSet bitSet = this;
        BitSet another$iv = another;
        boolean $i$f$doOperation = false;
        super.ensureCapacity(another$iv.getLastIndex());
        int index$iv = 0;
        while (index$iv < another$iv.bits.length) {
            long l2 = another$iv.bits[index$iv];
            long l3 = this_$iv.bits[index$iv];
            n = index$iv++;
            lArray = this_$iv.bits;
            bl = false;
            lArray[n] = l = p0 ^ p1;
        }
        while (index$iv < this_$iv.bits.length) {
            p1 = 0L;
            p0 = this_$iv.bits[index$iv];
            n = index$iv++;
            lArray = this_$iv.bits;
            bl = false;
            lArray[n] = l = p0 ^ p1;
        }
    }

    public final void andNot(@NotNull BitSet another) {
        int index;
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        this.ensureCapacity(another.getLastIndex());
        for (index = 0; index < another.bits.length; ++index) {
            this.bits[index] = this.bits[index] & (another.bits[index] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        while (index < this.bits.length) {
            this.bits[index] = this.bits[index] & 0xFFFFFFFFFFFFFFFFL;
            ++index;
        }
    }

    public final boolean intersects(@NotNull BitSet another) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)another, (String)"another");
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)Math.min(this.bits.length, another.bits.length));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!((this.bits[it] & another.bits[it]) != 0L)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first2 = true;
        sb.append('[');
        int index = this.nextSetBit(0);
        while (index != -1) {
            if (!first2) {
                sb.append('|');
            } else {
                first2 = false;
            }
            sb.append(index);
            index = this.nextSetBit(index + 1);
        }
        sb.append(']');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public int hashCode() {
        long x = 1234L;
        int i = 0;
        int n = ArraysKt.getLastIndex((long[])this.bits);
        if (i <= n) {
            while (true) {
                x ^= this.bits[i] * (long)(i + 1);
                if (i == n) break;
                ++i;
            }
        }
        return (int)(x >> 32 ^ x);
    }

    public boolean equals(@Nullable Object other) {
        long[] longestBits;
        int index;
        if (this == other) {
            return true;
        }
        if (!(other instanceof BitSet)) {
            return false;
        }
        for (index = 0; index < Math.min(this.bits.length, ((BitSet)other).bits.length); ++index) {
            if (this.bits[index] == ((BitSet)other).bits[index]) continue;
            return false;
        }
        long[] lArray = longestBits = this.bits.length > ((BitSet)other).bits.length ? this.bits : ((BitSet)other).bits;
        while (index < longestBits.length) {
            if (longestBits[index] != 0L) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @NotNull
    public final long[] toLongArray() {
        long[] lArray = Arrays.copyOf(this.bits, this.bits.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    public final int cardinality() {
        long[] lArray = this.bits;
        int n = 0;
        int n2 = lArray.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            long l;
            long l2 = l = lArray[i];
            int n3 = n;
            boolean bl = false;
            int n4 = Long.bitCount((long)it);
            n = n3 + n4;
        }
        return n;
    }

    public BitSet() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/util/diff/BitSet$Companion;", "", "<init>", "()V", "ELEMENT_SIZE", "", "MAX_BIT_OFFSET", "ALL_TRUE", "", "ALL_FALSE", "intellij.platform.util.diff"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

