/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fastutil.ints;

import com.intellij.util.fastutil.ints.IntArrays;
import com.intellij.util.fastutil.ints.IntIterator;
import com.intellij.util.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a*\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005*\u00020\u00022\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00050\u0007\u001a,\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005*\u00020\u00022\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\u0007\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\u0002\u001a$\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\u000f\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a<\u0010\u0011\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00040\u0012*\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"toIntArray", "", "Lcom/intellij/util/fastutil/ints/IntSet;", "map", "", "V", "transform", "Lkotlin/Function1;", "", "mapNotNull", "isEmpty", "", "isNotEmpty", "forEach", "", "containsAll", "other", "partition", "Lkotlin/Pair;", "predicate", "intellij.platform.util.multiplatform"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIntSetExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntSetExtensions.kt\ncom/intellij/util/fastutil/ints/IntSetExtensionsKt\n+ 2 IntIteratorExtensions.kt\ncom/intellij/util/fastutil/ints/IntIteratorExtensionsKt\n*L\n1#1,74:1\n8#2,2:75\n*S KotlinDebug\n*F\n+ 1 IntSetExtensions.kt\ncom/intellij/util/fastutil/ints/IntSetExtensionsKt\n*L\n65#1:75,2\n*E\n"})
public final class IntSetExtensionsKt {
    @NotNull
    public static final int[] toIntArray(@NotNull IntSet $this$toIntArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toIntArray, (String)"<this>");
        int size = $this$toIntArray.getSize();
        if (size == 0) {
            return IntArrays.INSTANCE.getEMPTY_ARRAY();
        }
        int[] a = new int[size];
        IntArrays.INSTANCE.unwrap($this$toIntArray.getValues(), a);
        return a;
    }

    @NotNull
    public static final <V> List<V> map(@NotNull IntSet $this$map, @NotNull Function1<? super Integer, ? extends V> transform2) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        ArrayList<Object> res = new ArrayList<Object>();
        IntIterator iter = $this$map.getValues();
        while (iter.hasNext()) {
            int element = iter.next();
            res.add(transform2.invoke((Object)element));
        }
        return res;
    }

    @NotNull
    public static final <V> List<V> mapNotNull(@NotNull IntSet $this$mapNotNull, @NotNull Function1<? super Integer, ? extends V> transform2) {
        Intrinsics.checkNotNullParameter((Object)$this$mapNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        ArrayList<Object> res = new ArrayList<Object>();
        IntIterator iter = $this$mapNotNull.getValues();
        while (iter.hasNext()) {
            int element = iter.next();
            Object transformed = transform2.invoke((Object)element);
            if (transformed == null) continue;
            res.add(transformed);
        }
        return res;
    }

    public static final boolean isEmpty(@NotNull IntSet $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return $this$isEmpty.getSize() == 0;
    }

    public static final boolean isNotEmpty(@NotNull IntSet $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        return $this$isNotEmpty.getSize() != 0;
    }

    public static final void forEach(@NotNull IntSet $this$forEach, @NotNull Function1<? super Integer, Unit> transform2) {
        Intrinsics.checkNotNullParameter((Object)$this$forEach, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        boolean $i$f$forEach = false;
        IntIterator iter = $this$forEach.getValues();
        while (iter.hasNext()) {
            transform2.invoke((Object)iter.next());
        }
    }

    public static final boolean containsAll(@NotNull IntSet $this$containsAll, @NotNull IntSet other) {
        Intrinsics.checkNotNullParameter((Object)$this$containsAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        IntIterator iter = other.getValues();
        while (iter.hasNext()) {
            if ($this$containsAll.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final Pair<List<Integer>, List<Integer>> partition(@NotNull IntSet $this$partition, @NotNull Function1<? super Integer, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$partition, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$partition = false;
        ArrayList<Integer> first2 = new ArrayList<Integer>();
        ArrayList<Integer> second2 = new ArrayList<Integer>();
        IntIterator $this$forEach$iv = $this$partition.getValues();
        boolean $i$f$forEach = false;
        while ($this$forEach$iv.hasNext()) {
            int it = $this$forEach$iv.next();
            boolean bl = false;
            boolean bl2 = (Boolean)predicate.invoke((Object)it) != false ? first2.add(it) : second2.add(it);
        }
        return new Pair(first2, second2);
    }
}

