/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.IOCancellationCallbackHolder;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collection;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InvertedIndexUtil {
    @NotNull
    public static <K, V, I> IntSet collectInputIdsContainingAllKeys(@NotNull InvertedIndex<? super K, V, I> index, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super V> valueChecker, @Nullable IntPredicate idChecker) throws StorageException {
        if (index == null) {
            InvertedIndexUtil.$$$reportNull$$$0(0);
        }
        if (dataKeys == null) {
            InvertedIndexUtil.$$$reportNull$$$0(1);
        }
        Ref<Object> mainIntersectionRef = new Ref<Object>(null);
        for (K dataKey : dataKeys) {
            IOCancellationCallbackHolder.checkCancelled();
            IntOpenHashSet copy = new IntOpenHashSet();
            index.withData(dataKey, container -> {
                ValueContainer.ValueIterator valueIt = container.getValueIterator();
                while (valueIt.hasNext()) {
                    IntPredicate predicate;
                    Object value = valueIt.next();
                    if (valueChecker != null && !valueChecker.value((Object)value)) continue;
                    IOCancellationCallbackHolder.checkCancelled();
                    ValueContainer.IntIterator iterator2 = valueIt.getInputIdsIterator();
                    if (mainIntersectionRef.isNull() || iterator2.size() < ((IntSet)mainIntersectionRef.get()).size() || (predicate = valueIt.getValueAssociationPredicate()) == null) {
                        while (iterator2.hasNext()) {
                            int id = iterator2.next();
                            if ((!mainIntersectionRef.isNull() || idChecker != null && !idChecker.test(id)) && (mainIntersectionRef.isNull() || !((IntSet)mainIntersectionRef.get()).contains(id))) continue;
                            copy.add(id);
                        }
                        continue;
                    }
                    IntIterator intIterator = ((IntSet)mainIntersectionRef.get()).iterator();
                    while (intIterator.hasNext()) {
                        int id = intIterator.nextInt();
                        if (!predicate.test(id) || idChecker != null && !idChecker.test(id)) continue;
                        copy.add(id);
                    }
                }
                return true;
            });
            mainIntersectionRef.set(copy);
            if (!((IntSet)mainIntersectionRef.get()).isEmpty()) continue;
            IntSets.EmptySet emptySet = IntSets.EMPTY_SET;
            if (emptySet == null) {
                InvertedIndexUtil.$$$reportNull$$$0(2);
            }
            return emptySet;
        }
        IntSet intSet = mainIntersectionRef.isNull() ? IntSets.EMPTY_SET : (IntSet)mainIntersectionRef.get();
        if (intSet == null) {
            InvertedIndexUtil.$$$reportNull$$$0(3);
        }
        return intSet;
    }

    @NotNull
    public static <K, V, I> IntSet collectInputIdsContainingAnyKey(@NotNull InvertedIndex<? super K, V, I> index, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super V> valueChecker, @Nullable IntPredicate idChecker) throws StorageException {
        if (index == null) {
            InvertedIndexUtil.$$$reportNull$$$0(4);
        }
        if (dataKeys == null) {
            InvertedIndexUtil.$$$reportNull$$$0(5);
        }
        Ref<Object> resultRef = new Ref<Object>(null);
        for (K dataKey : dataKeys) {
            IOCancellationCallbackHolder.checkCancelled();
            index.withData(dataKey, container -> {
                ValueContainer.ValueIterator valueIt = container.getValueIterator();
                while (valueIt.hasNext()) {
                    Object value = valueIt.next();
                    if (valueChecker != null && !valueChecker.value((Object)value)) continue;
                    IOCancellationCallbackHolder.checkCancelled();
                    ValueContainer.IntIterator iterator2 = valueIt.getInputIdsIterator();
                    while (iterator2.hasNext()) {
                        int id = iterator2.next();
                        if (idChecker != null && !idChecker.test(id)) continue;
                        if (resultRef.isNull()) {
                            resultRef.set(new IntOpenHashSet());
                        }
                        ((IntSet)resultRef.get()).add(id);
                    }
                }
                return true;
            });
        }
        IntSet intSet = resultRef.isNull() ? IntSets.EMPTY_SET : (IntSet)resultRef.get();
        if (intSet == null) {
            InvertedIndexUtil.$$$reportNull$$$0(6);
        }
        return intSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/InvertedIndexUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/InvertedIndexUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInputIdsContainingAllKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInputIdsContainingAnyKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInputIdsContainingAllKeys";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInputIdsContainingAnyKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

