/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LongLinkedHashMap;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.PageCacheUtils;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.stats.FilePageCacheStatistics;
import com.intellij.util.lang.CompoundRuntimeException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class FilePageCache {
    private static final Logger LOG = Logger.getInstance(FilePageCache.class);
    private static final boolean THROW_ERROR_ON_DUPLICATE_STORAGE_REGISTRATION = SystemProperties.getBooleanProperty("FilePageCache.THROW_ERROR_ON_DUPLICATE_STORAGE_REGISTRATION", true);
    private static final boolean KEEP_STACK_TRACE_AT_STORAGE_REGISTRATION = SystemProperties.getBooleanProperty("FilePageCache.KEEP_STACK_TRACE_AT_STORAGE_REGISTRATION", true);
    private static final boolean COLLECT_PAGE_LOADING_TIMES = true;
    static final long MAX_PAGES_COUNT = 0xFFFFFFFFL;
    private static final long FILE_INDEX_MASK = -4294967296L;
    private final Int2ObjectMap<PagedFileStorage> storageById = new Int2ObjectOpenHashMap<PagedFileStorage>();
    private final Map<Path, Exception> stackTracesOfStorageRegistration = KEEP_STACK_TRACE_AT_STORAGE_REGISTRATION ? new HashMap() : null;
    private final Map<Path, PagedFileStorage> storageByAbsolutePath = new HashMap<Path, PagedFileStorage>();
    private final ReentrantLock pagesAccessLock = new ReentrantLock();
    private final ReentrantLock pagesAllocationLock = new ReentrantLock();
    private final LongLinkedHashMap<DirectBufferWrapper> pagesByPageId;
    private final Long2ObjectLinkedOpenHashMap<DirectBufferWrapper> pagesToRemoveByPageId = new Long2ObjectLinkedOpenHashMap();
    private final long cachedSizeLimit;
    private long totalSizeCached;
    private volatile int myUncachedFileAccess;
    private int myFastCacheHits;
    private int myHits;
    private int myPageLoadsAboveSizeThreshold;
    private int myRegularPageLoads;
    private long myMaxLoadedSize;
    private volatile int myMaxRegisteredFiles;
    private volatile int myMappingChangeCount;
    private long myLoadedPages;
    private long myPageLoadUs;
    private long myPageDisposalUs;

    FilePageCache(long cacheCapacityBytes) {
        if (cacheCapacityBytes <= 0L) {
            throw new IllegalArgumentException("Capacity(=" + cacheCapacityBytes + ") must be >0");
        }
        this.cachedSizeLimit = cacheCapacityBytes;
        this.pagesByPageId = new LongLinkedHashMap<DirectBufferWrapper>(10, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(LongLinkedHashMap.Entry<DirectBufferWrapper> eldest) {
                assert (FilePageCache.this.pagesAccessLock.isHeldByCurrentThread());
                return FilePageCache.this.totalSizeCached > FilePageCache.this.cachedSizeLimit;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public DirectBufferWrapper put(long key, @NotNull DirectBufferWrapper directBufferWrapper) {
                void wrapper;
                if (directBufferWrapper == null) {
                    1.$$$reportNull$$$0(0);
                }
                FilePageCache.this.totalSizeCached += wrapper.getLength();
                DirectBufferWrapper oldShouldBeNull = (DirectBufferWrapper)super.put(key, wrapper);
                FilePageCache.this.myMaxLoadedSize = Math.max(FilePageCache.this.myMaxLoadedSize, FilePageCache.this.totalSizeCached);
                return oldShouldBeNull;
            }

            @Override
            @Nullable
            public DirectBufferWrapper remove(long key) {
                assert (FilePageCache.this.pagesAccessLock.isHeldByCurrentThread());
                DirectBufferWrapper wrapper = (DirectBufferWrapper)super.remove(key);
                if (wrapper != null) {
                    FilePageCache.this.myMappingChangeCount++;
                    FilePageCache.this.assertUnderSegmentAllocationLock();
                    FilePageCache.this.pagesToRemoveByPageId.put(key, wrapper);
                    FilePageCache.this.totalSizeCached -= wrapper.getLength();
                }
                return wrapper;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/util/io/FilePageCache$1", "put"));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectBufferWrapper get(long pageId, boolean read2, boolean checkAccess) throws IOException {
        DirectBufferWrapper wrapper;
        this.pagesAccessLock.lock();
        try {
            wrapper = this.pagesByPageId.get(pageId);
            if (wrapper != null) {
                ++this.myHits;
                DirectBufferWrapper directBufferWrapper = wrapper;
                return directBufferWrapper;
            }
        }
        finally {
            this.pagesAccessLock.unlock();
        }
        this.pagesAllocationLock.lock();
        try {
            DirectBufferWrapper notYetRemoved = this.pagesToRemoveByPageId.remove(pageId);
            if (notYetRemoved != null) {
                DirectBufferWrapper previous;
                this.pagesAccessLock.lock();
                try {
                    previous = this.pagesByPageId.put(pageId, notYetRemoved);
                    assert (previous == null);
                }
                finally {
                    this.pagesAccessLock.unlock();
                }
                this.disposeRemovedSegments(null);
                ++this.myHits;
                previous = notYetRemoved;
                return previous;
            }
            this.pagesAccessLock.lock();
            try {
                wrapper = this.pagesByPageId.get(pageId);
                if (wrapper != null) {
                    DirectBufferWrapper previous = wrapper;
                    return previous;
                }
            }
            finally {
                this.pagesAccessLock.unlock();
            }
            long startedAtNs = System.nanoTime();
            PagedFileStorage fileStorage = this.getRegisteredPagedFileStorageByIndex(pageId);
            this.disposeRemovedSegments(null);
            long disposeFinishedAtNs = System.nanoTime();
            wrapper = FilePageCache.allocateAndLoadPage(pageId, read2, fileStorage, checkAccess);
            long finishedAtNs = System.nanoTime();
            ++this.myLoadedPages;
            this.myPageLoadUs += TimeUnit.NANOSECONDS.toMicros(finishedAtNs - disposeFinishedAtNs);
            this.myPageDisposalUs += TimeUnit.NANOSECONDS.toMicros(disposeFinishedAtNs - startedAtNs);
            this.pagesAccessLock.lock();
            try {
                if (this.totalSizeCached + (long)fileStorage.getPageSize() < this.cachedSizeLimit) {
                    ++this.myRegularPageLoads;
                } else {
                    ++this.myPageLoadsAboveSizeThreshold;
                }
                this.pagesByPageId.put(pageId, wrapper);
            }
            finally {
                this.pagesAccessLock.unlock();
            }
            this.ensureSize(this.cachedSizeLimit);
            DirectBufferWrapper directBufferWrapper = wrapper;
            return directBufferWrapper;
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    public void incrementUncachedFileAccess() {
        ++this.myUncachedFileAccess;
    }

    public void incrementFastCacheHitsCount() {
        ++this.myFastCacheHits;
    }

    public long getMaxSize() {
        return this.cachedSizeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmapBuffersForOwner(PagedFileStorage fileStorage) {
        Map<Long, DirectBufferWrapper> buffers = this.getBuffersForOwner(fileStorage);
        this.pagesAllocationLock.lock();
        try {
            if (!buffers.isEmpty()) {
                this.pagesAccessLock.lock();
                try {
                    for (Long key : buffers.keySet()) {
                        this.pagesByPageId.remove(key);
                    }
                }
                finally {
                    this.pagesAccessLock.unlock();
                }
            }
            this.disposeRemovedSegments(fileStorage);
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    void flushBuffers() {
        this.pagesAllocationLock.lock();
        try {
            this.pagesAccessLock.lock();
            try {
                while (!this.pagesByPageId.isEmpty()) {
                    this.pagesByPageId.doRemoveEldestEntry();
                }
            }
            finally {
                this.pagesAccessLock.unlock();
            }
            this.disposeRemovedSegments(null);
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffersForOwner(PagedFileStorage storage) throws IOException {
        storage.getStorageLockContext().checkReadAccess();
        Map<Long, DirectBufferWrapper> buffers = this.getBuffersForOwner(storage);
        if (!buffers.isEmpty()) {
            SmartList<IOException> exceptions = new SmartList<IOException>();
            this.pagesAllocationLock.lock();
            try {
                try {
                    for (DirectBufferWrapper buffer : buffers.values()) {
                        if (!buffer.isDirty() || buffer.isReleased()) continue;
                        buffer.force();
                    }
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            }
            finally {
                this.pagesAllocationLock.unlock();
            }
            if (!exceptions.isEmpty()) {
                throw new IOException(new CompoundRuntimeException(exceptions));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStorage(long storageId) {
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.storageById;
        synchronized (int2ObjectMap) {
            PagedFileStorage removedStorage = (PagedFileStorage)this.storageById.remove((int)(storageId >> 32));
            if (removedStorage != null) {
                Path storageFile = removedStorage.getFile();
                Path storageAbsolutePath = storageFile.toAbsolutePath();
                this.storageByAbsolutePath.remove(storageAbsolutePath);
                if (KEEP_STACK_TRACE_AT_STORAGE_REGISTRATION) {
                    this.stackTracesOfStorageRegistration.remove(storageAbsolutePath);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertNoBuffersLocked() {
        this.pagesAllocationLock.lock();
        try {
            this.pagesAccessLock.lock();
            try {
                for (DirectBufferWrapper value : this.pagesByPageId.values()) {
                    if (value.isLocked()) {
                        throw new AssertionError();
                    }
                }
                for (DirectBufferWrapper value : this.pagesToRemoveByPageId.values()) {
                    if (value.isLocked()) {
                        throw new AssertionError();
                    }
                }
            }
            finally {
                this.pagesAccessLock.unlock();
            }
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    void assertUnderSegmentAllocationLock() {
        assert (this.pagesAllocationLock.isHeldByCurrentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long registerPagedFileStorage(@NotNull PagedFileStorage storage) {
        if (storage == null) {
            FilePageCache.$$$reportNull$$$0(0);
        }
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.storageById;
        synchronized (int2ObjectMap) {
            Path storageFile = storage.getFile();
            Path storageAbsolutePath = storageFile.toAbsolutePath();
            PagedFileStorage alreadyRegisteredStorage = this.storageByAbsolutePath.get(storageAbsolutePath);
            if (alreadyRegisteredStorage != null) {
                Exception stackTraceHolder;
                IllegalStateException ex = new IllegalStateException("Storage for [" + storageAbsolutePath + "] is already registered");
                if (KEEP_STACK_TRACE_AT_STORAGE_REGISTRATION && (stackTraceHolder = this.stackTracesOfStorageRegistration.get(storageAbsolutePath)) != null) {
                    ex.addSuppressed(stackTraceHolder);
                }
                if (THROW_ERROR_ON_DUPLICATE_STORAGE_REGISTRATION) {
                    throw ex;
                }
                LOG.warn(ex.getMessage(), ex);
            }
            int storageIndex = this.storageById.size();
            while (this.storageById.get(storageIndex) != null) {
                ++storageIndex;
            }
            this.storageById.put(storageIndex, storage);
            this.storageByAbsolutePath.put(storageAbsolutePath, storage);
            if (KEEP_STACK_TRACE_AT_STORAGE_REGISTRATION) {
                this.stackTracesOfStorageRegistration.put(storageAbsolutePath, new Exception("Storage[" + storageAbsolutePath + "] registration stack trace"));
            }
            this.myMaxRegisteredFiles = Math.max(this.myMaxRegisteredFiles, this.storageById.size());
            return (long)storageIndex << 32;
        }
    }

    /*
     * Loose catch block
     */
    @VisibleForTesting
    @NotNull
    public FilePageCacheStatistics getStatistics() {
        this.pagesAllocationLock.lock();
        this.pagesAccessLock.lock();
        FilePageCacheStatistics filePageCacheStatistics = new FilePageCacheStatistics(PageCacheUtils.CHANNELS_CACHE.getStatistics(), this.myUncachedFileAccess, this.myMaxRegisteredFiles, this.myMaxLoadedSize, this.totalSizeCached, this.myHits, this.myFastCacheHits, this.myPageLoadsAboveSizeThreshold, this.myRegularPageLoads, this.myMappingChangeCount, this.myPageDisposalUs, this.myPageLoadUs, this.myLoadedPages, this.cachedSizeLimit);
        this.pagesAccessLock.unlock();
        FilePageCacheStatistics filePageCacheStatistics2 = filePageCacheStatistics;
        if (filePageCacheStatistics2 == null) {
            FilePageCache.$$$reportNull$$$0(1);
        }
        return filePageCacheStatistics2;
        {
            catch (Throwable throwable) {
                this.pagesAccessLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.pagesAllocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull(value="Seems accessed storage has been closed")
    private @NotNull(value="Seems accessed storage has been closed") PagedFileStorage getRegisteredPagedFileStorageByIndex(long storageId) throws ClosedStorageException {
        int storageIndex = (int)((storageId & 0xFFFFFFFF00000000L) >> 32);
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.storageById;
        // MONITORENTER : int2ObjectMap
        PagedFileStorage storage = (PagedFileStorage)this.storageById.get(storageIndex);
        if (storage == null) {
            throw new ClosedStorageException("storage is already closed");
        }
        PagedFileStorage pagedFileStorage = storage;
        // MONITOREXIT : int2ObjectMap
        if (pagedFileStorage != null) return pagedFileStorage;
        FilePageCache.$$$reportNull$$$0(2);
        return pagedFileStorage;
    }

    private void disposeRemovedSegments(@Nullable PagedFileStorage verificationStorage) {
        this.assertUnderSegmentAllocationLock();
        if (this.pagesToRemoveByPageId.isEmpty()) {
            return;
        }
        Iterator iterator2 = this.pagesToRemoveByPageId.values().iterator();
        while (iterator2.hasNext()) {
            try {
                DirectBufferWrapper wrapper = (DirectBufferWrapper)iterator2.next();
                boolean released = wrapper.tryRelease(wrapper.getFile() == verificationStorage);
                if (!released) continue;
                iterator2.remove();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private void ensureSize(long sizeLimit) {
        assert (this.pagesAllocationLock.isHeldByCurrentThread());
        this.pagesAccessLock.lock();
        try {
            while (this.totalSizeCached > sizeLimit) {
                this.pagesByPageId.doRemoveEldestEntry();
            }
        }
        finally {
            this.pagesAccessLock.unlock();
        }
        this.disposeRemovedSegments(null);
    }

    @NotNull
    private static DirectBufferWrapper allocateAndLoadPage(long pageId, boolean read2, PagedFileStorage owner, boolean checkAccess) throws IOException {
        if (checkAccess) {
            StorageLockContext context = owner.getStorageLockContext();
            if (read2) {
                context.checkReadAccess();
            } else {
                context.checkWriteAccess();
            }
        }
        long offsetInFile = (pageId & 0xFFFFFFFFL) * (long)owner.getPageSize();
        return new DirectBufferWrapper(owner, offsetInFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Long, DirectBufferWrapper> getBuffersForOwner(@NotNull PagedFileStorage storage) {
        if (storage == null) {
            FilePageCache.$$$reportNull$$$0(3);
        }
        StorageLockContext storageLockContext = storage.getStorageLockContext();
        this.pagesAccessLock.lock();
        storageLockContext.checkReadAccess();
        TreeMap<Long, DirectBufferWrapper> mineBuffers = new TreeMap<Long, DirectBufferWrapper>();
        for (LongLinkedHashMap.Entry<DirectBufferWrapper> entry : this.pagesByPageId.entrySet()) {
            if (entry.getValue().getFile() != storage) continue;
            mineBuffers.put(entry.getKey(), entry.getValue());
        }
        TreeMap<Long, DirectBufferWrapper> treeMap = mineBuffers;
        Object object = treeMap;
        if (object == null) {
            FilePageCache.$$$reportNull$$$0(4);
        }
        return object;
        finally {
            this.pagesAccessLock.unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Seems accessed storage has been closed";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
        }
        Object[] objectArray = new Object[n2];
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[0] = "storage";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[0] = "com/intellij/util/io/FilePageCache";
                break;
            }
            case 2: {
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[1] = "com/intellij/util/io/FilePageCache";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[1] = "getStatistics";
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[1] = "getBuffersForOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerPagedFileStorage";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBuffersForOwner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

