/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.packaging.RepoPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackageManagementService {
    @Nullable
    public List<String> getAllRepositories() {
        return null;
    }

    public void fetchAllRepositories(@NotNull CatchingConsumer<? super List<String>, ? super Exception> consumer) {
        if (consumer == null) {
            PackageManagementService.$$$reportNull$$$0(0);
        }
        consumer.consume((Exception)((Object)this.getAllRepositories()));
    }

    public boolean canManageRepositories() {
        return this.getAllRepositories() != null;
    }

    public boolean canModifyRepository(String repositoryUrl) {
        return true;
    }

    public void addRepository(String repositoryUrl) {
    }

    public void removeRepository(String repositoryUrl) {
    }

    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            PackageManagementService.$$$reportNull$$$0(1);
        }
        if (version2 == null) {
            PackageManagementService.$$$reportNull$$$0(2);
        }
        return PackageVersionComparator.VERSION_COMPARATOR.compare(version1, version2);
    }

    @RequiresBackgroundThread
    public abstract List<RepoPackage> getAllPackages() throws IOException;

    @RequiresBackgroundThread
    public abstract List<RepoPackage> reloadAllPackages() throws IOException;

    public List<RepoPackage> getAllPackagesCached() {
        return Collections.emptyList();
    }

    public boolean canInstallToUser() {
        return false;
    }

    @NlsContexts.Button
    public String getInstallToUserText() {
        return "";
    }

    public boolean isInstallToUserSelected() {
        return false;
    }

    public void installToUserChanged(boolean newValue) {
    }

    @NotNull
    public List<? extends InstalledPackage> getInstalledPackagesList() throws ExecutionException {
        try {
            return new ArrayList<InstalledPackage>(this.getInstalledPackages());
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @Deprecated(since="2020.2", forRemoval=true)
    public Collection<InstalledPackage> getInstalledPackages() throws IOException {
        throw new AbstractMethodError("The method is deprecated. Please use `getInstalledPackagesList`.");
    }

    public abstract void installPackage(RepoPackage var1, @Nullable String var2, boolean var3, @Nullable String var4, Listener var5, boolean var6);

    public abstract void uninstallPackages(List<? extends InstalledPackage> var1, Listener var2);

    public abstract void fetchPackageVersions(String var1, CatchingConsumer<? super List<String>, ? super Exception> var2);

    public abstract void fetchPackageDetails(String var1, CatchingConsumer<? super @Nls String, ? super Exception> var2);

    @Nullable
    @NonNls
    public String getID() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/packaging/PackageManagementService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchAllRepositories";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareVersions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ErrorDescription {
        private final @NlsContexts.DetailedDescription @NotNull String myMessage;
        @Nullable
        private final String myCommand;
        @Nullable
        private final String myOutput;
        private final @NlsContexts.DetailedDescription @Nullable String mySolution;

        @Nullable
        public static ErrorDescription fromMessage(@NlsContexts.DetailedDescription @Nullable String message) {
            return message != null ? new ErrorDescription(message, null, null, null) : null;
        }

        public ErrorDescription(@NlsContexts.DetailedDescription @NotNull String message, @NlsSafe @Nullable String command2, @NlsSafe @Nullable String output, @NlsContexts.DetailedDescription @Nullable String solution) {
            if (message == null) {
                ErrorDescription.$$$reportNull$$$0(0);
            }
            this.myMessage = message;
            this.myCommand = command2;
            this.myOutput = output;
            this.mySolution = solution;
        }

        @NlsContexts.DetailedDescription
        @NotNull
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                ErrorDescription.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        @NlsSafe
        public String getCommand() {
            return this.myCommand;
        }

        @Nullable
        @NlsSafe
        public String getOutput() {
            return this.myOutput;
        }

        @NlsContexts.DetailedDescription
        @Nullable
        public String getSolution() {
            return this.mySolution;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/packaging/PackageManagementService$ErrorDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/packaging/PackageManagementService$ErrorDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static interface Listener {
        public void operationStarted(String var1);

        public void operationFinished(String var1, @Nullable ErrorDescription var2);
    }
}

