/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.internal.AttributeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public final class AttributesMap
extends HashMap<AttributeKey<?>, Object>
implements Attributes {
    private static final long serialVersionUID = -5072696312123632376L;
    private final long capacity;
    private final int lengthLimit;
    private int totalAddedValues = 0;

    private AttributesMap(long capacity, int lengthLimit) {
        this.capacity = capacity;
        this.lengthLimit = lengthLimit;
    }

    public static AttributesMap create(long capacity, int lengthLimit) {
        return new AttributesMap(capacity, lengthLimit);
    }

    @Override
    @Nullable
    public Object put(AttributeKey<?> key, Object value) {
        ++this.totalAddedValues;
        if ((long)this.size() >= this.capacity && !this.containsKey(key)) {
            return null;
        }
        return super.put(key, AttributeUtil.applyAttributeLengthLimit(value, this.lengthLimit));
    }

    public int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    @Override
    @Nullable
    public <T> T get(AttributeKey<T> key) {
        return (T)super.get(key);
    }

    @Override
    public Map<AttributeKey<?>, Object> asMap() {
        return Collections.unmodifiableMap(this);
    }

    @Override
    public AttributesBuilder toBuilder() {
        return Attributes.builder().putAll(this);
    }

    @Override
    public void forEach(BiConsumer<? super AttributeKey<?>, ? super Object> action2) {
        super.forEach(action2);
    }

    @Override
    public String toString() {
        return "AttributesMap{data=" + super.toString() + ", capacity=" + this.capacity + ", totalAddedValues=" + this.totalAddedValues + '}';
    }

    public Attributes immutableCopy() {
        return Attributes.builder().putAll(this).build();
    }
}

