/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.IntStreamEx;
import one.util.streamex.Internals;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import one.util.streamex.TakeDrop;

class VersionSpecific {
    VersionSpecific() {
    }

    <T, S extends AbstractStreamEx<T, S>> S callWhile(AbstractStreamEx<T, S> stream, Predicate<? super T> predicate, boolean drop2) {
        Spliterator spltr = stream.spliterator();
        return stream.supply(spltr.hasCharacteristics(16) ? new TakeDrop.TDOfRef<T>(spltr, drop2, false, predicate) : new TakeDrop.UnorderedTDOfRef<T>(spltr, drop2, false, predicate));
    }

    IntStreamEx callWhile(IntStreamEx stream, IntPredicate predicate, boolean drop2) {
        return stream.delegate(new TakeDrop.TDOfInt((Spliterator.OfInt)stream.spliterator(), drop2, false, predicate));
    }

    LongStreamEx callWhile(LongStreamEx stream, LongPredicate predicate, boolean drop2) {
        return stream.delegate(new TakeDrop.TDOfLong((Spliterator.OfLong)stream.spliterator(), drop2, false, predicate));
    }

    DoubleStreamEx callWhile(DoubleStreamEx stream, DoublePredicate predicate, boolean drop2) {
        return stream.delegate(new TakeDrop.TDOfDouble((Spliterator.OfDouble)stream.spliterator(), drop2, false, predicate));
    }

    <T, R> StreamEx<R> callMapMulti(AbstractStreamEx<T, ?> s, BiConsumer<? super T, ? super Consumer<R>> mapper) {
        return s.flatCollection(e -> {
            ArrayList result = new ArrayList();
            mapper.accept(e, result::add);
            return result;
        });
    }

    <T> IntStreamEx callMapMultiToInt(AbstractStreamEx<T, ?> s, BiConsumer<? super T, ? super IntConsumer> mapper) {
        return s.flatMapToInt(e -> {
            Internals.IntBuffer result = new Internals.IntBuffer();
            mapper.accept(e, result::add);
            return result.stream();
        });
    }

    <T> LongStreamEx callMapMultiToLong(AbstractStreamEx<T, ?> s, BiConsumer<? super T, ? super LongConsumer> mapper) {
        return s.flatMapToLong(e -> {
            Internals.LongBuffer result = new Internals.LongBuffer();
            mapper.accept(e, result::add);
            return result.stream();
        });
    }

    <T> DoubleStreamEx callMapMultiToDouble(AbstractStreamEx<T, ?> s, BiConsumer<? super T, ? super DoubleConsumer> mapper) {
        return s.flatMapToDouble(e -> {
            Internals.DoubleBuffer result = new Internals.DoubleBuffer();
            mapper.accept(e, result::add);
            return result.stream();
        });
    }

    IntStream ofChars(CharSequence seq) {
        return CharBuffer.wrap(seq).chars();
    }
}

