/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002\"\u001c\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0003\u0010\u0004\"\u0016\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"PACKAGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPACKAGE_PATTERN$annotations", "()V", "CLASS_PATTERN", "JVM_NAME_PATTERN", "getJvmName", "", "source", "getPackage", "getClassName", "lint-cli"})
public final class ClassNameKt {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+([\\S&&[^;]]*)");
    private static final Pattern CLASS_PATTERN = Pattern.compile("(\\bclass\\b|\\binterface\\b|\\benum class\\b|\\benum\\b|\\bobject\\b|\\brecord\\b)+?\\s*([^\\s:(]+)", 8);
    private static final Pattern JVM_NAME_PATTERN = Pattern.compile("@file:(kotlin.jvm.)?JvmName\\(\\\"(.+)\\\"\\)", 8);

    private static /* synthetic */ void getPACKAGE_PATTERN$annotations() {
    }

    private static final String getJvmName(String source) {
        String string;
        Matcher matcher = JVM_NAME_PATTERN.matcher(source);
        if (matcher.find()) {
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            string = null;
        }
        return string;
    }

    private static final String getPackage(String source) {
        String string;
        Matcher matcher = PACKAGE_PATTERN.matcher(source);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            string = null;
        }
        return string;
    }

    private static final String getClassName(String source) {
        Matcher matcher = CLASS_PATTERN.matcher(StringsKt.replace$default((String)source, (char)'\n', (char)' ', (boolean)false, (int)4, null));
        int start = 0;
        while (matcher.find(start)) {
            String cls = matcher.group(2);
            int groupStart = matcher.start(1);
            if (groupStart == 0 || source.charAt(groupStart - 1) != '.' && source.charAt(groupStart - 1) != ':') {
                String string;
                Intrinsics.checkNotNull((Object)cls);
                String trimmed = ((Object)StringsKt.trim((CharSequence)cls)).toString();
                int typeParameter = StringsKt.indexOf$default((CharSequence)trimmed, (char)'<', (int)0, (boolean)false, (int)6, null);
                if (typeParameter != -1) {
                    String string2 = trimmed.substring(0, typeParameter);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = trimmed;
                }
                return string;
            }
            start = matcher.end(2);
        }
        return null;
    }

    public static final /* synthetic */ String access$getPackage(String source) {
        return ClassNameKt.getPackage(source);
    }

    public static final /* synthetic */ String access$getClassName(String source) {
        return ClassNameKt.getClassName(source);
    }

    public static final /* synthetic */ String access$getJvmName(String source) {
        return ClassNameKt.getJvmName(source);
    }
}

