/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelArtifactType;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelVariant;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"isDesignatedGradleRootHolder", "", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "findFirstIncludedModulePath", "", "root", "Ljava/io/File;", "settings", "regex", "Lkotlin/text/Regex;", "lint-cli"})
public final class LintGradleUtilsKt {
    @NotNull
    private static final Regex regex = new Regex("^\\s*include\\s*\\(?\\s*(('(:[^']+)')|(\"(:[^\"]+)\"))", RegexOption.MULTILINE);

    public static final boolean isDesignatedGradleRootHolder(@NotNull Project $this$isDesignatedGradleRootHolder, @NotNull LintClient client) {
        List moduleDirs;
        String path;
        LintModelArtifact artifact;
        Intrinsics.checkNotNullParameter((Object)$this$isDesignatedGradleRootHolder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        LintModelVariant buildVariant = $this$isDesignatedGradleRootHolder.getBuildVariant();
        if (buildVariant != null && (artifact = buildVariant.getArtifact()).getType() != LintModelArtifactType.MAIN) {
            return false;
        }
        File file = client.getRootDir();
        if (file == null) {
            File file2 = $this$isDesignatedGradleRootHolder.getDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getDir(...)");
            file = Lint.findGradleRootDir((File)file2);
            if (file == null) {
                return false;
            }
        }
        File root = file;
        LintModelModule buildModule = $this$isDesignatedGradleRootHolder.getBuildModule();
        if (buildModule != null && (path = LintGradleUtilsKt.findFirstIncludedModulePath(root)) != null) {
            return Intrinsics.areEqual((Object)buildModule.getModulePath(), (Object)path);
        }
        File[] fileArray = root.listFiles();
        List list2 = moduleDirs = fileArray != null ? ArraysKt.sorted((Comparable[])fileArray) : null;
        if (moduleDirs != null) {
            for (File moduleDir : moduleDirs) {
                if (!new File(moduleDir, "build.gradle").exists() && !new File(moduleDir, "build.gradle.kts").exists() && !new File(moduleDir, "build.gradle.dcl").exists()) continue;
                return StringsKt.equals((String)$this$isDesignatedGradleRootHolder.getDir().getPath(), (String)moduleDir.getPath(), (boolean)true);
            }
        }
        return $this$isDesignatedGradleRootHolder.getType() == LintModelModuleType.APP;
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    private static final String findFirstIncludedModulePath(File root) {
        v0 = root.listFiles();
        if (v0 == null) {
            return null;
        }
        block7: for (File file : v0) {
            name = file.getName();
            if (name == null) continue;
            switch (name.hashCode()) {
                case -1668233102: {
                    if (!name.equals("settings.gradle")) {
                        continue block7;
                    }
                    ** GOTO lbl18
                }
                case -582367058: {
                    if (!name.equals("settings.gradle.kts")) {
                        continue block7;
                    }
                    ** GOTO lbl18
                }
                case -582374319: {
                    if (!name.equals("settings.gradle.dcl")) continue block7;
lbl18:
                    // 3 sources

                    if (!file.isFile()) continue block7;
                    try {
                        Intrinsics.checkNotNull((Object)file);
                        return LintGradleUtilsKt.findFirstIncludedModulePath(FilesKt.readText$default((File)file, null, (int)1, null));
                    }
                    catch (IOException var6_6) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    public static final String findFirstIncludedModulePath(@NotNull String settings) {
        Object path;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)settings, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        Object object = match.getGroups().get(3);
        if (object == null || (object = object.getValue()) == null) {
            MatchGroup matchGroup = match.getGroups().get(5);
            if (matchGroup != null) {
                object = matchGroup.getValue();
            } else {
                return null;
            }
        }
        if (StringsKt.contains$default((CharSequence)((CharSequence)(path = object)), (CharSequence)"$", (boolean)false, (int)2, null)) {
            return null;
        }
        return path;
    }
}

