/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.ManifestMerger2;
import com.android.utils.Pair;
import com.google.common.base.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\u00062\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0007JF\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/manifmerger/DomMergeUtils;", "", "<init>", "()V", "cloneAndTransform", "Lcom/android/utils/Pair;", "Lorg/w3c/dom/Document;", "", "document", "transform", "Lcom/google/common/base/Predicate;", "Lorg/w3c/dom/Node;", "shouldRemove", "cloneNode", "node", "newDocument", "unnamed"})
public final class DomMergeUtils {
    @NotNull
    public static final DomMergeUtils INSTANCE = new DomMergeUtils();

    private DomMergeUtils() {
    }

    @JvmStatic
    @NotNull
    public static final Pair<Document, Boolean> cloneAndTransform(@NotNull Document document, @NotNull Predicate<Node> transform, @NotNull Predicate<Node> shouldRemove) throws ManifestMerger2.MergeFailureException {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Intrinsics.checkNotNullParameter(shouldRemove, (String)"shouldRemove");
        try {
            Node node = document.cloneNode(false);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Document");
            Document newDocument = (Document)node;
            boolean changeFlag = false;
            for (Node child = document.getFirstChild(); child != null; child = child.getNextSibling()) {
                Pair<Node, Boolean> response = INSTANCE.cloneNode(child, newDocument, transform, shouldRemove);
                Object object = response.getSecond();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSecond(...)");
                changeFlag |= ((Boolean)object).booleanValue();
                if (response.getFirst() == null) continue;
                newDocument.appendChild((Node)response.getFirst());
            }
            pair = Pair.of((Object)newDocument, (Object)changeFlag);
            Intrinsics.checkNotNull((Object)pair);
        }
        catch (Exception e) {
            throw new ManifestMerger2.MergeFailureException(e);
        }
        return pair;
    }

    private final Pair<Node, Boolean> cloneNode(Node node, Document newDocument, Predicate<Node> transform, Predicate<Node> shouldRemove) {
        if (!shouldRemove.test((Object)node)) {
            Node clone = newDocument.importNode(node, false);
            boolean changeFlag = transform.apply((Object)clone);
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                Pair<Node, Boolean> response = this.cloneNode(child, newDocument, transform, shouldRemove);
                Object object = response.getSecond();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSecond(...)");
                changeFlag |= ((Boolean)object).booleanValue();
                if (response.getFirst() == null) continue;
                clone.appendChild((Node)response.getFirst());
            }
            Pair pair = Pair.of((Object)clone, (Object)changeFlag);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(...)");
            return pair;
        }
        Pair pair = Pair.of(null, (Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(...)");
        return pair;
    }
}

