/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.util.Comparator;
import java.util.Objects;

public class Range<C extends Comparable> {
    public static final Comparator<Range<?>> RANGE_LEX_COMPARATOR = new Comparator<Range<?>>(){

        @Override
        public int compare(Range<?> left, Range<?> right) {
            int cmp = 0;
            if (!left.hasLowerBound() && right.hasLowerBound()) {
                return -1;
            }
            if (!right.hasLowerBound() && left.hasLowerBound()) {
                return 1;
            }
            if (left.hasLowerBound() && right.hasLowerBound()) {
                cmp = ((Range)left).lowerBound.compareTo(((Range)right).lowerBound);
            }
            if (cmp != 0) {
                return cmp;
            }
            if (!left.hasUpperBound() && right.hasUpperBound()) {
                return 1;
            }
            if (!right.hasUpperBound() && left.hasUpperBound()) {
                return -1;
            }
            if (left.hasUpperBound() && right.hasUpperBound()) {
                cmp = ((Range)left).upperBound.compareTo(((Range)right).upperBound);
            }
            return cmp;
        }
    };
    private C lowerBound;
    private C upperBound;
    private boolean lowerOpen;
    private boolean upperOpen;
    private boolean allValues;

    public static <C extends Comparable> Range<C> closed(C lowerBound, C upperBound) {
        if (lowerBound == null || upperBound == null) {
            throw new NullPointerException();
        }
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException("lowerBound must be <= upperBound");
        }
        return new Range<C>(lowerBound, upperBound, false, false);
    }

    public static <C extends Comparable> Range<C> open(C lowerBound, C upperBound) {
        if (lowerBound == null || upperBound == null) {
            throw new NullPointerException();
        }
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException("lowerBound must be <= upperBound");
        }
        return new Range<C>(lowerBound, upperBound, true, true);
    }

    public static <C extends Comparable> Range<C> openClosed(C lowerBound, C upperBound) {
        if (lowerBound == null || upperBound == null) {
            throw new NullPointerException();
        }
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException("lowerBound must be <= upperBound");
        }
        return new Range<C>(lowerBound, upperBound, true, false);
    }

    public static <C extends Comparable> Range<C> closedOpen(C lowerBound, C upperBound) {
        if (lowerBound == null || upperBound == null) {
            throw new NullPointerException();
        }
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException("lowerBound must be <= upperBound");
        }
        return new Range<C>(lowerBound, upperBound, false, true);
    }

    public static <C extends Comparable> Range<C> atLeast(C lowerBound) {
        if (lowerBound == null) {
            throw new NullPointerException();
        }
        return new Range<Object>(lowerBound, null, false, false);
    }

    public static <C extends Comparable> Range<C> atMost(C upperBound) {
        if (upperBound == null) {
            throw new NullPointerException();
        }
        return new Range<Object>(null, upperBound, false, false);
    }

    public static <C extends Comparable> Range<C> allValues() {
        return new Range<C>();
    }

    private Range(C lowerBound, C upperBound, boolean lowerOpen, boolean upperOpen) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerOpen = lowerOpen;
        this.upperOpen = upperOpen;
        this.allValues = false;
    }

    private Range() {
        this.allValues = true;
        this.lowerBound = null;
        this.upperBound = null;
        this.lowerOpen = false;
        this.upperOpen = false;
    }

    public boolean isEmpty() {
        return !this.allValues && Objects.equals(this.lowerBound, this.upperBound) && (this.lowerOpen || this.upperOpen);
    }

    public C getLowerBound() {
        return this.lowerBound;
    }

    public C getUpperBound() {
        return this.upperBound;
    }

    public boolean openLowerBound() {
        return this.lowerOpen;
    }

    public boolean openUpperBound() {
        return this.upperOpen;
    }

    public boolean hasAllValues() {
        return this.allValues;
    }

    public boolean hasLowerBound() {
        return this.lowerBound != null;
    }

    public boolean hasUpperBound() {
        return this.upperBound != null;
    }

    public boolean contains(C value) {
        if (value == null) {
            return false;
        }
        if (this.allValues) {
            return true;
        }
        if (this.lowerBound != null) {
            if (this.lowerOpen && value.compareTo(this.lowerBound) == 0) {
                return false;
            }
            if (value.compareTo(this.lowerBound) < 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            if (this.upperOpen && value.compareTo(this.upperBound) == 0) {
                return false;
            }
            if (value.compareTo(this.upperBound) > 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isConnected(Range<C> other) {
        return !(this.hasLowerBound() && other.hasUpperBound() && this.lowerBound.compareTo(other.getUpperBound()) > 0 || this.hasUpperBound() && other.hasLowerBound() && other.getLowerBound().compareTo(this.upperBound) > 0);
    }

    public Range<C> intersection(Range<C> other) {
        Range<C> lowerBoundRange;
        if (!this.isConnected(other)) {
            return null;
        }
        if (!this.hasLowerBound() || !other.hasLowerBound()) {
            lowerBoundRange = this.hasLowerBound() ? this : other;
        } else if (Objects.equals(this.lowerBound, other.getLowerBound())) {
            lowerBoundRange = this.lowerOpen ? this : other;
        } else {
            Range<C> range = lowerBoundRange = this.lowerBound.compareTo(other.getLowerBound()) > 0 ? this : other;
        }
        Range<C> upperBoundRange = !this.hasUpperBound() || !other.hasUpperBound() ? (this.hasUpperBound() ? this : other) : (Objects.equals(this.upperBound, other.getUpperBound()) ? (this.upperOpen ? this : other) : (this.upperBound.compareTo(other.getUpperBound()) < 0 ? this : other));
        return new Range<C>(lowerBoundRange.getLowerBound(), upperBoundRange.getUpperBound(), lowerBoundRange.openLowerBound(), upperBoundRange.openUpperBound());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (this.allValues != other.hasAllValues()) {
            return false;
        }
        return Objects.equals(this.lowerBound, other.lowerBound) && Objects.equals(this.upperBound, other.upperBound) && this.lowerOpen == other.openLowerBound() && this.upperOpen == other.openUpperBound();
    }

    public String toString() {
        if (this.allValues) {
            return "[*]";
        }
        String sb = "";
        sb = this.lowerOpen ? sb + "(" : sb + "[";
        sb = sb + this.lowerBound;
        sb = sb + ", ";
        sb = sb + this.upperBound;
        sb = this.upperOpen ? sb + ")" : sb + "]";
        return sb;
    }
}

