/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProviderKt;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartProviderBase;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.resolve.JvmCompilerDeserializationConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase;", "Lcom/intellij/openapi/vfs/VirtualFile;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/psi/search/GlobalSearchScope;)V", "deserializationConfiguration", "Lorg/jetbrains/kotlin/resolve/JvmCompilerDeserializationConfiguration;", "getDeserializationConfiguration", "()Lorg/jetbrains/kotlin/resolve/JvmCompilerDeserializationConfiguration;", "loadedModules", "", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "getLoadedModules", "()Ljava/util/List;", "allPackageNamesCache", "", "", "allPackageNames", "getAllPackageNames", "()Ljava/util/Set;", "addRoots", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "cli-base"})
@SourceDebugExtension(value={"SMAP\nJvmPackagePartProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmPackagePartProvider.kt\norg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1460#2,5:91\n1#3:96\n*S KotlinDebug\n*F\n+ 1 JvmPackagePartProvider.kt\norg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider\n*L\n39#1:91,5\n*E\n"})
public final class JvmPackagePartProvider
extends JvmPackagePartProviderBase<VirtualFile> {
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final JvmCompilerDeserializationConfiguration deserializationConfiguration;
    @NotNull
    private final List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> loadedModules;
    @Nullable
    private Set<String> allPackageNamesCache;

    public JvmPackagePartProvider(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.scope = scope2;
        this.deserializationConfiguration = new JvmCompilerDeserializationConfiguration(languageVersionSettings);
        this.loadedModules = (List)new SmartList();
    }

    @Override
    @NotNull
    public JvmCompilerDeserializationConfiguration getDeserializationConfiguration() {
        return this.deserializationConfiguration;
    }

    @Override
    @NotNull
    protected List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> getLoadedModules() {
        return this.loadedModules;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Set<String> getAllPackageNames() {
        Set set = this.allPackageNamesCache;
        if (set == null) {
            void $this$flatMapTo$iv;
            Iterable iterable = this.getLoadedModules();
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                JvmPackagePartProviderBase.ModuleMappingInfo it = (JvmPackagePartProviderBase.ModuleMappingInfo)element$iv;
                boolean bl = false;
                Iterable list$iv = it.getMapping().getPackageFqName2Parts().keySet();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            iterable = destination$iv;
            Set it = (Set)iterable;
            boolean bl = false;
            this.allPackageNamesCache = it;
            set = (Set)iterable;
        }
        return set;
    }

    public final void addRoots(@NotNull List<JavaRoot> roots, @NotNull MessageCollector messageCollector2) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        for (JavaRoot javaRoot : roots) {
            VirtualFile[] virtualFileArray;
            VirtualFile metaInf;
            VirtualFile root = javaRoot.component1();
            JavaRoot.RootType type = javaRoot.component2();
            if (type != JavaRoot.RootType.BINARY || !this.scope.contains(root) || root.findChild("META-INF") == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)metaInf.getChildren(), (String)"getChildren(...)");
            for (VirtualFile moduleFile : virtualFileArray) {
                String string = moduleFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)"kotlin_module", (boolean)false, (int)2, null)) continue;
                Function0 function0 = () -> JvmPackagePartProvider.addRoots$lambda$2(moduleFile);
                String string2 = moduleFile.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String string3 = moduleFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                ModuleMapping moduleMapping = JvmPackagePartProviderKt.tryLoadModuleMapping((Function0<byte[]>)function0, string2, string3, this.getDeserializationConfiguration(), messageCollector2);
                if (moduleMapping == null) continue;
                ModuleMapping it = moduleMapping;
                boolean bl = false;
                List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> list = this.getLoadedModules();
                String string4 = moduleFile.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNameWithoutExtension(...)");
                list.add(new JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>(root, it, string4));
                this.allPackageNamesCache = null;
            }
        }
    }

    private static final byte[] addRoots$lambda$2(VirtualFile $moduleFile) {
        byte[] byArray = $moduleFile.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        return byArray;
    }
}

