/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.signature;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.signature.AsmTypeFactory;
import org.jetbrains.kotlin.load.kotlin.JvmDescriptorTypeWriter;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JvmSignatureWriter
extends JvmDescriptorTypeWriter<Type> {
    private final List<Type> kotlinParameterTypes = new ArrayList<Type>();
    private Type jvmReturnType;
    private JvmMethodParameterKind currentParameterKind;
    private int currentSignatureSize = 0;

    public JvmSignatureWriter() {
        super(AsmTypeFactory.INSTANCE);
    }

    @Override
    public void writeClass(@NotNull Type objectType) {
        if (objectType == null) {
            JvmSignatureWriter.$$$reportNull$$$0(0);
        }
        this.writeClassBegin(objectType);
        this.writeClassEnd();
    }

    public void writeAsmType(@NotNull Type asmType) {
        if (asmType == null) {
            JvmSignatureWriter.$$$reportNull$$$0(1);
        }
        switch (asmType.getSort()) {
            case 10: {
                this.writeClassBegin(asmType);
                this.writeClassEnd();
                return;
            }
            case 9: {
                this.writeArrayType();
                this.writeAsmType(AsmUtil.correctElementType(asmType));
                this.writeArrayEnd();
                return;
            }
        }
        this.writeJvmTypeAsIs(asmType);
    }

    public void writeClassBegin(Type asmType) {
        this.writeJvmTypeAsIs(asmType);
    }

    public void writeOuterClassBegin(Type resultingAsmType, String outerInternalName) {
        this.writeJvmTypeAsIs(resultingAsmType);
    }

    public void writeInnerClass(String name2) {
    }

    public void writeClassEnd() {
    }

    public void writeTypeArgument(@NotNull Variance projectionKind) {
        if (projectionKind == null) {
            JvmSignatureWriter.$$$reportNull$$$0(2);
        }
    }

    public void writeUnboundedWildcard() {
    }

    public void writeTypeArgumentEnd() {
    }

    public void writeFormalTypeParameter(String name2) {
    }

    public void writeClassBound() {
    }

    public void writeClassBoundEnd() {
    }

    public void writeInterfaceBound() {
    }

    public void writeInterfaceBoundEnd() {
    }

    public void writeParametersStart() {
        this.clearCurrentType();
    }

    public void writeParameterType(@NotNull JvmMethodParameterKind parameterKind) {
        if (parameterKind == null) {
            JvmSignatureWriter.$$$reportNull$$$0(3);
        }
        this.writeParameterType(parameterKind, parameterKind.isSkippedInGenericSignature());
    }

    public void writeParameterType(@NotNull JvmMethodParameterKind parameterKind, boolean isSkippedInGenericSignature) {
        if (parameterKind == null) {
            JvmSignatureWriter.$$$reportNull$$$0(4);
        }
        this.currentParameterKind = parameterKind;
    }

    public void writeParameterTypeEnd() {
        this.kotlinParameterTypes.add((Type)this.getJvmCurrentType());
        this.currentSignatureSize += ((Type)this.getJvmCurrentType()).getSize();
        this.currentParameterKind = null;
        this.clearCurrentType();
    }

    public void writeReturnType() {
    }

    public void writeReturnTypeEnd() {
        this.jvmReturnType = (Type)this.getJvmCurrentType();
        this.clearCurrentType();
    }

    public void writeSuperclass() {
    }

    public void writeSuperclassEnd() {
    }

    public void writeInterface() {
    }

    public void writeInterfaceEnd() {
    }

    @Nullable
    public String makeJavaGenericSignature() {
        return null;
    }

    @NotNull
    public JvmMethodGenericSignature makeJvmMethodSignature(@NotNull String name2) {
        if (name2 == null) {
            JvmSignatureWriter.$$$reportNull$$$0(5);
        }
        Type[] types2 = new Type[this.kotlinParameterTypes.size()];
        for (int i2 = 0; i2 < this.kotlinParameterTypes.size(); ++i2) {
            types2[i2] = this.kotlinParameterTypes.get(i2);
        }
        Method asmMethod = new Method(name2, this.jvmReturnType, types2);
        return new JvmMethodGenericSignature(asmMethod, this.kotlinParameterTypes, this.makeJavaGenericSignature());
    }

    public int getCurrentSignatureSize() {
        return this.currentSignatureSize;
    }

    public boolean skipGenericSignature() {
        return true;
    }

    public String toString() {
        return "empty";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionKind";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterKind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/signature/JvmSignatureWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeAsmType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "writeTypeArgument";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeParameterType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "makeJvmMethodSignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

