/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueClassRepresentationKt;
import org.jetbrains.kotlin.fir.declarations.ValueClassesUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \"2\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0003 !\"B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u0011*\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u0017\u001a\u00020\u0011*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u0011*\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001e\u001a\u00020\u0011*\u00020\u001fH\u0002\u0082\u0001\u0002#$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "isRelatedToParameter", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "parameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "isNotFinalReadOnly", "primaryConstructorProperty", "isInapplicableParameterType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isSubtypeOfCloneable", "isCloneableId", "Lorg/jetbrains/kotlin/name/ClassId;", "Regular", "ForExpectClass", "Companion", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Regular;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 9 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n*L\n1#1,322:1\n37#2:323\n63#2:324\n13#2:325\n81#3:326\n49#3:345\n14#3:357\n34#4:327\n1869#5:328\n1208#5,2:329\n1236#5,4:331\n1870#5:335\n1869#5:336\n1870#5:338\n1761#5,3:342\n52#6:337\n52#6:353\n12637#7,2:339\n1#8:341\n162#9:346\n119#9,4:347\n100#9:351\n88#9:352\n94#9:354\n123#9,2:355\n*S KotlinDebug\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker\n*L\n69#1:323\n69#1:324\n73#1:325\n84#1:326\n118#1:345\n167#1:357\n84#1:327\n98#1:328\n102#1:329,2\n102#1:331,4\n98#1:335\n149#1:336\n149#1:338\n312#1:342,3\n150#1:337\n166#1:353\n271#1:339,2\n166#1:346\n166#1:347,4\n166#1:351\n166#1:352\n166#1:354\n166#1:355,2\n*E\n"})
public abstract class FirValueClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> boxAndUnboxNames;
    @NotNull
    private static final Set<String> equalsAndHashCodeNames;
    @NotNull
    private static final FqName javaLangFqName;
    @NotNull
    private static final FqName cloneableFqName;

    private FirValueClassDeclarationChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
        boolean bl;
        Object innerDeclaration;
        block36: {
            block35: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (!DeclarationUtilsKt.isInlineOrValueClass(declaration.getSymbol())) {
                    return;
                }
                FirMemberDeclaration $this$isInner$iv = declaration;
                boolean $i$f$isInner = false;
                if ($this$isInner$iv.getStatus().isInner()) break block35;
                FirClassLikeDeclaration $this$isLocal$iv = declaration;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block36;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_NOT_TOP_LEVEL(), null, 8, null);
        }
        FirMemberDeclaration $this$modality$iv = declaration;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() != Modality.FINAL) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_NOT_FINAL(), null, 8, null);
        }
        if (!((Collection)declaration.getContextParameters()).isEmpty() && context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_HAVE_CONTEXT_RECEIVERS(), null, 8, null);
        }
        for (FirTypeRef supertypeEntry : declaration.getSuperTypeRefs()) {
            boolean bl2;
            if (supertypeEntry instanceof FirImplicitAnyTypeRef || supertypeEntry instanceof FirErrorTypeRef) continue;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(supertypeEntry, context2.getSession());
            if (firRegularClassSymbol != null) {
                FirClassSymbol $this$isInterface$iv = firRegularClassSymbol;
                boolean $i$f$isInterface = false;
                ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                boolean $i$f$isInterface2 = false;
                bl2 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            } else {
                bl2 = false;
            }
            if (bl2) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)supertypeEntry.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_EXTEND_CLASSES(), null, 8, null);
        }
        if (this.isSubtypeOfCloneable(declaration, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_CLONEABLE(), null, 8, null);
        }
        FirConstructorSymbol primaryConstructor = null;
        Ref.ObjectRef primaryConstructorParametersByName = new Ref.ObjectRef();
        primaryConstructorParametersByName.element = MapsKt.emptyMap();
        HashMap primaryConstructorPropertiesByName = new HashMap();
        Set primaryConstructorParametersSymbolsSet = null;
        primaryConstructorParametersSymbolsSet = SetsKt.emptySet();
        boolean isCustomEqualsSupported = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.CustomEqualsInValueClasses);
        Iterable $this$forEach$iv = DeclarationUtilsKt.constructors(declaration, context2.getSession());
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            innerDeclaration = (FirConstructorSymbol)t;
            bl = false;
            if (((FirConstructorSymbol)innerDeclaration).isPrimary()) {
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                primaryConstructor = innerDeclaration;
                Iterable iterable = ((FirFunctionSymbol)innerDeclaration).getValueParameterSymbols();
                Ref.ObjectRef objectRef = primaryConstructorParametersByName;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                void var19_39 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl2 = false;
                    map.put(it.getName(), element$iv$iv);
                }
                objectRef.element = destination$iv$iv;
                primaryConstructorParametersSymbolsSet = CollectionsKt.toSet((Iterable)((Map)primaryConstructorParametersByName.element).values());
                continue;
            }
            if (!((FirFunctionSymbol)innerDeclaration).getHasBody() || context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClassesSecondaryConstructorWithBody)) continue;
            DiagnosticContext diagnosticContext = context2;
            KtSourceElement ktSourceElement = ((FirFunctionSymbol)innerDeclaration).getBodySource();
            Intrinsics.checkNotNull((Object)ktSourceElement);
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext, reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_VALUE_CLASS(), null, 8, null);
        }
        DeclarationUtilsKt.processAllDeclarations$default(declaration, context2.getSession(), null, arg_0 -> FirValueClassDeclarationChecker.check$lambda$2(context2, reporter, this, primaryConstructorParametersByName, primaryConstructorPropertiesByName, arg_0), 2, null);
        $this$forEach$iv = declaration.getDeclarations();
        $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            FirCallableSymbol<?> symbol;
            innerDeclaration = (FirDeclaration)t;
            bl = false;
            if (!(innerDeclaration instanceof FirField)) continue;
            Object $this$isSynthetic$iv = innerDeclaration;
            boolean $i$f$isSynthetic = false;
            if (!(((FirDeclaration)$this$isSynthetic$iv).getOrigin() instanceof FirDeclarationOrigin.Synthetic)) continue;
            FirExpression firExpression = ((FirField)innerDeclaration).getInitializer();
            FirCallableSymbol<?> firCallableSymbol = symbol = firExpression != null ? ReferenceUtilsKt.toResolvedCallableSymbol(firExpression, context2.getSession()) : null;
            if (symbol != null && CollectionsKt.contains((Iterable)primaryConstructorParametersSymbolsSet, symbol)) continue;
            FirTypeRef firTypeRef = ((FirField)innerDeclaration).getReturnTypeRef();
            Intrinsics.checkNotNull((Object)firTypeRef, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
            FirTypeRef firTypeRef2 = ((FirResolvedTypeRef)firTypeRef).getDelegatedTypeRef();
            KtSourceElement delegatedTypeRefSource = firTypeRef2 != null ? firTypeRef2.getSource() : null;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)delegatedTypeRefSource, FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), null, 8, null);
        }
        Set reservedNames = SetsKt.plus(boxAndUnboxNames, (Iterable)(isCustomEqualsSupported ? SetsKt.emptySet() : equalsAndHashCodeNames));
        FirTypeScope classScope = FirHelpersKt.unsubstitutedScope(context2, declaration);
        for (String string : reservedNames) {
            Name name2 = Name.identifier(string);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            classScope.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirValueClassDeclarationChecker.check$lambda$4(declaration, context2, reporter, string, arg_0)));
        }
        Object object = primaryConstructor;
        if (!((object != null && (object = ((FirBasedSymbol)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS(), null, 8, null);
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
            if (((Map)primaryConstructorParametersByName.element).isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)primaryConstructor.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_EMPTY_CONSTRUCTOR(), null, 8, null);
                return;
            }
        } else if (((Map)primaryConstructorParametersByName.element).size() != 1) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)primaryConstructor.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE(), null, 8, null);
            return;
        }
        for (Map.Entry entry : ((Map)primaryConstructorParametersByName.element).entrySet()) {
            FirExpression defaultValue;
            Name name3 = (Name)entry.getKey();
            FirValueParameterSymbol primaryConstructorParameter = (FirValueParameterSymbol)entry.getValue();
            FirResolvedTypeRef parameterTypeRef = primaryConstructorParameter.getResolvedReturnTypeRef();
            if (this.isNotFinalReadOnly(primaryConstructorParameter, (FirPropertySymbol)primaryConstructorPropertiesByName.get(name3))) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), null, 8, null);
                continue;
            }
            if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter)) {
                ConeKotlinType it = parameterTypeRef.getConeType();
                boolean bl3 = false;
                boolean bl4 = it instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(it);
                if (bl4) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameterTypeRef.getSource(), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.GenericInlineClassParameter), (Object)context2.getLanguageVersionSettings()), null, 16, null);
                    continue;
                }
            }
            if (this.isInapplicableParameterType(parameterTypeRef, context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameterTypeRef.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)parameterTypeRef.getConeType(), null, 16, null);
                continue;
            }
            if (FirHelpersKt.isRecursiveValueClassType(parameterTypeRef.getConeType(), context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameterTypeRef.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), null, 8, null);
                continue;
            }
            if (FirValueClassRepresentationKt.getMultiFieldValueClassRepresentation(declaration) == null || (defaultValue = primaryConstructorParameter.getResolvedDefaultValue()) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)defaultValue.getSource(), FirErrors.INSTANCE.getMULTI_FIELD_VALUE_CLASS_PRIMARY_CONSTRUCTOR_DEFAULT_PARAMETER(), null, 8, null);
        }
        if (isCustomEqualsSupported) {
            FirValueClassDeclarationChecker $this$check_u24lambda_u247 = this;
            boolean bl5 = false;
            Ref.ObjectRef equalsFromAnyOverriding = new Ref.ObjectRef();
            Ref.ObjectRef typedEquals = new Ref.ObjectRef();
            DeclarationUtilsKt.processAllDeclarations$default(declaration, context2.getSession(), null, arg_0 -> FirValueClassDeclarationChecker.check$lambda$7$lambda$6(context2, equalsFromAnyOverriding, typedEquals, arg_0), 2, null);
            Iterator<Object> iterator2 = TuplesKt.to((Object)equalsFromAnyOverriding.element, (Object)typedEquals.element);
            FirNamedFunctionSymbol firNamedFunctionSymbol = (FirNamedFunctionSymbol)iterator2.component1();
            FirNamedFunctionSymbol typedEquals2 = (FirNamedFunctionSymbol)iterator2.component2();
            if (typedEquals2 != null) {
                boolean bl6;
                FirResolvedTypeRef singleParameterReturnTypeRef;
                block34: {
                    if (!((Collection)typedEquals2.getTypeParameterSymbols()).isEmpty()) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typedEquals2.getSource(), FirErrors.INSTANCE.getTYPE_PARAMETERS_NOT_ALLOWED(), null, 8, null);
                    }
                    singleParameterReturnTypeRef = ((FirValueParameterSymbol)CollectionsKt.single(typedEquals2.getValueParameterSymbols())).getResolvedReturnTypeRef();
                    ConeTypeProjection[] $this$any$iv = singleParameterReturnTypeRef.getConeType().getTypeArguments();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int j = 0; j < n; ++j) {
                        ConeTypeProjection element$iv;
                        ConeTypeProjection it = element$iv = $this$any$iv[j];
                        boolean bl52 = false;
                        if (!(!ConeTypeProjectionKt.isStarProjection(it))) continue;
                        bl6 = true;
                        break block34;
                    }
                    bl6 = false;
                }
                if (bl6) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)singleParameterReturnTypeRef.getSource(), FirErrors.INSTANCE.getTYPE_ARGUMENT_ON_TYPED_VALUE_CLASS_EQUALS(), null, 8, null);
                }
            }
            if (firNamedFunctionSymbol != null && typedEquals2 == null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firNamedFunctionSymbol.getSource(), FirErrors.INSTANCE.getINEFFICIENT_EQUALS_OVERRIDING_IN_VALUE_CLASS(), (Object)ConeTypeUtilsKt.replaceArgumentsWithStarProjections(ScopeUtilsKt.defaultType(declaration)), null, 16, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelatedToParameter(FirPropertySymbol $this$isRelatedToParameter, FirValueParameterSymbol parameter) {
        FirValueParameterSymbol firValueParameterSymbol = parameter;
        if (!Intrinsics.areEqual((Object)$this$isRelatedToParameter.getName(), (Object)(firValueParameterSymbol != null ? firValueParameterSymbol.getName() : null))) return false;
        KtSourceElement ktSourceElement = $this$isRelatedToParameter.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) return false;
        return true;
    }

    private final boolean isNotFinalReadOnly(FirValueParameterSymbol $this$isNotFinalReadOnly, FirPropertySymbol primaryConstructorProperty) {
        if (primaryConstructorProperty == null) {
            return true;
        }
        FirBasedSymbol firBasedSymbol = $this$isNotFinalReadOnly;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OPEN_KEYWORD");
        boolean isOpen = FirKeywordUtilsKt.hasModifier(firBasedSymbol, ktModifierKeywordToken);
        return $this$isNotFinalReadOnly.isVararg() || !primaryConstructorProperty.isVal() || isOpen;
    }

    private final boolean isInapplicableParameterType(FirTypeRef $this$isInapplicableParameterType, FirSession session) {
        ConeKotlinType it = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType($this$isInapplicableParameterType), session, null, 2, null);
        boolean bl = false;
        return ConeBuiltinTypeUtilsKt.isUnit(it) || ConeBuiltinTypeUtilsKt.isNothing(it);
    }

    private final boolean isGenericArrayOfTypeParameter(ConeKotlinType $this$isGenericArrayOfTypeParameter) {
        if (ArraysKt.firstOrNull((Object[])$this$isGenericArrayOfTypeParameter.getTypeArguments()) instanceof ConeStarProjection || !ArrayUtilsKt.isPotentiallyArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.arrayElementType$default($this$isGenericArrayOfTypeParameter, false, 1, null);
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType arrayElementType = coneKotlinType;
        return arrayElementType instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(arrayElementType);
    }

    private final boolean isSubtypeOfCloneable(FirRegularClass $this$isSubtypeOfCloneable, FirSession session) {
        boolean bl;
        block4: {
            if (this.isCloneableId(FirDeclarationUtilKt.getClassId($this$isSubtypeOfCloneable))) {
                return true;
            }
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default($this$isSubtypeOfCloneable, true, true, session, false, null, 32, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType superType = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!this.isCloneableId(TypeExpansionUtilsKt.fullyExpandedType$default(superType, session, null, 2, null).getLookupTag().getClassId())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCloneableId(ClassId $this$isCloneableId) {
        return Intrinsics.areEqual((Object)$this$isCloneableId.getRelativeClassName(), (Object)cloneableFqName) && (Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) || Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)javaLangFqName));
    }

    private static final Unit check$lambda$2(CheckerContext $context, DiagnosticReporter $reporter, FirValueClassDeclarationChecker this$0, Ref.ObjectRef $primaryConstructorParametersByName, HashMap $primaryConstructorPropertiesByName, FirBasedSymbol innerDeclaration) {
        Intrinsics.checkNotNullParameter((Object)innerDeclaration, (String)"innerDeclaration");
        FirBasedSymbol firBasedSymbol = innerDeclaration;
        if (firBasedSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol $this$isInner$iv = (FirClassLikeSymbol)innerDeclaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getRawStatus().isInner()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)((FirRegularClassSymbol)innerDeclaration).getSource(), FirErrors.INSTANCE.getINNER_CLASS_INSIDE_VALUE_CLASS(), null, 8, null);
            }
        } else if (firBasedSymbol instanceof FirPropertySymbol) {
            if (this$0.isRelatedToParameter((FirPropertySymbol)innerDeclaration, (FirValueParameterSymbol)((Map)$primaryConstructorParametersByName.element).get(((FirPropertySymbol)innerDeclaration).getName()))) {
                ((Map)$primaryConstructorPropertiesByName).put(((FirPropertySymbol)innerDeclaration).getName(), innerDeclaration);
            } else if (((FirPropertySymbol)innerDeclaration).getDelegate() != null) {
                DiagnosticContext diagnosticContext = $context;
                FirExpression firExpression = ((FirPropertySymbol)innerDeclaration).getDelegate();
                Intrinsics.checkNotNull((Object)firExpression);
                KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext, $reporter, (AbstractKtSourceElement)firExpression.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_VALUE_CLASS(), null, 8, null);
            } else if (DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)innerDeclaration)) {
                KtSourceElement ktSourceElement = ((FirPropertySymbol)innerDeclaration).getSource();
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)((FirPropertySymbol)innerDeclaration).getSource(), FirErrors.INSTANCE.getPROPERTY_WITH_BACKING_FIELD_INSIDE_VALUE_CLASS(), null, 8, null);
                }
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit check$lambda$4(FirRegularClass $declaration, CheckerContext $context, DiagnosticReporter $reporter, String $reservedName, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$unwrapFakeOverrides$iv = it;
        $i$f$unwrapFakeOverrides = false;
        $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
        $i$f$unwrapFakeOverrides = false;
        current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
        while (true) {
            $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
            $i$f$originalIfFakeOverride = false;
            $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
            $i$f$getOriginalForSubstitutionOverride = false;
            if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
            $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
            $i$f$isSynthetic = false;
            if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
            // 2 sources

            {
                v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
            } else {
                v0 = v1 = null;
            }
            if (v0 == null) {
                $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                $i$f$getBaseForIntersectionOverride = false;
                v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
            }
            if (v1 == null) break;
            current$iv$iv = next$iv$iv = v1;
        }
        v2 = current$iv$iv.getSymbol();
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
        }
        functionSymbol = (FirNamedFunctionSymbol)((FirCallableSymbol)((FirNamedFunctionSymbol)v2));
        $this$isAbstract$iv = functionSymbol;
        $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) {
            return Unit.INSTANCE;
        }
        v3 = FirHelpersKt.getContainingClassSymbol(functionSymbol);
        if (v3 == null) {
            return Unit.INSTANCE;
        }
        containingClassSymbol = v3;
        if (Intrinsics.areEqual(containingClassSymbol, (Object)$declaration.getSymbol())) {
            v4 = functionSymbol.getSource();
            if ((v4 != null ? v4.getKind() : null) instanceof KtRealSourceElementKind) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)functionSymbol.getSource(), FirErrors.INSTANCE.getRESERVED_MEMBER_INSIDE_VALUE_CLASS(), (Object)$reservedName, null, 16, null);
            }
        } else if (FirHelpersKt.getClassKind(containingClassSymbol) == ClassKind.INTERFACE) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)$declaration.getSource(), FirErrors.INSTANCE.getRESERVED_MEMBER_FROM_INTERFACE_INSIDE_VALUE_CLASS(), (Object)containingClassSymbol.getName().asString(), (Object)$reservedName, null, 32, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit check$lambda$7$lambda$6(CheckerContext $context, Ref.ObjectRef $equalsFromAnyOverriding, Ref.ObjectRef $typedEquals, FirBasedSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!(it instanceof FirNamedFunctionSymbol)) {
            return Unit.INSTANCE;
        }
        if (DeclarationUtilsKt.isEquals((FirNamedFunctionSymbol)it, $context.getSession())) {
            $equalsFromAnyOverriding.element = it;
        }
        if (ValueClassesUtilsKt.isTypedEqualsInValueClass((FirNamedFunctionSymbol)it, $context.getSession())) {
            $typedEquals.element = it;
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ FirValueClassDeclarationChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    static {
        Object[] objectArray = new String[]{"box", "unbox"};
        boxAndUnboxNames = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"equals", "hashCode"};
        equalsAndHashCodeNames = SetsKt.setOf((Object[])objectArray);
        javaLangFqName = new FqName("java.lang");
        cloneableFqName = new FqName("Cloneable");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Companion;", "", "<init>", "()V", "boxAndUnboxNames", "", "", "equalsAndHashCodeNames", "javaLangFqName", "Lorg/jetbrains/kotlin/name/FqName;", "cloneableFqName", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,322:1\n36#2:323\n*S KotlinDebug\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$ForExpectClass\n*L\n51#1:323\n*E\n"})
    public static final class ForExpectClass
    extends FirValueClassDeclarationChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,322:1\n36#2:323\n*S KotlinDebug\n*F\n+ 1 FirValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueClassDeclarationChecker$Regular\n*L\n43#1:323\n*E\n"})
    public static final class Regular
    extends FirValueClassDeclarationChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration);
        }
    }
}

