/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinAccessibility;
import org.jetbrains.kotlin.fir.analysis.checkers.FirSinceKotlinHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInAnnotationCallChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.EnumValueArgumentInfo;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorInfo;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousInitializerSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCodeFragmentSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReplSnippetSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.resolve.checkers.OptInDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInInheritanceDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.checkers.OptInUsagesDiagnosticMessageProvider;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001SB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u00020\rR\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J.\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J+\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001aJ+\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001aJ7\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010!J%\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u0006\u0012\u0002\b\u00030#R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0007\u001a\u00020\bJc\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u0006\u0012\u0002\b\u00030\u00112\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010'2\u0010\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110)2\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010*J_\u0010+\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030,2\u0010\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110)2\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050'H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010.JM\u0010/\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030#2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u00112\u0010\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110)2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050'H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u00100JA\u00101\u001a\u00020\u0010*\u0004\u0018\u00010 2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050'2\u0012\b\u0002\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110)H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u00102J\"\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0002JE\u00105\u001a\u00020\u00102\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0005092\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=R\u00020\u000bR\u000206j\u0006\u0010\f\u001a\u00020\u000bj\u0006\u00107\u001a\u000206\u00a2\u0006\u0002\u0010>J=\u0010?\u001a\u00020\u00102\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0005092\n\u0010-\u001a\u0006\u0012\u0002\b\u00030,R\u00020\u000bR\u000206j\u0006\u0010\f\u001a\u00020\u000bj\u0006\u00107\u001a\u000206\u00a2\u0006\u0002\u0010@J\u0014\u0010A\u001a\u0004\u0018\u00010=*\u00020B2\u0006\u0010C\u001a\u00020DJ)\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020G2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010HJ(\u0010I\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010F\u001a\u00020G2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010J\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u0011H\u0002J \u0010K\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010F\u001a\u00020GH\u0002J \u0010L\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010F\u001a\u00020G2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010L\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020M0\u00182\u0006\u0010F\u001a\u00020G2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010N\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010F\u001a\u00020GH\u0002J\u0014\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010=0\u0018*\u00020BH\u0002R\u000e\u0010P\u001a\u00020QX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020QX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker;", "", "<init>", "()V", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "loadExperimentalitiesFromConstructor", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;)Ljava/util/Set;", "loadExperimentalitiesFromAnnotationTo", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "result", "", "fromSupertype", "", "loadExperimentalitiesFromTypeArguments", "typeArguments", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/List;)Ljava/util/Set;", "loadExperimentalitiesFromConeArguments", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "loadExperimentalities", "fromSetter", "dispatchReceiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;ZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Ljava/util/Set;", "loadExperimentalitiesFromSupertype", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Ljava/util/Set;", "isExperimentalMarker", "knownExperimentalities", "Lorg/jetbrains/kotlin/utils/SmartSet;", "visited", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/utils/SmartSet;Ljava/util/Set;ZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;Z)Ljava/util/Set;", "loadCallableSpecificExperimentalities", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "symbol", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Ljava/util/Set;ZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/utils/SmartSet;)V", "loadClassLikeSpecificExperimentalities", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Ljava/util/Set;Lorg/jetbrains/kotlin/utils/SmartSet;)V", "addExperimentalities", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/utils/SmartSet;Ljava/util/Set;)V", "annotatedOwnerClassName", "", "reportNotAcceptedExperimentalities", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "experimentalities", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/Collection;Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/KtSourceElement;)V", "reportNotAcceptedOverrideExperimentalities", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/Collection;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "getSourceForIsMarkerDiagnostic", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "argumentIndex", "", "isExperimentalityAcceptableInContext", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/name/ClassId;Z)Z", "isExperimentalityAcceptable", "isImplicitDeclaration", "primaryConstructorParameterIsExperimentalityAcceptable", "isAnnotatedWithOptIn", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "isAnnotatedWithSubclassOptInRequired", "getMarkerArgumentsSources", "LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "MESSAGE", "Experimentality", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageBaseChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageBaseChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,490:1\n1869#2,2:491\n1563#2:493\n1634#2,3:494\n1869#2,2:497\n1869#2,2:499\n1869#2,2:502\n295#2,2:505\n295#2,2:509\n1761#2,3:512\n1761#2,3:515\n1563#2:518\n1634#2,3:519\n24#3:501\n66#3:504\n13472#4,2:507\n1#5:511\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageBaseChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker\n*L\n132#1:491,2\n147#1:493\n147#1:494,3\n156#1:497,2\n208#1:499,2\n240#1:502,2\n250#1:505,2\n307#1:509,2\n454#1:512,3\n471#1:515,3\n481#1:518\n481#1:519,3\n236#1:501\n245#1:504\n290#1:507,2\n*E\n"})
public final class FirOptInUsageBaseChecker {
    @NotNull
    public static final FirOptInUsageBaseChecker INSTANCE = new FirOptInUsageBaseChecker();
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;

    private FirOptInUsageBaseChecker() {
    }

    @Nullable
    public final Experimentality loadExperimentalityForMarkerAnnotation(@NotNull FirRegularClassSymbol $this$loadExperimentalityForMarkerAnnotation, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$loadExperimentalityForMarkerAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return this.loadExperimentalityForMarkerAnnotation($this$loadExperimentalityForMarkerAnnotation, session, null);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromConstructor(@NotNull CheckerContext context2, @NotNull FirConstructorSymbol $this$loadExperimentalitiesFromConstructor) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)$this$loadExperimentalitiesFromConstructor, (String)"<this>");
        Set result2 = new LinkedHashSet();
        this.loadExperimentalitiesFromAnnotationTo($this$loadExperimentalitiesFromConstructor, context2.getSession(), result2);
        return result2;
    }

    public final void loadExperimentalitiesFromAnnotationTo(@NotNull FirBasedSymbol<?> $this$loadExperimentalitiesFromAnnotationTo, @NotNull FirSession session, @NotNull Collection<Experimentality> result2) {
        Intrinsics.checkNotNullParameter($this$loadExperimentalitiesFromAnnotationTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        this.loadExperimentalitiesFromAnnotationTo($this$loadExperimentalitiesFromAnnotationTo, session, result2, false);
    }

    private final void loadExperimentalitiesFromAnnotationTo(FirBasedSymbol<?> $this$loadExperimentalitiesFromAnnotationTo, FirSession session, Collection<Experimentality> result2, boolean fromSupertype) {
        for (FirAnnotation annotation : $this$loadExperimentalitiesFromAnnotationTo.getResolvedAnnotationsWithArguments()) {
            FirExpression annotationClass;
            Object object;
            ConeClassLikeType annotationType;
            FirBasedSymbol<?> firBasedSymbol = FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef());
            if ((firBasedSymbol instanceof ConeClassLikeType ? (ConeClassLikeType)((Object)firBasedSymbol) : null) == null) continue;
            annotationType = annotationType;
            firBasedSymbol = $this$loadExperimentalitiesFromAnnotationTo;
            String className = firBasedSymbol instanceof FirRegularClassSymbol ? ((FirRegularClassSymbol)$this$loadExperimentalitiesFromAnnotationTo).getName().asString() : (firBasedSymbol instanceof FirCallableSymbol ? ((object = ((FirCallableSymbol)$this$loadExperimentalitiesFromAnnotationTo).getCallableId().getClassName()) != null && (object = ((FqName)object).shortName()) != null ? ((Name)object).asString() : null) : null);
            firBasedSymbol = ToSymbolUtilsKt.toRegularClassSymbol(annotationType.getLookupTag(), session);
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, firBasedSymbol != null ? this.loadExperimentalityForMarkerAnnotation((FirRegularClassSymbol)firBasedSymbol, session, className) : null);
            if (!fromSupertype || !Intrinsics.areEqual((Object)annotationType.getLookupTag().getClassId(), (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName$default(annotation, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null) == null) continue;
            List<FirRegularClassSymbol> classes = FirAnnotationHelpersKt.extractClassesFromArgument(annotationClass, session);
            Iterable $this$forEach$iv = classes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirRegularClassSymbol klass = (FirRegularClassSymbol)element$iv;
                boolean bl = false;
                Experimentality experimentality = INSTANCE.loadExperimentalityForMarkerAnnotation(klass, session);
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, experimentality != null ? Experimentality.copy$default(experimentality, null, null, null, null, true, 15, null) : null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromTypeArguments(@NotNull CheckerContext context2, @NotNull List<? extends FirTypeProjection> typeArguments) {
        Collection<ConeTypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(typeArguments, (String)"typeArguments");
        if (typeArguments.isEmpty()) {
            return SetsKt.emptySet();
        }
        Iterable iterable = typeArguments;
        CheckerContext checkerContext = context2;
        FirOptInUsageBaseChecker firOptInUsageBaseChecker = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeProjection firTypeProjection = (FirTypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)it));
        }
        collection = (List)destination$iv$iv;
        return firOptInUsageBaseChecker.loadExperimentalitiesFromConeArguments(checkerContext, (List<? extends ConeTypeProjection>)collection);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromConeArguments(@NotNull CheckerContext context2, @NotNull List<? extends ConeTypeProjection> typeArguments) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(typeArguments, (String)"typeArguments");
        if (typeArguments.isEmpty()) {
            return SetsKt.emptySet();
        }
        SmartSet result2 = SmartSet.Companion.create();
        Iterable $this$forEach$iv = typeArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeKotlinType coneKotlinType;
            ConeTypeProjection it = (ConeTypeProjection)element$iv;
            boolean bl = false;
            if (ConeTypeProjectionKt.isStarProjection(it) || (coneKotlinType = ConeTypeProjectionKt.getType(it)) == null) continue;
            FirOptInUsageBaseChecker.addExperimentalities$default(INSTANCE, context2, coneKotlinType, result2, null, 4, null);
        }
        return (Set)((Object)result2);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalities(@NotNull CheckerContext context2, @NotNull FirBasedSymbol<?> $this$loadExperimentalities, boolean fromSetter, @Nullable ConeKotlinType dispatchReceiverType) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$loadExperimentalities, (String)"<this>");
        return this.loadExperimentalities(context2, $this$loadExperimentalities, null, new LinkedHashSet(), fromSetter, dispatchReceiverType, false);
    }

    @NotNull
    public final Set<Experimentality> loadExperimentalitiesFromSupertype(@NotNull CheckerContext context2, @NotNull FirClassLikeSymbol<?> $this$loadExperimentalitiesFromSupertype) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter($this$loadExperimentalitiesFromSupertype, (String)"<this>");
        return this.loadExperimentalities(context2, (FirBasedSymbol)$this$loadExperimentalitiesFromSupertype, null, new LinkedHashSet(), false, null, true);
    }

    public final boolean isExperimentalMarker(@NotNull FirClassLikeSymbol<?> $this$isExperimentalMarker, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isExperimentalMarker, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return $this$isExperimentalMarker instanceof FirRegularClassSymbol && FirAnnotationUtilsKt.hasAnnotationWithClassId((FirBasedSymbol)$this$isExperimentalMarker, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session);
    }

    private final Set<Experimentality> loadExperimentalities(CheckerContext context2, FirBasedSymbol<?> $this$loadExperimentalities, SmartSet<Experimentality> knownExperimentalities, Set<FirBasedSymbol<?>> visited2, boolean fromSetter, ConeKotlinType dispatchReceiverType, boolean fromSupertype) {
        FirSinceKotlinAccessibility accessibility;
        if (!visited2.add($this$loadExperimentalities)) {
            return SetsKt.emptySet();
        }
        SmartSet<Experimentality> smartSet = knownExperimentalities;
        if (smartSet == null) {
            smartSet = SmartSet.Companion.create();
        }
        SmartSet<Experimentality> result2 = smartSet;
        FirSession session = context2.getSession();
        FirBasedSymbol<?> firBasedSymbol = $this$loadExperimentalities;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            this.loadCallableSpecificExperimentalities(context2, (FirCallableSymbol)$this$loadExperimentalities, (FirCallableSymbol)$this$loadExperimentalities, visited2, fromSetter, dispatchReceiverType, result2);
        } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
            this.loadClassLikeSpecificExperimentalities(context2, (FirClassLikeSymbol)$this$loadExperimentalities, $this$loadExperimentalities, visited2, result2);
        } else if (firBasedSymbol instanceof FirAnonymousInitializerSymbol || firBasedSymbol instanceof FirFileSymbol || firBasedSymbol instanceof FirTypeParameterSymbol || firBasedSymbol instanceof FirScriptSymbol || firBasedSymbol instanceof FirReplSnippetSymbol || firBasedSymbol instanceof FirCodeFragmentSymbol || firBasedSymbol instanceof FirReceiverParameterSymbol) {
            // empty if block
        }
        this.loadExperimentalitiesFromAnnotationTo($this$loadExperimentalities, session, (Collection)((Object)result2), fromSupertype);
        if (FirAnnotationUtilsKt.hasAnnotationWithClassId($this$loadExperimentalities, OptInNames.INSTANCE.getWAS_EXPERIMENTAL_CLASS_ID(), session) && (accessibility = FirSinceKotlinHelpersKt.checkSinceKotlinVersionAccessibility(context2, $this$loadExperimentalities)) instanceof FirSinceKotlinAccessibility.NotAccessibleButWasExperimental) {
            Iterable $this$forEach$iv = ((FirSinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                boolean bl = false;
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)((Object)result2), INSTANCE.loadExperimentalityForMarkerAnnotation(it, session));
            }
        }
        return (Set)((Object)result2);
    }

    private final void loadCallableSpecificExperimentalities(CheckerContext context2, FirCallableSymbol<?> $this$loadCallableSpecificExperimentalities, FirCallableSymbol<?> symbol, Set<FirBasedSymbol<?>> visited2, boolean fromSetter, ConeKotlinType dispatchReceiverType, SmartSet<Experimentality> result2) {
        FirPropertyAccessorSymbol firPropertyAccessorSymbol;
        FirRegularClassSymbol parentClassSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag($this$loadCallableSpecificExperimentalities);
        FirRegularClassSymbol firRegularClassSymbol = parentClassSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null;
        if ($this$loadCallableSpecificExperimentalities instanceof FirConstructorSymbol) {
            FirClassLikeSymbol ownerClassLikeSymbol;
            TypeAliasConstructorInfo<?> typeAliasConstructorInfo = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasConstructorInfo((FirConstructorSymbol)$this$loadCallableSpecificExperimentalities);
            FirClassLikeSymbol firClassLikeSymbol = typeAliasConstructorInfo != null && (typeAliasConstructorInfo = typeAliasConstructorInfo.getTypeAliasSymbol()) != null ? (FirClassLikeSymbol)((Object)typeAliasConstructorInfo) : (ownerClassLikeSymbol = (FirClassLikeSymbol)parentClassSymbol);
            if (ownerClassLikeSymbol != null) {
                this.loadExperimentalities(context2, ownerClassLikeSymbol, result2, visited2, false, null, false);
            }
        } else {
            this.addExperimentalities(context2, AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf($this$loadCallableSpecificExperimentalities.getResolvedReturnType()), result2, visited2);
            Object object = $this$loadCallableSpecificExperimentalities.getReceiverParameterSymbol();
            this.addExperimentalities(context2, object != null && (object = ((FirReceiverParameterSymbol)object).getResolvedType()) != null ? AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf((ConeKotlinType)object) : null, result2, visited2);
        }
        FirCallableSymbol<?> $this$isStatic$iv = symbol;
        boolean $i$f$isStatic = false;
        if (!$this$isStatic$iv.getRawStatus().isStatic() && dispatchReceiverType != null) {
            this.addExperimentalities(context2, dispatchReceiverType, result2, visited2);
        }
        if ($this$loadCallableSpecificExperimentalities instanceof FirFunctionSymbol) {
            boolean bl;
            Iterable $this$forEach$iv = ((FirFunctionSymbol)$this$loadCallableSpecificExperimentalities).getValueParameterSymbols();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                boolean bl2 = false;
                INSTANCE.addExperimentalities(context2, AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(it.getResolvedReturnType()), result2, visited2);
            }
            FirRegularClassSymbol firRegularClassSymbol2 = parentClassSymbol;
            if (firRegularClassSymbol2 != null) {
                FirClassLikeSymbol $this$isData$iv = firRegularClassSymbol2;
                boolean $i$f$isData = false;
                bl = $this$isData$iv.getRawStatus().isData();
            } else {
                bl = false;
            }
            if (bl && DataClassResolver.INSTANCE.isComponentLike(((FirFunctionSymbol)$this$loadCallableSpecificExperimentalities).getCallableId().getCallableName()) && parentClassSymbol.getClassKind() == ClassKind.CLASS) {
                Object v11;
                block12: {
                    List<FirValueParameterSymbol> valueParameters;
                    String string = ((FirFunctionSymbol)$this$loadCallableSpecificExperimentalities).getCallableId().getCallableName().getIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
                    int componentNIndex = DataClassResolver.INSTANCE.getComponentIndex(string);
                    FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(parentClassSymbol, context2.getSession());
                    List<FirValueParameterSymbol> list = valueParameters = firConstructorSymbol != null ? firConstructorSymbol.getValueParameterSymbols() : null;
                    FirValueParameterSymbol valueParameter2 = list != null ? (FirValueParameterSymbol)CollectionsKt.getOrNull(list, (int)(componentNIndex - 1)) : null;
                    List properties2 = DeclarationUtilsKt.declaredProperties$default(parentClassSymbol, context2.getSession(), null, 2, null);
                    Iterable $this$firstOrNull$iv = properties2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirPropertySymbol it = (FirPropertySymbol)element$iv;
                        boolean bl3 = false;
                        FirValueParameterSymbol firValueParameterSymbol = valueParameter2;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)(firValueParameterSymbol != null ? firValueParameterSymbol.getName() : null))) continue;
                        v11 = element$iv;
                        break block12;
                    }
                    v11 = null;
                }
                FirPropertySymbol property2 = v11;
                if (property2 != null) {
                    this.loadExperimentalities(context2, property2, result2, visited2, false, dispatchReceiverType, false);
                }
            }
        }
        if (fromSetter && symbol instanceof FirPropertySymbol && (firPropertyAccessorSymbol = ((FirPropertySymbol)symbol).getSetterSymbol()) != null) {
            this.loadExperimentalities(context2, firPropertyAccessorSymbol, result2, visited2, false, dispatchReceiverType, false);
        }
    }

    private final void loadClassLikeSpecificExperimentalities(CheckerContext context2, FirClassLikeSymbol<?> $this$loadClassLikeSpecificExperimentalities, FirBasedSymbol<?> symbol, Set<FirBasedSymbol<?>> visited2, SmartSet<Experimentality> result2) {
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$loadClassLikeSpecificExperimentalities;
        if (firClassLikeSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol<?> parentClassSymbol;
            if (symbol instanceof FirRegularClassSymbol && (parentClassSymbol = FirHelpersKt.outerClassSymbol(context2, (FirClassLikeSymbol)symbol)) != null) {
                this.loadExperimentalities(context2, (FirBasedSymbol)parentClassSymbol, result2, visited2, false, null, false);
            }
        } else if (!(firClassLikeSymbol instanceof FirAnonymousObjectSymbol) && !(firClassLikeSymbol instanceof FirTypeAliasSymbol)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void addExperimentalities(CheckerContext context2, ConeKotlinType $this$addExperimentalities, SmartSet<Experimentality> result2, Set<FirBasedSymbol<?>> visited2) {
        if (!($this$addExperimentalities instanceof ConeClassLikeType)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(((ConeClassLikeType)$this$addExperimentalities).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol != null) {
            this.loadExperimentalities(context2, (FirBasedSymbol)firClassLikeSymbol, result2, visited2, false, null, false);
        }
        ConeTypeProjection[] $this$forEach$iv = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, (ConeClassLikeType)$this$addExperimentalities).getTypeArguments();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            ConeKotlinType coneKotlinType;
            ConeTypeProjection element$iv;
            ConeTypeProjection it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (ConeTypeProjectionKt.isStarProjection(it) || (coneKotlinType = ConeTypeProjectionKt.getType(it)) == null) continue;
            INSTANCE.addExperimentalities(context2, coneKotlinType, result2, visited2);
        }
    }

    static /* synthetic */ void addExperimentalities$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, CheckerContext checkerContext, ConeKotlinType coneKotlinType, SmartSet smartSet, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        firOptInUsageBaseChecker.addExperimentalities(checkerContext, coneKotlinType, smartSet, set);
    }

    private final Experimentality loadExperimentalityForMarkerAnnotation(FirRegularClassSymbol $this$loadExperimentalityForMarkerAnnotation, FirSession session, String annotatedOwnerClassName) {
        Experimentality.Severity severity;
        Object v2;
        FirAnnotation experimental;
        block3: {
            FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationWithResolvedArgumentsByClassId($this$loadExperimentalityForMarkerAnnotation, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), session);
            if (firAnnotation == null) {
                return null;
            }
            experimental = firAnnotation;
            FirExpression levelArgument = FirAnnotationUtilsKt.findArgumentByName$default(experimental, LEVEL, false, 2, null);
            Object object = levelArgument;
            String levelName = object != null && (object = FirAnnotationUtilsKt.extractEnumValueArgumentInfo((FirExpression)object)) != null && (object = ((EnumValueArgumentInfo)object).getEnumEntryName()) != null ? ((Name)object).asString() : null;
            Iterable $this$firstOrNull$iv = (Iterable)Experimentality.Severity.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Experimentality.Severity it = (Experimentality.Severity)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)levelName)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((severity = (Experimentality.Severity)v2) == null) {
            severity = Experimentality.Companion.getDEFAULT_SEVERITY();
        }
        Experimentality.Severity severity2 = severity;
        String message2 = FirAnnotationUtilsKt.getStringArgument(experimental, MESSAGE, session);
        return new Experimentality($this$loadExperimentalityForMarkerAnnotation.getClassId(), severity2, message2, annotatedOwnerClassName, false, 16, null);
    }

    static /* synthetic */ Experimentality loadExperimentalityForMarkerAnnotation$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, FirRegularClassSymbol firRegularClassSymbol, FirSession firSession, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return firOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation(firRegularClassSymbol, firSession, string);
    }

    public final void reportNotAcceptedExperimentalities(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull Collection<Experimentality> experimentalities, @NotNull FirElement element, @Nullable KtSourceElement source) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(experimentalities, (String)"experimentalities");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object22 = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        Object object2 = object = object22 instanceof FirClassSymbol ? (FirClassSymbol)object22 : null;
        if (object != null) {
            FirClassSymbol it = object;
            boolean bl2 = false;
            bl = (Boolean)FirOptInAnnotationCallChecker.INSTANCE.getSubclassOptInApplicabilityAndMessage(it).getFirst();
        } else {
            bl = false;
        }
        boolean isSubclassOptInApplicable = bl;
        for (Experimentality experimentality : experimentalities) {
            Triple triple;
            ClassId annotationClassId = experimentality.component1();
            Experimentality.Severity severity = experimentality.component2();
            String message2 = experimentality.component3();
            boolean fromSupertype = experimentality.component5();
            if (this.isExperimentalityAcceptableInContext(context2, annotationClassId, fromSupertype)) continue;
            if (fromSupertype && severity == Experimentality.Severity.WARNING) {
                triple = new Triple(FirErrors.INSTANCE.getOPT_IN_TO_INHERITANCE(), (Object)new OptInInheritanceDiagnosticMessageProvider(isSubclassOptInApplicable), (Object)"should");
            } else if (severity == Experimentality.Severity.WARNING) {
                triple = new Triple(FirErrors.INSTANCE.getOPT_IN_USAGE(), (Object)OptInUsagesDiagnosticMessageProvider.INSTANCE, (Object)"should");
            } else if (fromSupertype && severity == Experimentality.Severity.ERROR) {
                triple = new Triple(FirErrors.INSTANCE.getOPT_IN_TO_INHERITANCE_ERROR(), (Object)new OptInInheritanceDiagnosticMessageProvider(isSubclassOptInApplicable), (Object)"must");
            } else if (severity == Experimentality.Severity.ERROR) {
                triple = new Triple(FirErrors.INSTANCE.getOPT_IN_USAGE_ERROR(), (Object)OptInUsagesDiagnosticMessageProvider.INSTANCE, (Object)"must");
            } else {
                throw new IllegalStateException(("Unexpected " + (Object)((Object)severity) + " type").toString());
            }
            Triple triple2 = triple;
            KtDiagnosticFactory2 diagnostic = (KtDiagnosticFactory2)triple2.component1();
            OptInDiagnosticMessageProvider messageProvider = (OptInDiagnosticMessageProvider)triple2.component2();
            String verb = (String)triple2.component3();
            CharSequence charSequence = message2;
            String reportedMessage = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? messageProvider.buildCustomDiagnosticMessage(message2) : messageProvider.buildDefaultDiagnosticMessage(annotationClassId.asFqNameString(), verb);
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, diagnostic, (Object)annotationClassId, (Object)reportedMessage, null, 32, null);
        }
    }

    public static /* synthetic */ void reportNotAcceptedExperimentalities$default(FirOptInUsageBaseChecker firOptInUsageBaseChecker, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, Collection collection, FirElement firElement, KtSourceElement ktSourceElement, int n, Object object) {
        if ((n & 0x10) != 0) {
            ktSourceElement = firElement.getSource();
        }
        firOptInUsageBaseChecker.reportNotAcceptedExperimentalities(checkerContext, diagnosticReporter, collection, firElement, ktSourceElement);
    }

    public final void reportNotAcceptedOverrideExperimentalities(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull Collection<Experimentality> experimentalities, @NotNull FirCallableSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(experimentalities, (String)"experimentalities");
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        for (Experimentality experimentality : experimentalities) {
            Pair pair;
            ClassId annotationClassId = experimentality.component1();
            Experimentality.Severity severity = experimentality.component2();
            String markerMessage = experimentality.component3();
            String supertypeName = experimentality.component4();
            if (this.isExperimentalityAcceptable((FirBasedSymbol)symbol, context2.getSession(), annotationClassId, false) || this.isExperimentalityAcceptableInContext(context2, annotationClassId, false)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_OVERRIDE(), (Object)"should");
                    break;
                }
                case 2: {
                    pair = TuplesKt.to(FirErrors.INSTANCE.getOPT_IN_OVERRIDE_ERROR(), (Object)"must");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair2 = pair;
            KtDiagnosticFactory2 diagnostic = (KtDiagnosticFactory2)pair2.component1();
            String verb = (String)pair2.component2();
            String string = supertypeName;
            if (string == null) {
                string = "???";
            }
            String message2 = OptInNames.INSTANCE.buildOverrideMessage(string, markerMessage, verb, annotationClassId.asFqNameString());
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)symbol.getSource(), diagnostic, (Object)annotationClassId, (Object)message2, null, 32, null);
        }
    }

    @Nullable
    public final KtSourceElement getSourceForIsMarkerDiagnostic(@NotNull FirAnnotationCall $this$getSourceForIsMarkerDiagnostic, int argumentIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getSourceForIsMarkerDiagnostic, (String)"<this>");
        List<KtSourceElement> markerArgumentsSources = this.getMarkerArgumentsSources($this$getSourceForIsMarkerDiagnostic);
        return markerArgumentsSources.get(argumentIndex);
    }

    private final boolean isExperimentalityAcceptableInContext(CheckerContext context2, ClassId annotationClassId, boolean fromSupertype) {
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        String fqNameAsString = annotationClassId.asFqNameString();
        if (languageVersionSettings.getFlag(AnalysisFlags.getOptIn()).contains(fqNameAsString)) {
            return true;
        }
        for (FirAnnotationContainer annotationContainer : context2.getAnnotationContainers()) {
            if (annotationContainer instanceof FirDeclaration && this.isExperimentalityAcceptable(((FirDeclaration)annotationContainer).getSymbol(), context2.getSession(), annotationClassId, fromSupertype)) {
                return true;
            }
            if (!(annotationContainer instanceof FirStatement)) continue;
            FirStatement $this$isExperimentalityAcceptableInContext_u24lambda_u249 = (FirStatement)annotationContainer;
            boolean bl = false;
            if (FirAnnotationUtilsKt.getAnnotationByClassId($this$isExperimentalityAcceptableInContext_u24lambda_u249, annotationClassId, context2.getSession()) == null && !INSTANCE.isAnnotatedWithOptIn($this$isExperimentalityAcceptableInContext_u24lambda_u249.getAnnotations(), annotationClassId, context2.getSession())) continue;
            return true;
        }
        return false;
    }

    private final boolean isExperimentalityAcceptable(FirBasedSymbol<?> $this$isExperimentalityAcceptable, FirSession session, ClassId annotationClassId, boolean fromSupertype) {
        return FirAnnotationUtilsKt.hasAnnotationWithClassId($this$isExperimentalityAcceptable, annotationClassId, session) || this.isAnnotatedWithOptIn($this$isExperimentalityAcceptable, annotationClassId, session) || fromSupertype && this.isAnnotatedWithSubclassOptInRequired($this$isExperimentalityAcceptable, session, annotationClassId) || this.primaryConstructorParameterIsExperimentalityAcceptable($this$isExperimentalityAcceptable, session, annotationClassId) || this.isImplicitDeclaration($this$isExperimentalityAcceptable);
    }

    private final boolean isImplicitDeclaration(FirBasedSymbol<?> $this$isImplicitDeclaration) {
        return !Intrinsics.areEqual((Object)$this$isImplicitDeclaration.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE);
    }

    private final boolean primaryConstructorParameterIsExperimentalityAcceptable(FirBasedSymbol<?> $this$primaryConstructorParameterIsExperimentalityAcceptable, FirSession session, ClassId annotationClassId) {
        if (!($this$primaryConstructorParameterIsExperimentalityAcceptable instanceof FirPropertySymbol)) {
            return false;
        }
        FirValueParameterSymbol firValueParameterSymbol = DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor((FirPropertySymbol)$this$primaryConstructorParameterIsExperimentalityAcceptable);
        if (firValueParameterSymbol == null) {
            return false;
        }
        FirValueParameterSymbol parameterSymbol = firValueParameterSymbol;
        return this.isExperimentalityAcceptable(parameterSymbol, session, annotationClassId, false);
    }

    private final boolean isAnnotatedWithOptIn(FirBasedSymbol<?> $this$isAnnotatedWithOptIn, ClassId annotationClassId, FirSession session) {
        return this.isAnnotatedWithOptIn($this$isAnnotatedWithOptIn.getResolvedAnnotationsWithArguments(), annotationClassId, session);
    }

    private final boolean isAnnotatedWithOptIn(List<? extends FirAnnotation> $this$isAnnotatedWithOptIn, ClassId annotationClassId, FirSession session) {
        for (FirAnnotation firAnnotation : $this$isAnnotatedWithOptIn) {
            boolean bl;
            block4: {
                FirExpression annotationClasses;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(firAnnotation.getAnnotationTypeRef());
                ConeClassLikeType coneType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                Object object = coneType;
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null), (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName$default(firAnnotation, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null) == null) continue;
                Iterable $this$any$iv = FirAnnotationHelpersKt.extractClassesFromArgument(annotationClasses, session);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getClassId(), (Object)annotationClassId)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private final boolean isAnnotatedWithSubclassOptInRequired(FirBasedSymbol<?> $this$isAnnotatedWithSubclassOptInRequired, FirSession session, ClassId annotationClassId) {
        for (FirAnnotation annotation : $this$isAnnotatedWithSubclassOptInRequired.getResolvedAnnotationsWithArguments()) {
            boolean bl;
            block4: {
                FirExpression annotationClass;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef());
                ConeClassLikeType coneType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
                Object object = coneType;
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null), (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID()) || FirAnnotationUtilsKt.findArgumentByName$default(annotation, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null) == null) continue;
                Iterable $this$any$iv = FirAnnotationHelpersKt.extractClassesFromArgument(annotationClass, session);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getClassId(), (Object)annotationClassId)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtSourceElement> getMarkerArgumentsSources(FirAnnotationCall $this$getMarkerArgumentsSources) {
        List list;
        FirExpression annotationClasses = FirAnnotationUtilsKt.findArgumentByName$default($this$getMarkerArgumentsSources, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null);
        if (annotationClasses instanceof FirVarargArgumentsExpression) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((FirVarargArgumentsExpression)annotationClasses).getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSource());
            }
            list = (List)destination$iv$iv;
        } else {
            FirExpression firExpression = annotationClasses;
            list = CollectionsKt.listOfNotNull((Object)(firExpression != null ? firExpression.getSource() : null));
        }
        List markerArgumentsSources = list;
        return markerArgumentsSources;
    }

    static {
        Name name2 = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        LEVEL = name2;
        Name name3 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        MESSAGE = name3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0002!\"B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003J?\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "severity", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "message", "", "supertypeName", "fromSupertype", "", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;Ljava/lang/String;Ljava/lang/String;Z)V", "getAnnotationClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getSeverity", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "getMessage", "()Ljava/lang/String;", "getSupertypeName", "getFromSupertype", "()Z", "equals", "other", "hashCode", "", "component1", "component2", "component3", "component4", "component5", "copy", "toString", "Severity", "Companion", "checkers"})
    public static final class Experimentality {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ClassId annotationClassId;
        @NotNull
        private final Severity severity;
        @Nullable
        private final String message;
        @Nullable
        private final String supertypeName;
        private final boolean fromSupertype;
        @NotNull
        private static final Severity DEFAULT_SEVERITY = Severity.ERROR;

        public Experimentality(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message2, @Nullable String supertypeName, boolean fromSupertype) {
            Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            this.annotationClassId = annotationClassId;
            this.severity = severity;
            this.message = message2;
            this.supertypeName = supertypeName;
            this.fromSupertype = fromSupertype;
        }

        public /* synthetic */ Experimentality(ClassId classId, Severity severity, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(classId, severity, string, string2, bl);
        }

        @NotNull
        public final ClassId getAnnotationClassId() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getSupertypeName() {
            return this.supertypeName;
        }

        public final boolean getFromSupertype() {
            return this.fromSupertype;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Experimentality)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.annotationClassId, (Object)((Experimentality)other).annotationClassId)) {
                return false;
            }
            if (this.severity != ((Experimentality)other).severity) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)((Experimentality)other).message)) {
                return false;
            }
            return this.fromSupertype == ((Experimentality)other).fromSupertype;
        }

        public int hashCode() {
            int result2 = this.annotationClassId.hashCode();
            result2 = 31 * result2 + this.severity.hashCode();
            String string = this.message;
            result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
            result2 = 31 * result2 + Boolean.hashCode(this.fromSupertype);
            return result2;
        }

        @NotNull
        public final ClassId component1() {
            return this.annotationClassId;
        }

        @NotNull
        public final Severity component2() {
            return this.severity;
        }

        @Nullable
        public final String component3() {
            return this.message;
        }

        @Nullable
        public final String component4() {
            return this.supertypeName;
        }

        public final boolean component5() {
            return this.fromSupertype;
        }

        @NotNull
        public final Experimentality copy(@NotNull ClassId annotationClassId, @NotNull Severity severity, @Nullable String message2, @Nullable String supertypeName, boolean fromSupertype) {
            Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return new Experimentality(annotationClassId, severity, message2, supertypeName, fromSupertype);
        }

        public static /* synthetic */ Experimentality copy$default(Experimentality experimentality, ClassId classId, Severity severity, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classId = experimentality.annotationClassId;
            }
            if ((n & 2) != 0) {
                severity = experimentality.severity;
            }
            if ((n & 4) != 0) {
                string = experimentality.message;
            }
            if ((n & 8) != 0) {
                string2 = experimentality.supertypeName;
            }
            if ((n & 0x10) != 0) {
                bl = experimentality.fromSupertype;
            }
            return experimentality.copy(classId, severity, string, string2, bl);
        }

        @NotNull
        public String toString() {
            return "Experimentality(annotationClassId=" + this.annotationClassId + ", severity=" + (Object)((Object)this.severity) + ", message=" + this.message + ", supertypeName=" + this.supertypeName + ", fromSupertype=" + this.fromSupertype + ')';
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Companion;", "", "<init>", "()V", "DEFAULT_SEVERITY", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "getDEFAULT_SEVERITY", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Severity getDEFAULT_SEVERITY() {
                return DEFAULT_SEVERITY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality$Severity;", "", "<init>", "(Ljava/lang/String;I)V", "WARNING", "ERROR", "checkers"})
        public static final class Severity
        extends Enum<Severity> {
            public static final /* enum */ Severity WARNING = new Severity();
            public static final /* enum */ Severity ERROR = new Severity();
            private static final /* synthetic */ Severity[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Severity[] values() {
                return (Severity[])$VALUES.clone();
            }

            public static Severity valueOf(String value2) {
                return Enum.valueOf(Severity.class, value2);
            }

            @NotNull
            public static EnumEntries<Severity> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = severityArray = new Severity[]{Severity.WARNING, Severity.ERROR};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Experimentality.Severity.values().length];
            try {
                nArray[Experimentality.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Experimentality.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

