/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.web.common.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirJsCodeConstantArgumentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "jsCodeCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkers.web.common"})
@SourceDebugExtension(value={"SMAP\nFirJsCodeConstantArgumentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsCodeConstantArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirJsCodeConstantArgumentChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,61:1\n46#2:62\n*S KotlinDebug\n*F\n+ 1 FirJsCodeConstantArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirJsCodeConstantArgumentChecker\n*L\n32#1:62\n*E\n"})
public final class FirJsCodeConstantArgumentChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJsCodeConstantArgumentChecker INSTANCE = new FirJsCodeConstantArgumentChecker();
    @NotNull
    private static final CallableId jsCodeCallableId = WebCommonStandardClassIds.Callables.Js;

    private FirJsCodeConstantArgumentChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (!Intrinsics.areEqual((Object)(firCallableSymbol != null ? firCallableSymbol.getCallableId() : null), (Object)jsCodeCallableId)) {
            return;
        }
        FirCall $this$arguments$iv = expression2;
        boolean $i$f$getArguments = false;
        FirExpression jsCodeExpression = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (jsCodeExpression == null || !ConeBuiltinTypeUtilsKt.isString(FirTypeUtilsKt.getResolvedType(jsCodeExpression))) {
            DiagnosticContext diagnosticContext = context2;
            Object object = jsCodeExpression;
            if (object == null || (object = ((FirExpression)object).getSource()) == null) {
                object = expression2.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext, reporter, (AbstractKtSourceElement)object, FirWebCommonErrors.INSTANCE.getJSCODE_ARGUMENT_NON_CONST_EXPRESSION(), null, 8, null);
            return;
        }
        jsCodeExpression.accept(new FirVisitorVoid(context2, jsCodeExpression, reporter){
            private FirElement lastReportedElement;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ FirExpression $jsCodeExpression;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$context = $context;
                this.$jsCodeExpression = $jsCodeExpression;
                this.$reporter = $reporter;
            }

            public final FirElement getLastReportedElement() {
                return this.lastReportedElement;
            }

            public final void setLastReportedElement(FirElement firElement) {
                this.lastReportedElement = firElement;
            }

            public void visitElement(FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                FirElement lastReported = this.lastReportedElement;
                element.acceptChildren(this);
                if (Intrinsics.areEqual((Object)lastReported, (Object)this.lastReportedElement) && !FirConstChecksKt.canBeEvaluatedAtCompileTime(element instanceof FirExpression ? (FirExpression)element : null, this.$context.getSession(), true, true)) {
                    this.lastReportedElement = element;
                    KtSourceElement ktSourceElement = element.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = this.$jsCodeExpression.getSource();
                    }
                    KtSourceElement source = ktSourceElement;
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)source, FirWebCommonErrors.INSTANCE.getJSCODE_ARGUMENT_NON_CONST_EXPRESSION(), null, 8, null);
                }
            }

            public void visitPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
                FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(propertyAccessExpression.getCalleeReference(), false, 1, null);
                if (firCallableSymbol != null) {
                    FirCallableSymbol $this$isConst$iv = firCallableSymbol;
                    boolean $i$f$isConst = false;
                    bl = $this$isConst$iv.getRawStatus().isConst();
                } else {
                    bl = false;
                }
                if (!bl) {
                    super.visitPropertyAccessExpression(propertyAccessExpression);
                }
            }
        });
    }
}

