/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.pipeline;

import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.builder.PsiRawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.pipeline.AnalyseKt;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.fir.session.SourcesToPathsMapper;
import org.jetbrains.kotlin.fir.session.SourcesToPathsMapperKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005\u001a$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00012\u0006\u0010\u0007\u001a\u00020\u0013\u001a$\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0013\u001a@\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00132\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\u0018\u00a8\u0006\u0019"}, d2={"buildFirViaLightTree", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/FirSession;", "files", "", "Lorg/jetbrains/kotlin/KtSourceFile;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportFilesAndLines", "Lkotlin/Function2;", "", "", "buildFirFromKtFiles", "ktFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "buildResolveAndCheckFirFromKtFiles", "Lorg/jetbrains/kotlin/fir/pipeline/ModuleCompilerAnalyzedOutput;", "session", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "resolveAndCheckFir", "firFiles", "buildResolveAndCheckFirViaLightTree", "countFilesAndLines", "Lkotlin/reflect/KFunction2;", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nfirUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 firUtils.kt\norg/jetbrains/kotlin/fir/pipeline/FirUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1563#2:91\n1634#2,3:92\n1563#2:95\n1634#2,3:96\n*S KotlinDebug\n*F\n+ 1 firUtils.kt\norg/jetbrains/kotlin/fir/pipeline/FirUtilsKt\n*L\n33#1:91\n33#1:92,3\n52#1:95\n52#1:96,3\n*E\n"})
public final class FirUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirFile> buildFirViaLightTree(@NotNull FirSession $this$buildFirViaLightTree, @NotNull Collection<? extends KtSourceFile> files2, @Nullable DiagnosticReporter diagnosticsReporter, @Nullable Function2<? super Integer, ? super Integer, Unit> reportFilesAndLines) {
        List firFiles;
        block9: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$buildFirViaLightTree, (String)"<this>");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            FirProvider firProvider = FirProviderKt.getFirProvider($this$buildFirViaLightTree);
            Intrinsics.checkNotNull((Object)firProvider, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl");
            FirProviderImpl firProvider2 = (FirProviderImpl)firProvider;
            SourcesToPathsMapper sourcesToPathsMapper = SourcesToPathsMapperKt.getSourcesToPathsMapper($this$buildFirViaLightTree);
            LightTree2Fir builder2 = new LightTree2Fir($this$buildFirViaLightTree, (FirScopeProvider)firProvider2.getKotlinScopeProvider(), diagnosticsReporter);
            boolean shouldCountLines = reportFilesAndLines != null;
            int linesCount = 0;
            Iterable $this$map$iv = files2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                void file;
                KtSourceFile ktSourceFile = (KtSourceFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Closeable closeable = new InputStreamReader(file.getContentsAsStream(), Charsets.UTF_8);
                Throwable throwable = null;
                try {
                    InputStreamReader it = (InputStreamReader)closeable;
                    boolean bl2 = false;
                    object = KtSourceFileLinesMappingKt.readSourceFileWithMapping(it);
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Pair<CharSequence, KtSourceFileLinesMapping> pair = object;
                CharSequence code = (CharSequence)pair.component1();
                KtSourceFileLinesMapping linesMapping = (KtSourceFileLinesMapping)pair.component2();
                if (shouldCountLines) {
                    linesCount += linesMapping.getLinesCount();
                }
                Object firFile = object = builder2.buildFirFile(code, (KtSourceFile)file, linesMapping);
                boolean bl3 = false;
                firProvider2.recordFile((FirFile)firFile);
                KtSourceElement ktSourceElement = ((FirFile)firFile).getSource();
                Intrinsics.checkNotNull((Object)ktSourceElement);
                String string = file.getPath();
                if (string == null) {
                    string = file.getName();
                }
                sourcesToPathsMapper.registerFileSource(ktSourceElement, string);
                collection.add(object);
            }
            firFiles = (List)destination$iv$iv;
            Function2<? super Integer, ? super Integer, Unit> function2 = reportFilesAndLines;
            if (function2 == null) break block9;
            function2.invoke((Object)files2.size(), (Object)linesCount);
        }
        return firFiles;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirFile> buildFirFromKtFiles(@NotNull FirSession $this$buildFirFromKtFiles, @NotNull Collection<? extends KtFile> ktFiles) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$buildFirFromKtFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        FirProvider firProvider = FirProviderKt.getFirProvider($this$buildFirFromKtFiles);
        Intrinsics.checkNotNull((Object)firProvider, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl");
        FirProviderImpl firProvider2 = (FirProviderImpl)firProvider;
        PsiRawFirBuilder builder2 = new PsiRawFirBuilder($this$buildFirFromKtFiles, firProvider2.getKotlinScopeProvider(), null, 4, null);
        Iterable $this$map$iv = ktFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirFile firFile;
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirFile firFile2 = firFile = builder2.buildFirFile((KtFile)it);
            boolean bl2 = false;
            firProvider2.recordFile(firFile2);
            collection.add(firFile);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ModuleCompilerAnalyzedOutput buildResolveAndCheckFirFromKtFiles(@NotNull FirSession session, @NotNull List<? extends KtFile> ktFiles, @NotNull BaseDiagnosticsCollector diagnosticsReporter) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
        return FirUtilsKt.resolveAndCheckFir(session, FirUtilsKt.buildFirFromKtFiles(session, (Collection<? extends KtFile>)ktFiles), diagnosticsReporter);
    }

    @NotNull
    public static final ModuleCompilerAnalyzedOutput resolveAndCheckFir(@NotNull FirSession session, @NotNull List<? extends FirFile> firFiles, @NotNull BaseDiagnosticsCollector diagnosticsReporter) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(firFiles, (String)"firFiles");
        Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
        Pair<ScopeSession, List<FirFile>> pair = AnalyseKt.runResolution(session, firFiles);
        ScopeSession scopeSession = (ScopeSession)pair.component1();
        List fir = (List)pair.component2();
        AnalyseKt.runCheckers(session, scopeSession, fir, diagnosticsReporter, MppCheckerKind.Common);
        return new ModuleCompilerAnalyzedOutput(session, scopeSession, fir);
    }

    @NotNull
    public static final ModuleCompilerAnalyzedOutput buildResolveAndCheckFirViaLightTree(@NotNull FirSession session, @NotNull Collection<? extends KtSourceFile> ktFiles, @NotNull BaseDiagnosticsCollector diagnosticsReporter, @Nullable KFunction<Unit> countFilesAndLines2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
        List<FirFile> firFiles = FirUtilsKt.buildFirViaLightTree(session, ktFiles, diagnosticsReporter, (Function2<? super Integer, ? super Integer, Unit>)((Function2)countFilesAndLines2));
        return FirUtilsKt.resolveAndCheckFir(session, firFiles, diagnosticsReporter);
    }
}

