/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParseResult;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser;", "", "<init>", "()V", "parse", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParseResult;", "file", "Ljava/io/File;", "content", "", "jsonObject", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "MappingStream", "js.parser"})
@SourceDebugExtension(value={"SMAP\nSourceMapParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapParser.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1563#2:218\n1634#2,3:219\n1634#2,3:222\n1563#2:225\n1634#2,3:226\n1563#2:229\n1634#2,3:230\n1193#2,2:233\n1267#2,4:235\n1#3:239\n*S KotlinDebug\n*F\n+ 1 SourceMapParser.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser\n*L\n63#1:218\n63#1:219,3\n74#1:222,3\n83#1:225\n83#1:226,3\n99#1:229\n99#1:230,3\n107#1:233,2\n107#1:235,4\n*E\n"})
public final class SourceMapParser {
    @NotNull
    public static final SourceMapParser INSTANCE = new SourceMapParser();

    private SourceMapParser() {
    }

    @NotNull
    public final SourceMapParseResult parse(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.parse(FilesKt.readText((File)file, (Charset)Charsets.UTF_8));
    }

    @NotNull
    public final SourceMapParseResult parse(@NotNull String content) throws IOException {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            jsonNode = JSONKt.parseJson(content);
        }
        catch (JsonSyntaxException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "parse error";
            }
            return new SourceMapError(string);
        }
        JsonNode jsonObject = jsonNode;
        return this.parse(jsonObject);
    }

    /*
     * WARNING - void declaration
     */
    private final SourceMapParseResult parse(JsonNode jsonObject) throws IOException {
        SourceMapGroup it12;
        void $this$associateTo$iv$iv;
        List list;
        Object namesProperty;
        List list2;
        JsonNode sourcesContentProperty;
        Set set;
        List list3;
        Object object;
        Iterable destination$iv$iv;
        String string;
        JsonNode version2;
        if (!(jsonObject instanceof JsonObject)) {
            return new SourceMapError("Top-level object expected");
        }
        JsonNode jsonNode = ((JsonObject)jsonObject).getProperties().get("version");
        if (jsonNode == null) {
            return new SourceMapError("Version not defined");
        }
        JsonNode it2 = version2 = jsonNode;
        boolean bl = false;
        if (!(version2 instanceof JsonNumber) || !(((JsonNumber)version2).getValue() == 3.0)) {
            return new SourceMapError("Unsupported version: " + it2);
        }
        JsonNode it3 = ((JsonObject)jsonObject).getProperties().get("sourceRoot");
        boolean bl2 = false;
        if (it3 != null) {
            JsonNode jsonNode2 = it3;
            JsonString jsonString = jsonNode2 instanceof JsonString ? (JsonString)jsonNode2 : null;
            if (jsonString == null) {
                return new SourceMapError("'sourceRoot' property is not of string type");
            }
            string = jsonString.getValue();
        } else {
            string = "";
        }
        String sourceRoot = string;
        JsonNode it4 = ((JsonObject)jsonObject).getProperties().get("sources");
        boolean bl3 = false;
        if (it4 != null) {
            void $this$mapTo$iv$iv;
            JsonNode jsonNode3 = it4;
            JsonArray jsonArray = jsonNode3 instanceof JsonArray ? (JsonArray)jsonNode3 : null;
            if (jsonArray == null) {
                return new SourceMapError("'sources' property is not of array type");
            }
            JsonArray sourcesProperty = jsonArray;
            Iterable $this$map$iv = sourcesProperty.getElements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                JsonNode jsonNode4 = (JsonNode)item$iv$iv;
                object = destination$iv$iv;
                boolean bl4 = false;
                JsonString jsonString = it5 instanceof JsonString ? (JsonString)it5 : null;
                if (jsonString == null) {
                    return new SourceMapError("'sources' array must contain strings");
                }
                object.add(jsonString.getValue());
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = CollectionsKt.emptyList();
        }
        List sources = list3;
        JsonNode jsonNode5 = ((JsonObject)jsonObject).getProperties().get("ignoreList");
        if (jsonNode5 == null) {
            jsonNode5 = ((JsonObject)jsonObject).getProperties().get("x_google_ignoreList");
        }
        if (jsonNode5 != null) {
            void destination$iv;
            void $this$mapTo$iv;
            JsonNode it6 = jsonNode5;
            boolean bl5 = false;
            JsonArray jsonArray = it6 instanceof JsonArray ? (JsonArray)it6 : null;
            if (jsonArray == null) {
                return new SourceMapError("'ignoreList' property is not of array type");
            }
            JsonArray ignoreList = jsonArray;
            destination$iv$iv = ignoreList.getElements();
            Collection $i$f$mapTo = new HashSet();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it7;
                object = (JsonNode)item$iv;
                void bl4 = destination$iv;
                boolean bl6 = false;
                JsonNumber jsonNumber = it7 instanceof JsonNumber ? (JsonNumber)it7 : null;
                if (jsonNumber == null) {
                    return new SourceMapError("'ignoreList' array must contain numbers");
                }
                bl4.add((int)jsonNumber.getValue());
            }
            set = (HashSet)destination$iv;
        } else {
            set = SetsKt.emptySet();
        }
        Set ignoreList = set;
        JsonNode it8 = ((JsonObject)jsonObject).getProperties().get("sourcesContent");
        boolean bl7 = false;
        if (it8 != null) {
            void $this$mapTo$iv$iv;
            JsonNode bl5 = it8;
            JsonArray jsonArray = bl5 instanceof JsonArray ? (JsonArray)bl5 : null;
            if (jsonArray == null) {
                return new SourceMapError("'sourcesContent' property is not of array type");
            }
            sourcesContentProperty = jsonArray;
            Iterable $this$map$iv = ((JsonArray)sourcesContentProperty).getElements();
            boolean $i$f$map = false;
            Iterable destination$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2;
                void it9;
                JsonNode bl4 = (JsonNode)item$iv$iv;
                Collection bl6 = destination$iv$iv2;
                boolean bl8 = false;
                void var21_62 = it9;
                if (var21_62 instanceof JsonNull) {
                    string2 = null;
                } else if (var21_62 instanceof JsonString) {
                    string2 = ((JsonString)it9).getValue();
                } else {
                    return new SourceMapError("'sources' array must contain strings");
                }
                bl6.add(string2);
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List sourcesContent = list2;
        JsonNode it10 = ((JsonObject)jsonObject).getProperties().get("names");
        boolean bl9 = false;
        if (it10 != null) {
            void $this$mapTo$iv$iv;
            sourcesContentProperty = it10;
            JsonNode jsonNode6 = sourcesContentProperty instanceof JsonArray ? sourcesContentProperty : null;
            if (jsonNode6 == null) {
                return new SourceMapError("'names' property is not of array type");
            }
            namesProperty = jsonNode6;
            Iterable $this$map$iv = ((JsonArray)namesProperty).getElements();
            boolean $i$f$map = false;
            Iterable destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it11;
                JsonNode bl6 = (JsonNode)item$iv$iv;
                Collection bl8 = destination$iv$iv3;
                boolean bl10 = false;
                JsonString jsonString = it11 instanceof JsonString ? (JsonString)it11 : null;
                if (jsonString == null) {
                    return new SourceMapError("'names' array must contain strings");
                }
                bl8.add(jsonString.getValue());
            }
            list = (List)destination$iv$iv3;
        } else {
            list = CollectionsKt.emptyList();
        }
        List names = list;
        Iterable $this$associate$iv = CollectionsKt.zip((Iterable)sources, (Iterable)sourcesContent);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        namesProperty = $this$associate$iv;
        Map destination$iv$iv4 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Object item$iv$iv;
            item$iv$iv = destination$iv$iv4;
            Pair it12 = (Pair)element$iv$iv;
            boolean bl11 = false;
            item$iv$iv.put(it12.getFirst(), it12.getSecond());
        }
        Map sourcePathToContent = destination$iv$iv4;
        JsonNode jsonNode7 = ((JsonObject)jsonObject).getProperties().get("mappings");
        if (jsonNode7 == null) {
            return new SourceMapError("'mappings' property not found");
        }
        JsonNode mappings2 = jsonNode7;
        if (!(mappings2 instanceof JsonString)) {
            return new SourceMapError("'mappings' property is not of string type");
        }
        int jsColumn = 0;
        int sourceLine = 0;
        int sourceColumn = 0;
        int sourceIndex = 0;
        int nameIndex = 0;
        MappingStream stream = new MappingStream(((JsonString)mappings2).getValue());
        SourceMap sourceMap = new SourceMap((Function1<? super String, ? extends Reader>)((Function1)arg_0 -> SourceMapParser.parse$lambda$12(sourcePathToContent, arg_0)));
        SourceMapGroup it13 = it12 = new SourceMapGroup();
        boolean bl12 = false;
        ((Collection)sourceMap.getGroups()).add(it13);
        SourceMapGroup currentGroup = it12;
        while (!stream.isEof()) {
            if (stream.isGroupTerminator()) {
                it13 = it12 = new SourceMapGroup();
                boolean bl13 = false;
                ((Collection)sourceMap.getGroups()).add(it13);
                currentGroup = it12;
                jsColumn = 0;
                stream.skipChar();
                continue;
            }
            Integer n = stream.readInt();
            if (n == null) {
                return stream.createError("VLQ-encoded JS column number expected");
            }
            jsColumn += n.intValue();
            if (stream.isEncodedInt()) {
                String name2;
                String string3;
                Integer n2 = stream.readInt();
                if (n2 == null) {
                    return stream.createError("VLQ-encoded source index expected");
                }
                sourceIndex += n2.intValue();
                Integer n3 = stream.readInt();
                if (n3 == null) {
                    return stream.createError("VLQ-encoded source line expected");
                }
                sourceLine += n3.intValue();
                Integer n4 = stream.readInt();
                if (n4 == null) {
                    return stream.createError("VLQ-encoded source column expected");
                }
                sourceColumn += n4.intValue();
                if (stream.isEncodedInt()) {
                    Integer n5 = stream.readInt();
                    if (n5 == null) {
                        return stream.createError("VLQ-encoded name index expected");
                    }
                    if (!(0 <= (nameIndex += n5.intValue()) ? nameIndex < ((Collection)names).size() : false)) {
                        return stream.createError("Name index " + nameIndex + " is out of bounds " + CollectionsKt.getIndices((Collection)names));
                    }
                    string3 = (String)names.get(nameIndex);
                } else {
                    string3 = name2 = null;
                }
                if (!(0 <= sourceIndex ? sourceIndex < ((Collection)sources).size() : false)) {
                    return stream.createError("Source index " + sourceIndex + " is out of bounds " + CollectionsKt.getIndices((Collection)sources));
                }
                ((Collection)currentGroup.getSegments()).add(new SourceMapSegment(jsColumn, sourceRoot + (String)sources.get(sourceIndex), sourceLine, sourceColumn, name2, ignoreList.contains(sourceIndex)));
            } else {
                ((Collection)currentGroup.getSegments()).add(new SourceMapSegment(jsColumn, null, -1, -1, null, false));
            }
            if (stream.isEof()) break;
            if (stream.isGroupTerminator()) {
                SourceMapGroup sourceMapGroup;
                it13 = sourceMapGroup = new SourceMapGroup();
                boolean bl14 = false;
                ((Collection)sourceMap.getGroups()).add(it13);
                currentGroup = sourceMapGroup;
                jsColumn = 0;
            } else if (!stream.isSegmentTerminator()) {
                return stream.createError("Unexpected char, ',' or ';' expected");
            }
            stream.skipChar();
        }
        return new SourceMapSuccess(sourceMap);
    }

    private static final Reader parse$lambda$12(Map $sourcePathToContent, String it) {
        StringReader stringReader;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = (String)$sourcePathToContent.get(it);
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            stringReader = new StringReader(it2);
        } else {
            stringReader = null;
        }
        return stringReader;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\r\u0010\u0016\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser$MappingStream;", "", "string", "", "<init>", "(Ljava/lang/String;)V", "getString", "()Ljava/lang/String;", "position", "", "getPosition", "()I", "setPosition", "(I)V", "isEof", "", "()Z", "isSegmentTerminator", "isGroupTerminator", "isEncodedInt", "skipChar", "", "readInt", "()Ljava/lang/Integer;", "base64value", "c", "", "(C)Ljava/lang/Integer;", "createError", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapError;", "error", "js.parser"})
    public static final class MappingStream {
        @NotNull
        private final String string;
        private int position;

        public MappingStream(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.string = string;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        public final boolean isEof() {
            return this.position == this.string.length();
        }

        public final boolean isSegmentTerminator() {
            return this.string.charAt(this.position) == ',';
        }

        public final boolean isGroupTerminator() {
            return this.string.charAt(this.position) == ';';
        }

        public final boolean isEncodedInt() {
            return !this.isEof() && !this.isSegmentTerminator() && !this.isGroupTerminator();
        }

        public final void skipChar() {
            int n = this.position;
            this.position = n + 1;
        }

        @Nullable
        public final Integer readInt() {
            int value2 = 0;
            int shift = 0;
            while (true) {
                if (this.isEof()) {
                    return null;
                }
                int n = this.position;
                this.position = n + 1;
                Integer n2 = this.base64value(this.string.charAt(n));
                if (n2 == null) {
                    return null;
                }
                int digit = n2;
                int digitValue = digit & 0x1F;
                value2 |= digitValue << shift;
                if ((digit & 0x20) == 0) break;
                shift += 5;
            }
            int unsignedValue = value2 >>> 1;
            return (value2 & 1) == 0 ? Integer.valueOf(unsignedValue) : Integer.valueOf(-unsignedValue);
        }

        private final Integer base64value(char c) {
            Integer n;
            block1: {
                char c2;
                block0: {
                    c2 = c;
                    boolean bl = 'A' <= c2 ? c2 < '[' : false;
                    if (!bl) break block0;
                    n = c - 65;
                    break block1;
                }
                n = ('a' <= c2 ? c2 < '{' : false) ? Integer.valueOf(c - 97 + 26) : (('0' <= c2 ? c2 < ':' : false) ? Integer.valueOf(c - 48 + 52) : (c2 == '+' ? Integer.valueOf(62) : (c2 == '/' ? Integer.valueOf(63) : null)));
            }
            return n;
        }

        @NotNull
        public final SourceMapError createError(@NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new SourceMapError("Error parsing stream at offset " + this.position + ": " + error);
        }
    }
}

