/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.shrinker;

import com.android.aapt.Resources;
import com.android.build.shrinker.ApkArchiveFormat;
import com.android.build.shrinker.ArchiveFormat;
import com.android.build.shrinker.BundleArchiveFormat;
import com.android.build.shrinker.LinkedResourcesFormat;
import com.android.build.shrinker.ResourceShrinker;
import com.android.build.shrinker.ResourceShrinkerImpl;
import com.android.build.shrinker.ResourceShrinkerModel;
import com.android.build.shrinker.ResourceTableUtilKt;
import com.android.build.shrinker.ShrinkerDebugReporter;
import com.android.build.shrinker.gatherer.ResourcesGatherer;
import com.android.build.shrinker.graph.ResourcesGraphBuilder;
import com.android.build.shrinker.obfuscation.ObfuscationMappingsRecorder;
import com.android.build.shrinker.usages.ResourceUsageRecorder;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceStore;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceType;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J,\u0010$\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0&H\u0016J \u0010(\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020)H\u0002J \u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u000200H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0003X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/build/shrinker/ResourceShrinkerImpl;", "Lcom/android/build/shrinker/ResourceShrinker;", "resourcesGatherers", "", "Lcom/android/build/shrinker/gatherer/ResourcesGatherer;", "obfuscationMappingsRecorder", "Lcom/android/build/shrinker/obfuscation/ObfuscationMappingsRecorder;", "usageRecorders", "Lcom/android/build/shrinker/usages/ResourceUsageRecorder;", "graphBuilders", "Lcom/android/build/shrinker/graph/ResourcesGraphBuilder;", "debugReporter", "Lcom/android/build/shrinker/ShrinkerDebugReporter;", "supportMultipackages", "", "<init>", "(Ljava/util/List;Lcom/android/build/shrinker/obfuscation/ObfuscationMappingsRecorder;Ljava/util/List;Ljava/util/List;Lcom/android/build/shrinker/ShrinkerDebugReporter;Z)V", "getSupportMultipackages", "()Z", "model", "Lcom/android/build/shrinker/ResourceShrinkerModel;", "getModel", "()Lcom/android/build/shrinker/ResourceShrinkerModel;", "unused", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "analyze", "", "close", "getUnusedResourceCount", "", "rewriteResourcesInApkFormat", "source", "Ljava/io/File;", "dest", "format", "Lcom/android/build/shrinker/LinkedResourcesFormat;", "rewriteResourcesInBundleFormat", "moduleNameToPackageNameMap", "", "", "rewriteResourceZip", "Lcom/android/build/shrinker/ArchiveFormat;", "removeResourceUnusedTableEntries", "zis", "Ljava/io/InputStream;", "zos", "Ljava/util/jar/JarOutputStream;", "srcEntry", "Ljava/util/zip/ZipEntry;", "copyToOutput", "entry", "shrinker"})
@SourceDebugExtension(value={"SMAP\nResourceShrinkerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceShrinkerImpl.kt\ncom/android/build/shrinker/ResourceShrinkerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,248:1\n1869#2,2:249\n1869#2,2:251\n1869#2,2:253\n827#2:257\n855#2,2:258\n1563#2:260\n1634#2,3:261\n1321#3,2:255\n*S KotlinDebug\n*F\n+ 1 ResourceShrinkerImpl.kt\ncom/android/build/shrinker/ResourceShrinkerImpl\n*L\n70#1:249,2\n72#1:251,2\n73#1:253,2\n156#1:257\n156#1:258,2\n157#1:260\n157#1:261,3\n127#1:255,2\n*E\n"})
public final class ResourceShrinkerImpl
implements ResourceShrinker {
    @NotNull
    private final List<ResourcesGatherer> resourcesGatherers;
    @Nullable
    private final ObfuscationMappingsRecorder obfuscationMappingsRecorder;
    @NotNull
    private final List<ResourceUsageRecorder> usageRecorders;
    @NotNull
    private final List<ResourcesGraphBuilder> graphBuilders;
    @NotNull
    private final ShrinkerDebugReporter debugReporter;
    private final boolean supportMultipackages;
    @NotNull
    private final ResourceShrinkerModel model;
    private List<? extends ResourceUsageModel.Resource> unused;

    public ResourceShrinkerImpl(@NotNull List<? extends ResourcesGatherer> resourcesGatherers, @Nullable ObfuscationMappingsRecorder obfuscationMappingsRecorder, @NotNull List<? extends ResourceUsageRecorder> usageRecorders, @NotNull List<? extends ResourcesGraphBuilder> graphBuilders, @NotNull ShrinkerDebugReporter debugReporter, boolean supportMultipackages) {
        Intrinsics.checkNotNullParameter(resourcesGatherers, (String)"resourcesGatherers");
        Intrinsics.checkNotNullParameter(usageRecorders, (String)"usageRecorders");
        Intrinsics.checkNotNullParameter(graphBuilders, (String)"graphBuilders");
        Intrinsics.checkNotNullParameter((Object)debugReporter, (String)"debugReporter");
        this.resourcesGatherers = resourcesGatherers;
        this.obfuscationMappingsRecorder = obfuscationMappingsRecorder;
        this.usageRecorders = usageRecorders;
        this.graphBuilders = graphBuilders;
        this.debugReporter = debugReporter;
        this.supportMultipackages = supportMultipackages;
        this.model = new ResourceShrinkerModel(this.debugReporter, this.supportMultipackages);
    }

    public final boolean getSupportMultipackages() {
        return this.supportMultipackages;
    }

    @NotNull
    public final ResourceShrinkerModel getModel() {
        return this.model;
    }

    @Override
    public void analyze() {
        Object it;
        Iterable $this$forEach$iv = this.resourcesGatherers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourcesGatherer)element$iv;
            boolean bl = false;
            it.gatherResourceValues(this.model);
        }
        ObfuscationMappingsRecorder obfuscationMappingsRecorder = this.obfuscationMappingsRecorder;
        if (obfuscationMappingsRecorder != null) {
            obfuscationMappingsRecorder.recordObfuscationMappings(this.model);
        }
        $this$forEach$iv = this.usageRecorders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourceUsageRecorder)element$iv;
            boolean bl = false;
            it.recordUsages(this.model);
        }
        $this$forEach$iv = this.graphBuilders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourcesGraphBuilder)element$iv;
            boolean bl = false;
            it.buildGraph(this.model);
        }
        this.model.getResourceStore().processToolsAttributes();
        this.model.keepPossiblyReferencedResources();
        this.debugReporter.debug((Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ ResourceShrinkerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.getModel().getResourceStore().dumpResourceModel();
            }
        }));
        this.unused = ResourcesUtil.findUnusedResources((List)this.model.getResourceStore().getResources(), (Function1)((Function1)new Function1<List<? extends ResourceUsageModel.Resource>, Unit>(this){
            final /* synthetic */ ResourceShrinkerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(List<? extends ResourceUsageModel.Resource> roots) {
                Intrinsics.checkNotNullParameter(roots, (String)"roots");
                ResourceShrinkerImpl.access$getDebugReporter$p(this.this$0).debug((Function0<String>)((Function0)analyze.1.INSTANCE));
                ResourceShrinkerImpl.access$getDebugReporter$p(this.this$0).debug((Function0<String>)((Function0)new Function0<String>(roots){
                    final /* synthetic */ List<ResourceUsageModel.Resource> $roots;
                    {
                        this.$roots = $roots;
                        super(0);
                    }

                    public final String invoke() {
                        return CollectionsKt.joinToString$default((Iterable)this.$roots, (CharSequence)"\n", null, null, (int)0, null, (Function1)analyze.1.INSTANCE, (int)30, null);
                    }
                }));
            }
        }));
        this.debugReporter.debug((Function0<String>)((Function0)analyze.6.INSTANCE));
        this.debugReporter.debug((Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ ResourceShrinkerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                List list = ResourceShrinkerImpl.access$getUnused$p(this.this$0);
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"unused");
                    list = null;
                }
                return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, (Function1)analyze.1.INSTANCE, (int)30, null);
            }
        }));
    }

    @Override
    public void close() {
        this.debugReporter.close();
    }

    @Override
    public int getUnusedResourceCount() {
        List<? extends ResourceUsageModel.Resource> list = this.unused;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unused");
            list = null;
        }
        return list.size();
    }

    @Override
    public void rewriteResourcesInApkFormat(@NotNull File source, @NotNull File dest, @NotNull LinkedResourcesFormat format) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        ResourceStore resourceStore = this.model.getResourceStore();
        Intrinsics.checkNotNullExpressionValue((Object)resourceStore, (String)"getResourceStore(...)");
        this.rewriteResourceZip(source, dest, new ApkArchiveFormat(resourceStore, format));
    }

    @Override
    public void rewriteResourcesInBundleFormat(@NotNull File source, @NotNull File dest, @NotNull Map<String, String> moduleNameToPackageNameMap) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter(moduleNameToPackageNameMap, (String)"moduleNameToPackageNameMap");
        ResourceStore resourceStore = this.model.getResourceStore();
        Intrinsics.checkNotNullExpressionValue((Object)resourceStore, (String)"getResourceStore(...)");
        this.rewriteResourceZip(source, dest, new BundleArchiveFormat(resourceStore, moduleNameToPackageNameMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void rewriteResourceZip(File source, File dest, ArchiveFormat format) {
        if (dest.exists() && !dest.delete()) {
            throw new IOException("Could not delete " + dest);
        }
        Closeable closeable = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));
        Throwable throwable = null;
        try {
            JarOutputStream zos = (JarOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipFile(source);
            Throwable throwable2 = null;
            try {
                void $this$forEach$iv;
                ZipFile zip = (ZipFile)closeable2;
                boolean bl2 = false;
                zos.setLevel(9);
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ZipEntry it = (ZipEntry)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (format.fileIsNotReachable(it)) continue;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (StringsKt.endsWith$default((String)string, (String)"resources.pb", (boolean)false, (int)2, null)) {
                        InputStream inputStream = zip.getInputStream(it);
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                        this.removeResourceUnusedTableEntries(inputStream, zos, it);
                        continue;
                    }
                    InputStream inputStream = zip.getInputStream(it);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    this.copyToOutput(inputStream, zos, it);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            zos = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        long before = source.length();
        long after = dest.length();
        if (after > before) {
            this.debugReporter.info((Function0<String>)((Function0)new Function0<String>(before, after){
                final /* synthetic */ long $before;
                final /* synthetic */ long $after;
                {
                    this.$before = $before;
                    this.$after = $after;
                    super(0);
                }

                public final String invoke() {
                    return "Resource shrinking did not work (grew from " + this.$before + " to " + this.$after + "); using original instead";
                }
            }));
            Files.copy((File)source, (File)dest);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeResourceUnusedTableEntries(InputStream zis, JarOutputStream zos, ZipEntry srcEntry) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ResourceUsageModel.Resource it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        List<? extends ResourceUsageModel.Resource> list = this.unused;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unused");
            list = null;
        }
        Iterable iterable = list;
        boolean $i$f$filterNot = false;
        void var7_7 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResourceUsageModel.Resource)element$iv$iv;
            boolean bl = false;
            if (it.type == ResourceType.ID) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void resource;
            it = (ResourceUsageModel.Resource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(resource.value);
        }
        List resourceIdsToRemove = (List)destination$iv$iv;
        Resources.ResourceTable resourceTable = Resources.ResourceTable.parseFrom((InputStream)zis);
        Intrinsics.checkNotNullExpressionValue((Object)resourceTable, (String)"parseFrom(...)");
        Resources.ResourceTable shrunkenResourceTable = ResourceTableUtilKt.nullOutEntriesWithIds(resourceTable, resourceIdsToRemove);
        byte[] bytes2 = shrunkenResourceTable.toByteArray();
        JarEntry outEntry = new JarEntry(srcEntry.getName());
        if (srcEntry.getTime() != -1L) {
            outEntry.setTime(srcEntry.getTime());
        }
        if (srcEntry.getMethod() == 0) {
            outEntry.setMethod(0);
            outEntry.setSize(bytes2.length);
            CRC32 crc = new CRC32();
            crc.update(bytes2, 0, bytes2.length);
            outEntry.setCrc(crc.getValue());
        }
        zos.putNextEntry(outEntry);
        zos.write(bytes2);
        zos.closeEntry();
    }

    private final void copyToOutput(InputStream zis, JarOutputStream zos, ZipEntry entry) {
        JarEntry outEntry;
        JarEntry jarEntry = outEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(entry.getName());
        if (entry.getTime() != -1L) {
            outEntry.setTime(entry.getTime());
        }
        zos.putNextEntry(outEntry);
        if (!entry.isDirectory()) {
            zis.transferTo(zos);
        }
        zos.closeEntry();
    }

    public static final /* synthetic */ ShrinkerDebugReporter access$getDebugReporter$p(ResourceShrinkerImpl $this) {
        return $this.debugReporter;
    }

    public static final /* synthetic */ List access$getUnused$p(ResourceShrinkerImpl $this) {
        return $this.unused;
    }
}

