/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.io.CancellableFileIo;
import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractPackageOperation;
import com.android.repository.util.InstallerUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractInstaller
extends AbstractPackageOperation
implements Installer {
    private final RemotePackage mPackage;
    private final Downloader mDownloader;
    private Path mInstallLocation = null;

    public AbstractInstaller(RemotePackage p, RepoManager manager, Downloader downloader) {
        super(manager);
        this.mPackage = p;
        this.mDownloader = downloader;
        this.registerStateChangeListener((op, progress) -> {
            if (this.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE) {
                try {
                    InstallerUtil.writePackageXml(this.getPackage(), this.getLocation(progress), this.getRepoManager(), progress);
                }
                catch (IOException e) {
                    progress.logWarning("Failed to update package.xml", e);
                    throw new PackageOperation.StatusChangeListenerException(e);
                }
            }
        });
    }

    @Override
    public RemotePackage getPackage() {
        return this.mPackage;
    }

    @Override
    public final Path getLocation(ProgressIndicator progress) {
        if (this.mInstallLocation == null) {
            this.mInstallLocation = this.computeInstallLocation(progress);
        }
        return this.mInstallLocation;
    }

    private Path computeInstallLocation(ProgressIndicator progress) {
        LocalPackage existing = this.getRepoManager().getPackages().getLocalPackages().get(this.mPackage.getPath());
        if (existing != null) {
            return existing.getLocation();
        }
        return this.getNonConflictingPath(progress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path getNonConflictingPath(ProgressIndicator progress) {
        Path dir = this.mPackage.getInstallDir(this.getRepoManager(), progress);
        if (!CancellableFileIo.exists((Path)dir, (LinkOption[])new LinkOption[0])) {
            return dir;
        }
        if (CancellableFileIo.isDirectory((Path)dir, (LinkOption[])new LinkOption[0])) {
            try (Stream<Path> fileStream2 = Files.list(dir);){
                List files = fileStream2.limit(2L).collect(Collectors.toList());
                if (files.isEmpty()) {
                    Path path = dir;
                    return path;
                }
                if (files.size() == 1 && ((Path)files.get(0)).getFileName().toString().equals(".installer")) {
                    Path path = dir;
                    return path;
                }
            }
            catch (IOException fileStream2) {
                // empty catch block
            }
        }
        LocalPackage conflicting = this.findConflictingPackage(dir, progress);
        String warning = "Package \"" + this.mPackage.getDisplayName() + "\" (" + this.mPackage.getPath() + ") should be installed in \n\"" + String.valueOf(dir) + "\" but \n";
        if (conflicting != null) {
            warning = warning + "\"" + conflicting.getDisplayName() + "\" (" + conflicting.getPath() + ") is already installed ";
            warning = conflicting.getLocation().equals(dir) ? warning + "there." : warning + "in \n\"" + String.valueOf(conflicting.getLocation()) + "\".";
        } else {
            warning = warning + "it already exists.";
        }
        Path parent = dir.getParent();
        String leaf = dir.getFileName().toString();
        int n = 2;
        while (true) {
            if (!CancellableFileIo.exists((Path)(dir = parent.resolve(leaf + "-" + n)), (LinkOption[])new LinkOption[0])) {
                warning = warning + "\nInstalling in \"" + String.valueOf(dir) + "\" instead.";
                progress.logWarning(warning);
                return dir;
            }
            ++n;
        }
    }

    private LocalPackage findConflictingPackage(Path dir, ProgressIndicator progress) {
        for (LocalPackage existing : this.getRepoManager().getPackages().getLocalPackages().values()) {
            String newLocation;
            String existingLocation = existing.getLocation().normalize().toString();
            if (!existingLocation.startsWith(newLocation = dir.toString()) && !newLocation.startsWith(existingLocation)) continue;
            return existing;
        }
        return null;
    }

    protected Downloader getDownloader() {
        return this.mDownloader;
    }

    @Override
    public String getName() {
        return String.format("Install %1$s", this.mPackage.getDetailedDisplayName());
    }
}

