/* Generated by wayland-scanner 1.23.1 */

#ifndef EXT_FOREIGN_TOPLEVEL_LIST_V1_SERVER_PROTOCOL_H
#define EXT_FOREIGN_TOPLEVEL_LIST_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_ext_foreign_toplevel_list_v1 The ext_foreign_toplevel_list_v1 protocol
 * list toplevels
 *
 * @section page_desc_ext_foreign_toplevel_list_v1 Description
 *
 * The purpose of this protocol is to provide protocol object handles for
 * toplevels, possibly originating from another client.
 *
 * This protocol is intentionally minimalistic and expects additional
 * functionality (e.g. creating a screencopy source from a toplevel handle,
 * getting information about the state of the toplevel) to be implemented
 * in extension protocols.
 *
 * The compositor may choose to restrict this protocol to a special client
 * launched by the compositor itself or expose it to all clients,
 * this is compositor policy.
 *
 * The key words "must", "must not", "required", "shall", "shall not",
 * "should", "should not", "recommended",  "may", and "optional" in this
 * document are to be interpreted as described in IETF RFC 2119.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 *
 * @section page_ifaces_ext_foreign_toplevel_list_v1 Interfaces
 * - @subpage page_iface_ext_foreign_toplevel_list_v1 - list toplevels
 * - @subpage page_iface_ext_foreign_toplevel_handle_v1 - a mapped toplevel
 * @section page_copyright_ext_foreign_toplevel_list_v1 Copyright
 * <pre>
 *
 * Copyright © 2018 Ilia Bozhinov
 * Copyright © 2020 Isaac Freund
 * Copyright © 2022 wb9688
 * Copyright © 2023 i509VCB
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct ext_foreign_toplevel_handle_v1;
struct ext_foreign_toplevel_list_v1;

#ifndef EXT_FOREIGN_TOPLEVEL_LIST_V1_INTERFACE
#define EXT_FOREIGN_TOPLEVEL_LIST_V1_INTERFACE
/**
 * @page page_iface_ext_foreign_toplevel_list_v1 ext_foreign_toplevel_list_v1
 * @section page_iface_ext_foreign_toplevel_list_v1_desc Description
 *
 * A toplevel is defined as a surface with a role similar to xdg_toplevel.
 * XWayland surfaces may be treated like toplevels in this protocol.
 *
 * After a client binds the ext_foreign_toplevel_list_v1, each mapped
 * toplevel window will be sent using the ext_foreign_toplevel_list_v1.toplevel
 * event.
 *
 * Clients which only care about the current state can perform a roundtrip after
 * binding this global.
 *
 * For each instance of ext_foreign_toplevel_list_v1, the compositor must
 * create a new ext_foreign_toplevel_handle_v1 object for each mapped toplevel.
 *
 * If a compositor implementation sends the ext_foreign_toplevel_list_v1.finished
 * event after the global is bound, the compositor must not send any
 * ext_foreign_toplevel_list_v1.toplevel events.
 * @section page_iface_ext_foreign_toplevel_list_v1_api API
 * See @ref iface_ext_foreign_toplevel_list_v1.
 */
/**
 * @defgroup iface_ext_foreign_toplevel_list_v1 The ext_foreign_toplevel_list_v1 interface
 *
 * A toplevel is defined as a surface with a role similar to xdg_toplevel.
 * XWayland surfaces may be treated like toplevels in this protocol.
 *
 * After a client binds the ext_foreign_toplevel_list_v1, each mapped
 * toplevel window will be sent using the ext_foreign_toplevel_list_v1.toplevel
 * event.
 *
 * Clients which only care about the current state can perform a roundtrip after
 * binding this global.
 *
 * For each instance of ext_foreign_toplevel_list_v1, the compositor must
 * create a new ext_foreign_toplevel_handle_v1 object for each mapped toplevel.
 *
 * If a compositor implementation sends the ext_foreign_toplevel_list_v1.finished
 * event after the global is bound, the compositor must not send any
 * ext_foreign_toplevel_list_v1.toplevel events.
 */
extern const struct wl_interface ext_foreign_toplevel_list_v1_interface;
#endif
#ifndef EXT_FOREIGN_TOPLEVEL_HANDLE_V1_INTERFACE
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_INTERFACE
/**
 * @page page_iface_ext_foreign_toplevel_handle_v1 ext_foreign_toplevel_handle_v1
 * @section page_iface_ext_foreign_toplevel_handle_v1_desc Description
 *
 * A ext_foreign_toplevel_handle_v1 object represents a mapped toplevel
 * window. A single app may have multiple mapped toplevels.
 * @section page_iface_ext_foreign_toplevel_handle_v1_api API
 * See @ref iface_ext_foreign_toplevel_handle_v1.
 */
/**
 * @defgroup iface_ext_foreign_toplevel_handle_v1 The ext_foreign_toplevel_handle_v1 interface
 *
 * A ext_foreign_toplevel_handle_v1 object represents a mapped toplevel
 * window. A single app may have multiple mapped toplevels.
 */
extern const struct wl_interface ext_foreign_toplevel_handle_v1_interface;
#endif

/**
 * @ingroup iface_ext_foreign_toplevel_list_v1
 * @struct ext_foreign_toplevel_list_v1_interface
 */
struct ext_foreign_toplevel_list_v1_interface {
	/**
	 * stop sending events
	 *
	 * This request indicates that the client no longer wishes to
	 * receive events for new toplevels.
	 *
	 * The Wayland protocol is asynchronous, meaning the compositor may
	 * send further toplevel events until the stop request is
	 * processed. The client should wait for a
	 * ext_foreign_toplevel_list_v1.finished event before destroying
	 * this object.
	 */
	void (*stop)(struct wl_client *client,
		     struct wl_resource *resource);
	/**
	 * destroy the ext_foreign_toplevel_list_v1 object
	 *
	 * This request should be called either when the client will no
	 * longer use the ext_foreign_toplevel_list_v1 or after the
	 * finished event has been received to allow destruction of the
	 * object.
	 *
	 * If a client wishes to destroy this object it should send a
	 * ext_foreign_toplevel_list_v1.stop request and wait for a
	 * ext_foreign_toplevel_list_v1.finished event, then destroy the
	 * handles and then this object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define EXT_FOREIGN_TOPLEVEL_LIST_V1_TOPLEVEL 0
#define EXT_FOREIGN_TOPLEVEL_LIST_V1_FINISHED 1

/**
 * @ingroup iface_ext_foreign_toplevel_list_v1
 */
#define EXT_FOREIGN_TOPLEVEL_LIST_V1_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_ext_foreign_toplevel_list_v1
 */
#define EXT_FOREIGN_TOPLEVEL_LIST_V1_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_foreign_toplevel_list_v1
 */
#define EXT_FOREIGN_TOPLEVEL_LIST_V1_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_ext_foreign_toplevel_list_v1
 */
#define EXT_FOREIGN_TOPLEVEL_LIST_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_ext_foreign_toplevel_list_v1
 * Sends an toplevel event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_foreign_toplevel_list_v1_send_toplevel(struct wl_resource *resource_, struct wl_resource *toplevel)
{
	wl_resource_post_event(resource_, EXT_FOREIGN_TOPLEVEL_LIST_V1_TOPLEVEL, toplevel);
}

/**
 * @ingroup iface_ext_foreign_toplevel_list_v1
 * Sends an finished event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_foreign_toplevel_list_v1_send_finished(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_FOREIGN_TOPLEVEL_LIST_V1_FINISHED);
}

/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 * @struct ext_foreign_toplevel_handle_v1_interface
 */
struct ext_foreign_toplevel_handle_v1_interface {
	/**
	 * destroy the ext_foreign_toplevel_handle_v1 object
	 *
	 * This request should be used when the client will no longer use
	 * the handle or after the closed event has been received to allow
	 * destruction of the object.
	 *
	 * When a handle is destroyed, a new handle may not be created by
	 * the server until the toplevel is unmapped and then remapped.
	 * Destroying a toplevel handle is not recommended unless the
	 * client is cleaning up child objects before destroying the
	 * ext_foreign_toplevel_list_v1 object, the toplevel was closed or
	 * the toplevel handle will not be used in the future.
	 *
	 * Other protocols which extend the ext_foreign_toplevel_handle_v1
	 * interface should require destructors for extension interfaces be
	 * called before allowing the toplevel handle to be destroyed.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED 0
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_DONE 1
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE 2
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID 3
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_IDENTIFIER 4

/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 */
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED_SINCE_VERSION 1
/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 */
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 */
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 */
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 */
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_IDENTIFIER_SINCE_VERSION 1

/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 */
#define EXT_FOREIGN_TOPLEVEL_HANDLE_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 * Sends an closed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_foreign_toplevel_handle_v1_send_closed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED);
}

/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_foreign_toplevel_handle_v1_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_FOREIGN_TOPLEVEL_HANDLE_V1_DONE);
}

/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 * Sends an title event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_foreign_toplevel_handle_v1_send_title(struct wl_resource *resource_, const char *title)
{
	wl_resource_post_event(resource_, EXT_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE, title);
}

/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 * Sends an app_id event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_foreign_toplevel_handle_v1_send_app_id(struct wl_resource *resource_, const char *app_id)
{
	wl_resource_post_event(resource_, EXT_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID, app_id);
}

/**
 * @ingroup iface_ext_foreign_toplevel_handle_v1
 * Sends an identifier event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_foreign_toplevel_handle_v1_send_identifier(struct wl_resource *resource_, const char *identifier)
{
	wl_resource_post_event(resource_, EXT_FOREIGN_TOPLEVEL_HANDLE_V1_IDENTIFIER, identifier);
}

#ifdef  __cplusplus
}
#endif

#endif
