/* Generated by wayland-scanner 1.23.1 */

#ifndef EXT_TRANSIENT_SEAT_V1_SERVER_PROTOCOL_H
#define EXT_TRANSIENT_SEAT_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_ext_transient_seat_v1 The ext_transient_seat_v1 protocol
 * protocol for creating temporary seats
 *
 * @section page_desc_ext_transient_seat_v1 Description
 *
 * The transient seat protocol can be used by privileged clients to create
 * independent seats that will be removed from the compositor when the client
 * destroys its transient seat.
 *
 * This protocol is intended for use with virtual input protocols such as
 * "virtual_keyboard_unstable_v1" or "wlr_virtual_pointer_unstable_v1", both
 * of which allow the user to select a seat.
 *
 * The "wl_seat" global created by this protocol does not generate input events
 * on its own, or have any capabilities except those assigned to it by other
 * protocol extensions, such as the ones mentioned above.
 *
 * For example, a remote desktop server can create a seat with virtual inputs
 * for each remote user by following these steps for each new connection:
 * * Create a transient seat
 * * Wait for the transient seat to be created
 * * Locate a "wl_seat" global with a matching name
 * * Create virtual inputs using the resulting "wl_seat" global
 *
 * @section page_ifaces_ext_transient_seat_v1 Interfaces
 * - @subpage page_iface_ext_transient_seat_manager_v1 - transient seat manager
 * - @subpage page_iface_ext_transient_seat_v1 - transient seat handle
 * @section page_copyright_ext_transient_seat_v1 Copyright
 * <pre>
 *
 * Copyright © 2020 - 2023 Andri Yngvason
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct ext_transient_seat_manager_v1;
struct ext_transient_seat_v1;

#ifndef EXT_TRANSIENT_SEAT_MANAGER_V1_INTERFACE
#define EXT_TRANSIENT_SEAT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ext_transient_seat_manager_v1 ext_transient_seat_manager_v1
 * @section page_iface_ext_transient_seat_manager_v1_desc Description
 *
 * The transient seat manager creates short-lived seats.
 * @section page_iface_ext_transient_seat_manager_v1_api API
 * See @ref iface_ext_transient_seat_manager_v1.
 */
/**
 * @defgroup iface_ext_transient_seat_manager_v1 The ext_transient_seat_manager_v1 interface
 *
 * The transient seat manager creates short-lived seats.
 */
extern const struct wl_interface ext_transient_seat_manager_v1_interface;
#endif
#ifndef EXT_TRANSIENT_SEAT_V1_INTERFACE
#define EXT_TRANSIENT_SEAT_V1_INTERFACE
/**
 * @page page_iface_ext_transient_seat_v1 ext_transient_seat_v1
 * @section page_iface_ext_transient_seat_v1_desc Description
 *
 * When the transient seat handle is destroyed, the seat itself will also be
 * destroyed.
 * @section page_iface_ext_transient_seat_v1_api API
 * See @ref iface_ext_transient_seat_v1.
 */
/**
 * @defgroup iface_ext_transient_seat_v1 The ext_transient_seat_v1 interface
 *
 * When the transient seat handle is destroyed, the seat itself will also be
 * destroyed.
 */
extern const struct wl_interface ext_transient_seat_v1_interface;
#endif

/**
 * @ingroup iface_ext_transient_seat_manager_v1
 * @struct ext_transient_seat_manager_v1_interface
 */
struct ext_transient_seat_manager_v1_interface {
	/**
	 * create a transient seat
	 *
	 * Create a new seat that is removed when the client side
	 * transient seat object is destroyed.
	 *
	 * The actual seat may be removed sooner, in which case the
	 * transient seat object shall become inert.
	 */
	void (*create)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t seat);
	/**
	 * destroy the manager
	 *
	 * Destroy the manager.
	 *
	 * All objects created by the manager will remain valid until they
	 * are destroyed themselves.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_ext_transient_seat_manager_v1
 */
#define EXT_TRANSIENT_SEAT_MANAGER_V1_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_transient_seat_manager_v1
 */
#define EXT_TRANSIENT_SEAT_MANAGER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_ext_transient_seat_v1
 * @struct ext_transient_seat_v1_interface
 */
struct ext_transient_seat_v1_interface {
	/**
	 * destroy transient seat
	 *
	 * When the transient seat object is destroyed by the client, the
	 * associated seat created by the compositor is also destroyed.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define EXT_TRANSIENT_SEAT_V1_READY 0
#define EXT_TRANSIENT_SEAT_V1_DENIED 1

/**
 * @ingroup iface_ext_transient_seat_v1
 */
#define EXT_TRANSIENT_SEAT_V1_READY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_transient_seat_v1
 */
#define EXT_TRANSIENT_SEAT_V1_DENIED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_transient_seat_v1
 */
#define EXT_TRANSIENT_SEAT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_ext_transient_seat_v1
 * Sends an ready event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_transient_seat_v1_send_ready(struct wl_resource *resource_, uint32_t global_name)
{
	wl_resource_post_event(resource_, EXT_TRANSIENT_SEAT_V1_READY, global_name);
}

/**
 * @ingroup iface_ext_transient_seat_v1
 * Sends an denied event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_transient_seat_v1_send_denied(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_TRANSIENT_SEAT_V1_DENIED);
}

#ifdef  __cplusplus
}
#endif

#endif
