/* Generated by wayland-scanner 1.23.1 */

#ifndef WLR_DATA_CONTROL_UNSTABLE_V1_SERVER_PROTOCOL_H
#define WLR_DATA_CONTROL_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_wlr_data_control_unstable_v1 The wlr_data_control_unstable_v1 protocol
 * control data devices
 *
 * @section page_desc_wlr_data_control_unstable_v1 Description
 *
 * This protocol allows a privileged client to control data devices. In
 * particular, the client will be able to manage the current selection and take
 * the role of a clipboard manager.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * @section page_ifaces_wlr_data_control_unstable_v1 Interfaces
 * - @subpage page_iface_zwlr_data_control_manager_v1 - manager to control data devices
 * - @subpage page_iface_zwlr_data_control_device_v1 - manage a data device for a seat
 * - @subpage page_iface_zwlr_data_control_source_v1 - offer to transfer data
 * - @subpage page_iface_zwlr_data_control_offer_v1 - offer to transfer data
 * @section page_copyright_wlr_data_control_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2018 Simon Ser
 * Copyright © 2019 Ivan Molodetskikh
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct wl_seat;
struct zwlr_data_control_device_v1;
struct zwlr_data_control_manager_v1;
struct zwlr_data_control_offer_v1;
struct zwlr_data_control_source_v1;

#ifndef ZWLR_DATA_CONTROL_MANAGER_V1_INTERFACE
#define ZWLR_DATA_CONTROL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zwlr_data_control_manager_v1 zwlr_data_control_manager_v1
 * @section page_iface_zwlr_data_control_manager_v1_desc Description
 *
 * This interface is a manager that allows creating per-seat data device
 * controls.
 * @section page_iface_zwlr_data_control_manager_v1_api API
 * See @ref iface_zwlr_data_control_manager_v1.
 */
/**
 * @defgroup iface_zwlr_data_control_manager_v1 The zwlr_data_control_manager_v1 interface
 *
 * This interface is a manager that allows creating per-seat data device
 * controls.
 */
extern const struct wl_interface zwlr_data_control_manager_v1_interface;
#endif
#ifndef ZWLR_DATA_CONTROL_DEVICE_V1_INTERFACE
#define ZWLR_DATA_CONTROL_DEVICE_V1_INTERFACE
/**
 * @page page_iface_zwlr_data_control_device_v1 zwlr_data_control_device_v1
 * @section page_iface_zwlr_data_control_device_v1_desc Description
 *
 * This interface allows a client to manage a seat's selection.
 *
 * When the seat is destroyed, this object becomes inert.
 * @section page_iface_zwlr_data_control_device_v1_api API
 * See @ref iface_zwlr_data_control_device_v1.
 */
/**
 * @defgroup iface_zwlr_data_control_device_v1 The zwlr_data_control_device_v1 interface
 *
 * This interface allows a client to manage a seat's selection.
 *
 * When the seat is destroyed, this object becomes inert.
 */
extern const struct wl_interface zwlr_data_control_device_v1_interface;
#endif
#ifndef ZWLR_DATA_CONTROL_SOURCE_V1_INTERFACE
#define ZWLR_DATA_CONTROL_SOURCE_V1_INTERFACE
/**
 * @page page_iface_zwlr_data_control_source_v1 zwlr_data_control_source_v1
 * @section page_iface_zwlr_data_control_source_v1_desc Description
 *
 * The wlr_data_control_source object is the source side of a
 * wlr_data_control_offer. It is created by the source client in a data
 * transfer and provides a way to describe the offered data and a way to
 * respond to requests to transfer the data.
 * @section page_iface_zwlr_data_control_source_v1_api API
 * See @ref iface_zwlr_data_control_source_v1.
 */
/**
 * @defgroup iface_zwlr_data_control_source_v1 The zwlr_data_control_source_v1 interface
 *
 * The wlr_data_control_source object is the source side of a
 * wlr_data_control_offer. It is created by the source client in a data
 * transfer and provides a way to describe the offered data and a way to
 * respond to requests to transfer the data.
 */
extern const struct wl_interface zwlr_data_control_source_v1_interface;
#endif
#ifndef ZWLR_DATA_CONTROL_OFFER_V1_INTERFACE
#define ZWLR_DATA_CONTROL_OFFER_V1_INTERFACE
/**
 * @page page_iface_zwlr_data_control_offer_v1 zwlr_data_control_offer_v1
 * @section page_iface_zwlr_data_control_offer_v1_desc Description
 *
 * A wlr_data_control_offer represents a piece of data offered for transfer
 * by another client (the source client). The offer describes the different
 * MIME types that the data can be converted to and provides the mechanism
 * for transferring the data directly from the source client.
 * @section page_iface_zwlr_data_control_offer_v1_api API
 * See @ref iface_zwlr_data_control_offer_v1.
 */
/**
 * @defgroup iface_zwlr_data_control_offer_v1 The zwlr_data_control_offer_v1 interface
 *
 * A wlr_data_control_offer represents a piece of data offered for transfer
 * by another client (the source client). The offer describes the different
 * MIME types that the data can be converted to and provides the mechanism
 * for transferring the data directly from the source client.
 */
extern const struct wl_interface zwlr_data_control_offer_v1_interface;
#endif

/**
 * @ingroup iface_zwlr_data_control_manager_v1
 * @struct zwlr_data_control_manager_v1_interface
 */
struct zwlr_data_control_manager_v1_interface {
	/**
	 * create a new data source
	 *
	 * Create a new data source.
	 * @param id data source to create
	 */
	void (*create_data_source)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t id);
	/**
	 * get a data device for a seat
	 *
	 * Create a data device that can be used to manage a seat's
	 * selection.
	 */
	void (*get_data_device)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t id,
				struct wl_resource *seat);
	/**
	 * destroy the manager
	 *
	 * All objects created by the manager will still remain valid,
	 * until their appropriate destroy request has been called.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_zwlr_data_control_manager_v1
 */
#define ZWLR_DATA_CONTROL_MANAGER_V1_CREATE_DATA_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_manager_v1
 */
#define ZWLR_DATA_CONTROL_MANAGER_V1_GET_DATA_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_manager_v1
 */
#define ZWLR_DATA_CONTROL_MANAGER_V1_DESTROY_SINCE_VERSION 1

#ifndef ZWLR_DATA_CONTROL_DEVICE_V1_ERROR_ENUM
#define ZWLR_DATA_CONTROL_DEVICE_V1_ERROR_ENUM
enum zwlr_data_control_device_v1_error {
	/**
	 * source given to set_selection or set_primary_selection was already used before
	 */
	ZWLR_DATA_CONTROL_DEVICE_V1_ERROR_USED_SOURCE = 1,
};
/**
 * @ingroup iface_zwlr_data_control_device_v1
 * Validate a zwlr_data_control_device_v1 error value.
 *
 * @return true on success, false on error.
 * @ref zwlr_data_control_device_v1_error
 */
static inline bool
zwlr_data_control_device_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWLR_DATA_CONTROL_DEVICE_V1_ERROR_USED_SOURCE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWLR_DATA_CONTROL_DEVICE_V1_ERROR_ENUM */

/**
 * @ingroup iface_zwlr_data_control_device_v1
 * @struct zwlr_data_control_device_v1_interface
 */
struct zwlr_data_control_device_v1_interface {
	/**
	 * copy data to the selection
	 *
	 * This request asks the compositor to set the selection to the
	 * data from the source on behalf of the client.
	 *
	 * The given source may not be used in any further set_selection or
	 * set_primary_selection requests. Attempting to use a previously
	 * used source is a protocol error.
	 *
	 * To unset the selection, set the source to NULL.
	 */
	void (*set_selection)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_resource *source);
	/**
	 * destroy this data device
	 *
	 * Destroys the data device object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * copy data to the primary selection
	 *
	 * This request asks the compositor to set the primary selection
	 * to the data from the source on behalf of the client.
	 *
	 * The given source may not be used in any further set_selection or
	 * set_primary_selection requests. Attempting to use a previously
	 * used source is a protocol error.
	 *
	 * To unset the primary selection, set the source to NULL.
	 *
	 * The compositor will ignore this request if it does not support
	 * primary selection.
	 * @since 2
	 */
	void (*set_primary_selection)(struct wl_client *client,
				      struct wl_resource *resource,
				      struct wl_resource *source);
};

#define ZWLR_DATA_CONTROL_DEVICE_V1_DATA_OFFER 0
#define ZWLR_DATA_CONTROL_DEVICE_V1_SELECTION 1
#define ZWLR_DATA_CONTROL_DEVICE_V1_FINISHED 2
#define ZWLR_DATA_CONTROL_DEVICE_V1_PRIMARY_SELECTION 3

/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_DATA_OFFER_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_SELECTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_FINISHED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_PRIMARY_SELECTION_SINCE_VERSION 2

/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_SET_SELECTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_SET_PRIMARY_SELECTION_SINCE_VERSION 2

/**
 * @ingroup iface_zwlr_data_control_device_v1
 * Sends an data_offer event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_data_control_device_v1_send_data_offer(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, ZWLR_DATA_CONTROL_DEVICE_V1_DATA_OFFER, id);
}

/**
 * @ingroup iface_zwlr_data_control_device_v1
 * Sends an selection event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_data_control_device_v1_send_selection(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, ZWLR_DATA_CONTROL_DEVICE_V1_SELECTION, id);
}

/**
 * @ingroup iface_zwlr_data_control_device_v1
 * Sends an finished event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_data_control_device_v1_send_finished(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWLR_DATA_CONTROL_DEVICE_V1_FINISHED);
}

/**
 * @ingroup iface_zwlr_data_control_device_v1
 * Sends an primary_selection event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_data_control_device_v1_send_primary_selection(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, ZWLR_DATA_CONTROL_DEVICE_V1_PRIMARY_SELECTION, id);
}

#ifndef ZWLR_DATA_CONTROL_SOURCE_V1_ERROR_ENUM
#define ZWLR_DATA_CONTROL_SOURCE_V1_ERROR_ENUM
enum zwlr_data_control_source_v1_error {
	/**
	 * offer sent after wlr_data_control_device.set_selection
	 */
	ZWLR_DATA_CONTROL_SOURCE_V1_ERROR_INVALID_OFFER = 1,
};
/**
 * @ingroup iface_zwlr_data_control_source_v1
 * Validate a zwlr_data_control_source_v1 error value.
 *
 * @return true on success, false on error.
 * @ref zwlr_data_control_source_v1_error
 */
static inline bool
zwlr_data_control_source_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWLR_DATA_CONTROL_SOURCE_V1_ERROR_INVALID_OFFER:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWLR_DATA_CONTROL_SOURCE_V1_ERROR_ENUM */

/**
 * @ingroup iface_zwlr_data_control_source_v1
 * @struct zwlr_data_control_source_v1_interface
 */
struct zwlr_data_control_source_v1_interface {
	/**
	 * add an offered MIME type
	 *
	 * This request adds a MIME type to the set of MIME types
	 * advertised to targets. Can be called several times to offer
	 * multiple types.
	 *
	 * Calling this after wlr_data_control_device.set_selection is a
	 * protocol error.
	 * @param mime_type MIME type offered by the data source
	 */
	void (*offer)(struct wl_client *client,
		      struct wl_resource *resource,
		      const char *mime_type);
	/**
	 * destroy this source
	 *
	 * Destroys the data source object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWLR_DATA_CONTROL_SOURCE_V1_SEND 0
#define ZWLR_DATA_CONTROL_SOURCE_V1_CANCELLED 1

/**
 * @ingroup iface_zwlr_data_control_source_v1
 */
#define ZWLR_DATA_CONTROL_SOURCE_V1_SEND_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_source_v1
 */
#define ZWLR_DATA_CONTROL_SOURCE_V1_CANCELLED_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_data_control_source_v1
 */
#define ZWLR_DATA_CONTROL_SOURCE_V1_OFFER_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_source_v1
 */
#define ZWLR_DATA_CONTROL_SOURCE_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_data_control_source_v1
 * Sends an send event to the client owning the resource.
 * @param resource_ The client's resource
 * @param mime_type MIME type for the data
 * @param fd file descriptor for the data
 */
static inline void
zwlr_data_control_source_v1_send_send(struct wl_resource *resource_, const char *mime_type, int32_t fd)
{
	wl_resource_post_event(resource_, ZWLR_DATA_CONTROL_SOURCE_V1_SEND, mime_type, fd);
}

/**
 * @ingroup iface_zwlr_data_control_source_v1
 * Sends an cancelled event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_data_control_source_v1_send_cancelled(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWLR_DATA_CONTROL_SOURCE_V1_CANCELLED);
}

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 * @struct zwlr_data_control_offer_v1_interface
 */
struct zwlr_data_control_offer_v1_interface {
	/**
	 * request that the data is transferred
	 *
	 * To transfer the offered data, the client issues this request
	 * and indicates the MIME type it wants to receive. The transfer
	 * happens through the passed file descriptor (typically created
	 * with the pipe system call). The source client writes the data in
	 * the MIME type representation requested and then closes the file
	 * descriptor.
	 *
	 * The receiving client reads from the read end of the pipe until
	 * EOF and then closes its end, at which point the transfer is
	 * complete.
	 *
	 * This request may happen multiple times for different MIME types.
	 * @param mime_type MIME type desired by receiver
	 * @param fd file descriptor for data transfer
	 */
	void (*receive)(struct wl_client *client,
			struct wl_resource *resource,
			const char *mime_type,
			int32_t fd);
	/**
	 * destroy this offer
	 *
	 * Destroys the data offer object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWLR_DATA_CONTROL_OFFER_V1_OFFER 0

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 */
#define ZWLR_DATA_CONTROL_OFFER_V1_OFFER_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 */
#define ZWLR_DATA_CONTROL_OFFER_V1_RECEIVE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_offer_v1
 */
#define ZWLR_DATA_CONTROL_OFFER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 * Sends an offer event to the client owning the resource.
 * @param resource_ The client's resource
 * @param mime_type offered MIME type
 */
static inline void
zwlr_data_control_offer_v1_send_offer(struct wl_resource *resource_, const char *mime_type)
{
	wl_resource_post_event(resource_, ZWLR_DATA_CONTROL_OFFER_V1_OFFER, mime_type);
}

#ifdef  __cplusplus
}
#endif

#endif
